/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class TransferItemsMessage {
    private final boolean transferToInventory;
    private final boolean filterByContents;

    public TransferItemsMessage(boolean transferToInventory, boolean filterByContents) {
        this.transferToInventory = transferToInventory;
        this.filterByContents = filterByContents;
    }

    public static TransferItemsMessage decode(FriendlyByteBuf packetBuffer) {
        return new TransferItemsMessage(packetBuffer.readBoolean(), packetBuffer.readBoolean());
    }

    public static void encode(TransferItemsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeBoolean(msg.transferToInventory);
        packetBuffer.writeBoolean(msg.filterByContents);
    }

    public static void onMessage(TransferItemsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransferItemsMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(ServerPlayer player, TransferItemsMessage msg) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)abstractContainerMenu;
        Object storageWrapper = storageMenu.getStorageWrapper();
        if (msg.transferToInventory) {
            if (msg.filterByContents) {
                TransferItemsMessage.mergeToPlayersInventoryFiltered((Player)player, storageWrapper);
            } else {
                TransferItemsMessage.mergeToPlayersInventory(storageWrapper, (Player)player);
            }
        } else {
            InventoryHelper.transfer((IItemHandler)new PlayerMainInvWithoutHotbarWrapper(player.m_150109_()), new FilteredStorageItemHandler((IStorageWrapper)storageWrapper, msg.filterByContents), s -> {});
        }
    }

    private static void mergeToPlayersInventory(IStorageWrapper storageWrapper, Player player) {
        InventoryHelper.iterate((IItemHandler)storageWrapper.getInventoryHandler(), (slot, stack) -> {
            if (stack.m_41619_()) {
                return;
            }
            ItemStack result = InventoryHelper.mergeIntoPlayerInventory(player, stack, 9);
            if (result.m_41613_() != stack.m_41613_()) {
                storageWrapper.getInventoryHandler().setStackInSlot((int)slot, result);
            }
        });
    }

    private static void mergeToPlayersInventoryFiltered(Player player, IStorageWrapper storageWrapper) {
        Set<ItemStackKey> uniqueStacks = InventoryHelper.getUniqueStacks((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()));
        InventoryHelper.iterate((IItemHandler)storageWrapper.getInventoryHandler(), (slot, stack) -> {
            if (stack.m_41619_() || !uniqueStacks.contains(ItemStackKey.of(stack))) {
                return;
            }
            ItemStack result = InventoryHelper.mergeIntoPlayerInventory(player, stack, 0);
            if (result.m_41613_() != stack.m_41613_()) {
                storageWrapper.getInventoryHandler().setStackInSlot((int)slot, result);
            }
        });
    }

    public boolean transferToInventory() {
        return this.transferToInventory;
    }

    public boolean filterByContents() {
        return this.filterByContents;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransferItemsMessage that = (TransferItemsMessage)obj;
        return this.transferToInventory == that.transferToInventory && this.filterByContents == that.filterByContents;
    }

    public int hashCode() {
        return Objects.hash(this.transferToInventory, this.filterByContents);
    }

    public String toString() {
        return "TransferItemsMessage[transferToInventory=" + this.transferToInventory + ", filterByContents=" + this.filterByContents + "]";
    }

    private static class PlayerMainInvWithoutHotbarWrapper
    extends InvWrapper {
        private final int minSlot;
        private final int maxSlot;
        private final Inventory inventoryPlayer;

        public PlayerMainInvWithoutHotbarWrapper(Inventory inv) {
            super((Container)inv);
            this.inventoryPlayer = inv;
            this.minSlot = 9;
            this.maxSlot = inv.f_35974_.size();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack inSlot;
            ItemStack rest = super.insertItem(slot, stack, simulate);
            if (rest.m_41613_() != stack.m_41613_() && !(inSlot = this.getStackInSlot(slot)).m_41619_()) {
                if (this.inventoryPlayer.f_35978_.m_9236_().f_46443_) {
                    inSlot.m_41754_(5);
                } else if (this.inventoryPlayer.f_35978_ instanceof ServerPlayer) {
                    this.inventoryPlayer.f_35978_.f_36096_.m_38946_();
                }
            }
            return rest;
        }

        public int getSlots() {
            return this.maxSlot - this.minSlot;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.checkSlot(slot) ? super.getStackInSlot(slot + this.minSlot) : ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.checkSlot(slot) ? super.extractItem(slot + this.minSlot, amount, simulate) : ItemStack.f_41583_;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (this.checkSlot(slot)) {
                super.setStackInSlot(slot + this.minSlot, stack);
            }
        }

        public int getSlotLimit(int slot) {
            return this.checkSlot(slot) ? super.getSlotLimit(slot + this.minSlot) : 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.checkSlot(slot) && super.isItemValid(slot + this.minSlot, stack);
        }

        private boolean checkSlot(int localSlot) {
            return localSlot + this.minSlot < this.maxSlot;
        }
    }

    private static class FilteredStorageItemHandler
    extends FilteredItemHandler<ITrackedContentsItemHandler>
    implements IItemHandlerSimpleInserter {
        private final IStorageWrapper storageWrapper;

        public FilteredStorageItemHandler(IStorageWrapper storageWrapper, boolean smart) {
            super(storageWrapper.getInventoryHandler(), smart);
            this.storageWrapper = storageWrapper;
        }

        @Override
        protected Set<ItemStackKey> getUniqueStacks(ITrackedContentsItemHandler itemHandler) {
            return itemHandler.getTrackedStacks();
        }

        @Override
        protected boolean matchesFilter(ItemStack stack) {
            return super.matchesFilter(stack) || this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(stack);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (!this.matchContents || this.matchesFilter(stack)) {
                return ((ITrackedContentsItemHandler)this.itemHandler).insertItem(stack, simulate);
            }
            return stack;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ((ITrackedContentsItemHandler)this.itemHandler).setStackInSlot(slot, stack);
        }
    }

    private static class FilteredItemHandler<T extends IItemHandler>
    implements IItemHandler {
        protected final T itemHandler;
        protected final boolean matchContents;
        private final Set<ItemStackKey> uniqueStacks;

        public FilteredItemHandler(T itemHandler, boolean matchContents) {
            this.itemHandler = itemHandler;
            this.matchContents = matchContents;
            this.uniqueStacks = this.getUniqueStacks(itemHandler);
        }

        protected Set<ItemStackKey> getUniqueStacks(T itemHandler) {
            return InventoryHelper.getUniqueStacks(itemHandler);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.matchContents || this.matchesFilter(stack)) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected boolean matchesFilter(ItemStack stack) {
            return this.uniqueStacks.contains(ItemStackKey.of(stack));
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.itemHandler.isItemValid(slot, stack);
        }
    }
}

