/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;

public class SyncDatapackSettingsTemplateMessage {
    private final String datapack;
    private final String templateName;
    private final CompoundTag settingsNbt;

    public SyncDatapackSettingsTemplateMessage(String datapack, String templateName, @Nullable CompoundTag settingsNbt) {
        this.datapack = datapack;
        this.templateName = templateName;
        this.settingsNbt = settingsNbt;
    }

    public static void encode(SyncDatapackSettingsTemplateMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(msg.datapack);
        packetBuffer.m_130070_(msg.templateName);
        packetBuffer.m_130079_(msg.settingsNbt);
    }

    public static SyncDatapackSettingsTemplateMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncDatapackSettingsTemplateMessage(packetBuffer.m_130277_(), packetBuffer.m_130277_(), packetBuffer.m_130260_());
    }

    public static void onMessage(SyncDatapackSettingsTemplateMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncDatapackSettingsTemplateMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(SyncDatapackSettingsTemplateMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        DatapackSettingsTemplateManager.putTemplate(message.datapack, message.templateName, message.settingsNbt);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof SettingsContainerMenu) {
            SettingsContainerMenu settingsContainerMenu = (SettingsContainerMenu)abstractContainerMenu;
            settingsContainerMenu.refreshTemplateSlots();
        }
    }
}

