/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiRecipeFiller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.emi.EmiTransferRecipeMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;

public class EmiGridMenuInfo<C extends StorageContainerMenuBase<?>>
implements StandardRecipeHandler<C> {
    private final RecipeType<? extends Recipe<?>> recipeType;

    public static <C extends StorageContainerMenuBase<?>> EmiGridMenuInfo<C> crafting() {
        return new EmiGridMenuInfo<C>(RecipeType.f_44107_);
    }

    public static <C extends StorageContainerMenuBase<?>> EmiGridMenuInfo<C> smithing() {
        return new EmiGridMenuInfo<C>(RecipeType.f_44113_);
    }

    private EmiGridMenuInfo(RecipeType<? extends Recipe<?>> recipeType) {
        this.recipeType = recipeType;
    }

    public List<Slot> getInputSources(C handler) {
        ArrayList<Slot> slots = new ArrayList<Slot>(((StorageContainerMenuBase)handler).realInventorySlots.stream().filter(s -> s.m_8010_((Player)Minecraft.m_91087_().f_91074_)).toList());
        slots.addAll(this.getCraftingSlots(handler));
        return slots;
    }

    public List<Slot> getCraftingSlots(C handler) {
        List<Object> list;
        UpgradeContainerBase openOrFirstCraftingContainer = ((StorageContainerMenuBase)handler).getOpenOrFirstCraftingContainer(this.recipeType).orElse(null);
        if (openOrFirstCraftingContainer instanceof ICraftingContainer) {
            ICraftingContainer cc = (ICraftingContainer)((Object)openOrFirstCraftingContainer);
            list = cc.getRecipeSlots();
        } else {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    @Nullable
    public Slot getOutputSlot(C handler) {
        return ((StorageContainerMenuBase)handler).getOpenOrFirstCraftingContainer(this.recipeType).map(c -> {
            List<Slot> slots = c.getSlots();
            return slots.get(slots.size() - 1);
        }).orElse(null);
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return VanillaEmiRecipeCategories.CRAFTING.equals(recipe.getCategory()) && recipe.supportsRecipeTree();
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<C> context) {
        return ((StorageContainerMenuBase)context.getScreenHandler()).getOpenOrFirstCraftingContainer(this.recipeType).isPresent() && super.canCraft(recipe, context);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<C> context) {
        List stacks = EmiRecipeFiller.getStacks((StandardRecipeHandler)this, (EmiRecipe)recipe, (AbstractContainerScreen)context.getScreen(), (int)1);
        if (stacks != null) {
            StorageContainerMenuBase container = (StorageContainerMenuBase)context.getScreenHandler();
            Optional potentialCraftingContainer = container.getOpenOrFirstCraftingContainer(this.recipeType);
            UpgradeContainerBase openOrFirstCraftingContainer = (UpgradeContainerBase)potentialCraftingContainer.get();
            if (!openOrFirstCraftingContainer.isOpen()) {
                container.getOpenContainer().ifPresent(c -> {
                    c.setIsOpen(false);
                    container.setOpenTabId(-1);
                });
                openOrFirstCraftingContainer.setIsOpen(true);
                container.setOpenTabId(openOrFirstCraftingContainer.getUpgradeContainerId());
            }
            Minecraft.m_91087_().m_91152_((Screen)context.getScreen());
            if (!EmiClient.onServer) {
                return EmiRecipeFiller.clientFill((StandardRecipeHandler)this, (EmiRecipe)recipe, (AbstractContainerScreen)context.getScreen(), (List)stacks, (EmiCraftContext.Destination)context.getDestination());
            }
            int action = switch (context.getDestination()) {
                default -> throw new IncompatibleClassChangeError();
                case EmiCraftContext.Destination.NONE -> 0;
                case EmiCraftContext.Destination.CURSOR -> 1;
                case EmiCraftContext.Destination.INVENTORY -> 2;
            };
            ResourceLocation recipeTypeId = BuiltInRegistries.f_256990_.m_7981_(this.recipeType);
            if (recipeTypeId != null) {
                Slot output = this.getOutputSlot((C)container);
                PacketHandler.INSTANCE.sendToServer(new EmiTransferRecipeMessage(recipe.getId(), recipeTypeId, action, this.getInputSources((C)container).stream().map(s -> s == null ? -1 : s.f_40219_).toList(), this.getCraftingSlots(recipe, container).stream().map(s -> s == null ? -1 : s.f_40219_).toList(), output == null ? -1 : output.f_40219_, stacks, context.getAmount() > 1));
            }
            return true;
        }
        return false;
    }
}

