/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.util.InstanceRecycler;
import dev.engine_room.vanillin.item.ItemModels;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import org.joml.Vector3fc;

public class ItemVisual
extends AbstractEntityVisual<ItemEntity>
implements SimpleDynamicVisual {
    private static final ThreadLocal<RandomSource> RANDOM = ThreadLocal.withInitial(RandomSource::m_216343_);
    private final PoseStack pPoseStack = new PoseStack();
    private final BakedModel bakedModel;
    private final InstanceRecycler<TransformedInstance> instances;

    public ItemVisual(VisualizationContext ctx, ItemEntity entity, float partialTick) {
        super(ctx, (Entity)entity, partialTick);
        ItemStack item = entity.m_32055_();
        this.bakedModel = ItemModels.getModel(item);
        Model model = ItemModels.get(this.level, item, ItemDisplayContext.GROUND);
        this.instances = new InstanceRecycler(() -> (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance());
        this.animate(partialTick);
    }

    public static boolean isSupported(ItemEntity entity) {
        return ItemModels.isSupported(entity.m_32055_());
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum())) {
            return;
        }
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTick) {
        this.pPoseStack.m_166856_();
        TransformStack.of((PoseStack)this.pPoseStack).translate((Vector3fc)this.getVisualPosition(partialTick));
        this.instances.resetCount();
        ItemStack itemstack = ((ItemEntity)this.entity).m_32055_();
        int i = itemstack.m_41619_() ? 187 : Item.m_41393_((Item)itemstack.m_41720_()) + itemstack.m_41773_();
        RandomSource random = RANDOM.get();
        random.m_188584_((long)i);
        boolean flag = this.bakedModel.m_7539_();
        int j = this.getRenderAmount(itemstack);
        float f = 0.25f;
        float f1 = this.shouldBob() ? Mth.m_14031_((float)(((float)((ItemEntity)this.entity).m_32059_() + partialTick) / 10.0f + ((ItemEntity)this.entity).f_31983_)) * 0.1f + 0.1f : 0.0f;
        float groundScaleX = this.bakedModel.m_7442_().f_111793_.f_111757_.y();
        float groundScaleY = this.bakedModel.m_7442_().f_111793_.f_111757_.y();
        float groundScaleZ = this.bakedModel.m_7442_().f_111793_.f_111757_.y();
        this.pPoseStack.m_252880_(0.0f, f1 + 0.25f * groundScaleZ, 0.0f);
        float f3 = ((ItemEntity)this.entity).m_32008_(partialTick);
        this.pPoseStack.m_252781_(Axis.f_252436_.m_252961_(f3));
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f * groundScaleX;
            float f8 = -0.0f * (float)(j - 1) * 0.5f * groundScaleY;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f * groundScaleZ;
            this.pPoseStack.m_252880_(f7, f8, f9);
        }
        int light = LightTexture.m_109885_((int)this.level.m_45517_(LightLayer.BLOCK, ((ItemEntity)this.entity).m_20183_()), (int)this.level.m_45517_(LightLayer.SKY, ((ItemEntity)this.entity).m_20183_()));
        for (int k = 0; k < j; ++k) {
            this.pPoseStack.m_85836_();
            if (k > 0) {
                if (flag) {
                    float f11 = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                    float f13 = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                    float f10 = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                    this.pPoseStack.m_252880_(this.shouldSpreadItems() ? f11 : 0.0f, this.shouldSpreadItems() ? f13 : 0.0f, this.shouldSpreadItems() ? f10 : 0.0f);
                } else {
                    float f12 = (random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f14 = (random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    this.pPoseStack.m_85837_(this.shouldSpreadItems() ? (double)f12 : 0.0, this.shouldSpreadItems() ? (double)f14 : 0.0, 0.0);
                }
            }
            ((TransformedInstance)this.instances.get()).setTransform(this.pPoseStack.m_85850_()).light(light).setChanged();
            this.pPoseStack.m_85849_();
            if (flag) continue;
            this.pPoseStack.m_85837_(0.0, 0.0, (double)(0.09375f * groundScaleZ));
        }
        this.instances.discardExtra();
    }

    protected int getRenderAmount(ItemStack pStack) {
        int i = 1;
        if (pStack.m_41613_() > 48) {
            i = 5;
        } else if (pStack.m_41613_() > 32) {
            i = 4;
        } else if (pStack.m_41613_() > 16) {
            i = 3;
        } else if (pStack.m_41613_() > 1) {
            i = 2;
        }
        return i;
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    public boolean shouldBob() {
        return true;
    }

    protected void _delete() {
        this.instances.delete();
    }
}

