/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.EntityVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.visual.AbstractVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.vanillin.item.ItemModels;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LightLayer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ItemFrameVisual
extends AbstractVisual
implements EntityVisual<ItemFrame>,
SimpleDynamicVisual {
    private static final ModelResourceLocation FRAME_LOCATION = ModelResourceLocation.m_245263_((String)"item_frame", (String)"map=false");
    private static final ModelResourceLocation MAP_FRAME_LOCATION = ModelResourceLocation.m_245263_((String)"item_frame", (String)"map=true");
    private static final ModelResourceLocation GLOW_FRAME_LOCATION = ModelResourceLocation.m_245263_((String)"glow_item_frame", (String)"map=false");
    private static final ModelResourceLocation GLOW_MAP_FRAME_LOCATION = ModelResourceLocation.m_245263_((String)"glow_item_frame", (String)"map=true");
    public static final RendererReloadCache<ModelResourceLocation, Model> MODEL_RESOURCE_LOCATION = new RendererReloadCache(mrl -> {
        ModelManager modelManager = Minecraft.m_91087_().m_91304_().m_119430_().m_110881_();
        return BakedModelBuilder.create((BakedModel)modelManager.m_119422_(mrl)).build();
    });
    private final Matrix4f baseTransform = new Matrix4f();
    private final TransformedInstance frame;
    private final TransformedInstance item;
    private final ItemFrame entity;
    private ModelResourceLocation lastFrameLocation;
    private ItemStack lastItemStack;

    public ItemFrameVisual(VisualizationContext ctx, ItemFrame entity, float partialTick) {
        super(ctx, entity.m_9236_(), partialTick);
        this.entity = entity;
        this.lastItemStack = entity.m_31822_().m_41777_();
        this.lastFrameLocation = ItemFrameVisual.getFrameModelResourceLoc(entity, this.lastItemStack);
        Model frameModel = (Model)MODEL_RESOURCE_LOCATION.get((Object)this.lastFrameLocation);
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, frameModel).createInstance();
        this.frame.setTransform((Matrix4fc)this.baseTransform);
        this.item = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, ItemDisplayContext.FIXED)).createInstance();
        this.animate(partialTick);
    }

    public static boolean shouldVisualize(ItemFrame entity) {
        return !entity.m_31822_().m_150930_(Items.f_42573_) && ItemModels.isSupported(entity.m_31822_());
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        int light = LightTexture.m_109885_((int)this.getBlockLightLevel(this.entity.m_31748_()), (int)this.getSkyLightLevel(this.entity.m_31748_()));
        boolean invisible = this.entity.m_20145_();
        Direction direction = this.entity.m_6350_();
        Vec3i origin = this.visualizationContext.renderOrigin();
        float d = 0.46875f;
        float x = (float)(this.entity.m_20185_() - (double)origin.m_123341_() + (double)((float)direction.m_122429_() * d));
        float y = (float)(this.entity.m_20186_() - (double)origin.m_123342_() + (double)((float)direction.m_122430_() * d));
        float z = (float)(this.entity.m_20189_() - (double)origin.m_123343_() + (double)((float)direction.m_122431_() * d));
        this.baseTransform.translation(x, y, z);
        this.baseTransform.rotateXYZ((float)Math.PI / 180 * this.entity.m_146909_(), (float)Math.PI / 180 * (180.0f - this.entity.m_146908_()), 0.0f);
        ItemStack stack = this.entity.m_31822_();
        ModelResourceLocation frameLocation = ItemFrameVisual.getFrameModelResourceLoc(this.entity, stack);
        if (frameLocation != this.lastFrameLocation) {
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, (Model)MODEL_RESOURCE_LOCATION.get((Object)frameLocation)).stealInstance((Instance)this.frame);
            this.lastFrameLocation = frameLocation;
        }
        this.frame.setVisible(!invisible);
        this.frame.setTransform((Matrix4fc)this.baseTransform).translate(-0.5f, -0.5f, -0.5f).light(light).setChanged();
        if (!ItemStack.m_41728_((ItemStack)this.lastItemStack, (ItemStack)stack)) {
            this.lastItemStack = stack.m_41777_();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, ItemDisplayContext.FIXED)).stealInstance((Instance)this.item);
        }
        this.item.setTransform((Matrix4fc)this.baseTransform);
        if (invisible) {
            this.item.translate(0.0f, 0.0f, 0.5f);
        } else {
            this.item.translate(0.0f, 0.0f, 0.4375f);
        }
        OptionalInt optionalInt = this.entity.m_218868_();
        int i = optionalInt.isPresent() ? this.entity.m_31823_() % 4 * 2 : this.entity.m_31823_();
        this.item.rotateZDegrees((float)i * 360.0f / 8.0f);
        this.item.scale(0.5f, 0.5f, 0.5f);
        this.item.light(this.getLightVal(0xF000F0, light)).setChanged();
    }

    public void update(float partialTick) {
    }

    protected void _delete() {
        this.frame.delete();
        this.item.delete();
    }

    private int getLightVal(int glowLightVal, int regularLightVal) {
        return this.entity.m_6095_() == EntityType.f_147033_ ? glowLightVal : regularLightVal;
    }

    protected int getSkyLightLevel(BlockPos pos) {
        return this.level.m_45517_(LightLayer.SKY, pos);
    }

    protected int getBlockLightLevelBase(BlockPos pos) {
        return this.entity.m_6060_() ? 15 : this.level.m_45517_(LightLayer.BLOCK, pos);
    }

    protected int getBlockLightLevel(BlockPos pos) {
        return this.entity.m_6095_() == EntityType.f_147033_ ? Math.max(5, this.getBlockLightLevelBase(pos)) : this.getBlockLightLevelBase(pos);
    }

    public static ModelResourceLocation getFrameModelResourceLoc(ItemFrame entity, ItemStack item) {
        boolean bl;
        boolean bl2 = bl = entity.m_6095_() == EntityType.f_147033_;
        if (item.m_150930_(Items.f_42573_)) {
            return bl ? GLOW_MAP_FRAME_LOCATION : MAP_FRAME_LOCATION;
        }
        return bl ? GLOW_FRAME_LOCATION : FRAME_LOCATION;
    }
}

