/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import com.mojang.math.Transformation;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.visual.AbstractEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.component.ShadowComponent;
import net.minecraft.client.Camera;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;

public class BlockDisplayVisual
extends AbstractEntityVisual<Display.BlockDisplay>
implements SimpleDynamicVisual {
    private final TransformedInstance instance;
    private BlockState currentBlockState;
    private final ShadowComponent shadowComponent;

    public BlockDisplayVisual(VisualizationContext ctx, Display.BlockDisplay entity, float partialTick) {
        super(ctx, (Entity)entity, partialTick);
        BlockState state;
        Display.BlockDisplay.BlockRenderState blockRenderState = entity.m_276881_();
        this.currentBlockState = state = blockRenderState != null ? blockRenderState.f_276526_() : Blocks.f_50016_.m_49966_();
        this.instance = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block((BlockState)state)).createInstance();
        this.shadowComponent = new ShadowComponent(ctx, (Entity)entity);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        Display.RenderState renderState = ((Display.BlockDisplay)this.entity).m_276844_();
        if (renderState == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        Display.BlockDisplay.BlockRenderState object = ((Display.BlockDisplay)this.entity).m_276881_();
        if (object == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        this.instance.handle().setVisible(true);
        if (this.currentBlockState != object.f_276526_()) {
            this.currentBlockState = object.f_276526_();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block((BlockState)this.currentBlockState)).stealInstance((Instance)this.instance);
        }
        float f = ((Display.BlockDisplay)this.entity).m_272147_(ctx.partialTick());
        this.shadowComponent.radius(renderState.f_276607_().m_269229_(f));
        this.shadowComponent.strength(renderState.f_276693_().m_269229_(f));
        this.shadowComponent.beginFrame(ctx);
        int i = renderState.f_276438_();
        int j = i != -1 ? i : this.computePackedLight(ctx.partialTick());
        Transformation transformation = (Transformation)renderState.f_276585_().m_269136_(f);
        Vec3 pos = ((Display.BlockDisplay)this.entity).m_20182_();
        Vec3i renderOrigin = this.renderOrigin();
        this.instance.setIdentityTransform().translate((float)(pos.f_82479_ - (double)renderOrigin.m_123341_()), (float)(pos.f_82480_ - (double)renderOrigin.m_123342_()), (float)(pos.f_82481_ - (double)renderOrigin.m_123343_()));
        float partialTick = ctx.partialTick();
        Camera camera = ctx.camera();
        switch (renderState.f_276506_()) {
            case FIXED: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * BlockDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case HORIZONTAL: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * BlockDisplayVisual.cameraXRot(camera), 0.0f);
                break;
            }
            case VERTICAL: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * BlockDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case CENTER: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * BlockDisplayVisual.cameraXRot(camera), 0.0f);
            }
        }
        this.instance.mul((Matrix4fc)transformation.m_252783_()).light(j).setChanged();
    }

    private static float cameraYrot(Camera camera) {
        return camera.m_90590_() - 180.0f;
    }

    private static float cameraXRot(Camera camera) {
        return -camera.m_90589_();
    }

    private static float entityYRot(Entity entity, float partialTick) {
        return Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
    }

    private static float entityXRot(Entity entity, float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
    }

    protected void _delete() {
        this.instance.delete();
    }
}

