/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.vanillin.visuals;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.part.InstanceTree;
import dev.engine_room.flywheel.lib.model.part.ModelTree;
import dev.engine_room.flywheel.lib.model.part.ModelTrees;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BellVisual
extends AbstractBlockEntityVisual<BellBlockEntity>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().mipmap(false).build();
    private final InstanceTree instances = InstanceTree.create((InstancerProvider)this.instancerProvider(), (ModelTree)ModelTrees.of((ModelLayerLocation)ModelLayers.f_171269_, (net.minecraft.client.resources.model.Material)BellRenderer.f_112227_, (Material)MATERIAL));
    private final InstanceTree bellBody = this.instances.childOrThrow("bell_body");
    private final Matrix4fc initialPose;
    private boolean wasShaking = false;

    public BellVisual(VisualizationContext ctx, BellBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        BlockPos visualPos = this.getVisualPosition();
        this.initialPose = new Matrix4f().translate((float)visualPos.m_123341_(), (float)visualPos.m_123342_(), (float)visualPos.m_123343_());
        this.updateRotation(partialTick);
    }

    public void beginFrame(DynamicVisual.Context context) {
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        this.updateRotation(context.partialTick());
    }

    private void updateRotation(float partialTick) {
        float xRot = 0.0f;
        float zRot = 0.0f;
        if (((BellBlockEntity)this.blockEntity).f_58814_) {
            float ringTime = (float)((BellBlockEntity)this.blockEntity).f_58813_ + partialTick;
            float angle = Mth.m_14031_((float)(ringTime / (float)Math.PI)) / (4.0f + ringTime / 3.0f);
            switch (((BellBlockEntity)this.blockEntity).f_58815_) {
                case NORTH: {
                    xRot = -angle;
                    break;
                }
                case SOUTH: {
                    xRot = angle;
                    break;
                }
                case EAST: {
                    zRot = -angle;
                    break;
                }
                case WEST: {
                    zRot = angle;
                }
            }
            this.wasShaking = true;
        } else if (this.wasShaking) {
            this.wasShaking = false;
        }
        this.bellBody.xRot(xRot);
        this.bellBody.zRot(zRot);
        this.instances.updateInstancesStatic(this.initialPose);
    }

    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight();
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.instances.traverse(consumer);
    }

    protected void _delete() {
        this.instances.delete();
    }
}

