/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.text;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.feature.render.text.Text;
import xaeroplus.feature.render.text.TextSupplier;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class TextDrawFeature
implements DrawFeature {
    private final TextSupplier textSupplier;
    private final String id;

    public TextDrawFeature(String id, TextSupplier textSupplier) {
        this.id = id;
        this.textSupplier = textSupplier;
    }

    public Long2ObjectMap<Text> getText() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.textSupplier.getText(windowX, windowZ, windowSize, Globals.getCurrentDimensionId());
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void render(DrawContext ctx) {
        Font font = Minecraft.m_91087_().f_91062_;
        Long2ObjectMap<Text> texts = this.getText();
        ObjectIterator it = Long2ObjectMaps.fastIterator(texts);
        while (it.hasNext()) {
            Text text = (Text)((Long2ObjectMap.Entry)it.next()).getValue();
            ctx.matrixStack().m_85836_();
            float textScale = text.scale() * 2.0f * (float)Mth.m_14008_((double)((double)(ctx.worldmap() ? 1.0f : (float)Globals.minimapScaleMultiplier) / ctx.fboScale()), (double)(0.1f * (ctx.worldmap() ? 1.0f : (float)Globals.minimapScaleMultiplier)), (double)1000.0);
            float width = font.m_92895_(text.value());
            ctx.matrixStack().m_85841_(textScale, textScale, 1.0f);
            ctx.matrixStack().m_252880_((float)text.x() / textScale, (float)text.z() / textScale, 0.0f);
            PoseStack poseStack = ctx.matrixStack();
            float f = -width / 2.0f;
            Objects.requireNonNull(font);
            poseStack.m_252880_(f, (float)(-9) / 2.0f, 0.0f);
            font.m_272078_(text.value(), 0.0f, 0.0f, text.color(), true, ctx.matrixStack().m_85850_().m_252922_(), (MultiBufferSource)ctx.renderTypeBuffers(), Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
            ctx.matrixStack().m_85849_();
        }
        if (!texts.isEmpty()) {
            RenderSystem.disableCull();
            ctx.renderTypeBuffers().m_173043_();
        }
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void close() {
    }
}

