/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.common.graphics.CustomRenderTypes;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawHelper;
import xaeroplus.feature.render.line.AbstractLineDrawFeature;
import xaeroplus.feature.render.line.Line;
import xaeroplus.feature.render.line.LinePreProcessor;
import xaeroplus.feature.render.line.LineProvider;
import xaeroplus.util.ColorHelper;

public class LineDrawFeature
extends AbstractLineDrawFeature<List<Line>> {
    private final String id;
    private final LineProvider lineProvider;

    public LineDrawFeature(String id, LineProvider lineProvider, int refreshIntervalMs) {
        super(refreshIntervalMs);
        this.id = id;
        this.lineProvider = lineProvider;
    }

    @Override
    public float lineWidth() {
        return this.lineProvider.lineWidthSupplier().getFloat();
    }

    @Override
    public List<Line> provideLinesInWindow(int windowX, int windowZ, int windowSize, ResourceKey<Level> dimension) {
        return this.lineProvider.lineSupplier().getLines(windowX, windowZ, windowSize, dimension);
    }

    @Override
    public List<Line> preProcessLines(List<Line> lines) {
        if (lines.isEmpty()) {
            return lines;
        }
        ArrayList<Line> out = new ArrayList<Line>(lines);
        for (int i = 0; i < out.size(); ++i) {
            Line line = (Line)out.get(i);
            List<Line> newLines = LinePreProcessor.ensureLength(line);
            if (newLines.isEmpty()) continue;
            out.remove(i);
            out.addAll(i, newLines);
            i += newLines.size() - 1;
        }
        out.replaceAll(LinePreProcessor::ensureOrientation);
        return out;
    }

    @Override
    public List<Line> emptyLines() {
        return Collections.emptyList();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void render(DrawContext ctx) {
        int color = this.lineProvider.colorSupplier().getAsInt();
        float a = ColorHelper.getA(color);
        if (a == 0.0f) {
            return;
        }
        this.preRender(ctx);
        VertexConsumer lineBuffer = ctx.renderTypeBuffers().m_6299_(CustomRenderTypes.MAP_LINES);
        float r = ColorHelper.getR(color);
        float g = ColorHelper.getG(color);
        float b = ColorHelper.getB(color);
        List lines = (List)this.getLines();
        for (int j = 0; j < lines.size(); ++j) {
            Line line = (Line)lines.get(j);
            int x1 = ctx.worldmap() ? line.x2() : line.x1();
            int z1 = ctx.worldmap() ? line.z2() : line.z1();
            int x2 = ctx.worldmap() ? line.x1() : line.x2();
            int z2 = ctx.worldmap() ? line.z1() : line.z2();
            DrawHelper.addColoredLineToExistingBuffer(ctx.matrixStack().m_85850_(), lineBuffer, x1, z1, x2, z2, r, g, b, a);
        }
        if (!lines.isEmpty()) {
            ctx.renderTypeBuffers().m_109912_(CustomRenderTypes.MAP_LINES);
        }
    }
}

