/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.db;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Statement;
import java.time.Instant;
import java.util.List;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.db.DatabaseMigration;

public class DatabaseMigrator {
    private final List<DatabaseMigration> migrations;

    public DatabaseMigrator(List<DatabaseMigration> migrations) {
        this.migrations = migrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Path dbPath, String databaseName, Connection connection, boolean init) {
        try {
            for (int i = 0; i < this.migrations.size(); ++i) {
                DatabaseMigration migration = this.migrations.get(i);
                if (!migration.shouldMigrate(databaseName, connection)) continue;
                if (!init) {
                    XaeroPlus.LOGGER.info("Found database: {} that needs migration", (Object)databaseName);
                }
                if (!init && !this.backupDatabase(dbPath, databaseName, connection)) continue;
                try {
                    connection.setAutoCommit(false);
                    migration.doMigration(databaseName, connection);
                    connection.commit();
                    XaeroPlus.LOGGER.info("Successfully migrated database: {}", (Object)databaseName);
                    continue;
                }
                finally {
                    connection.setAutoCommit(true);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed migrating database: {}", (Object)databaseName, (Object)e);
            XaeroPlus.LOGGER.error("Data should not be lost but things might not work as expected");
        }
    }

    private Path getBackupPath(Path dbPath) {
        return dbPath.getParent().resolve("XaeroPlus-db-backups");
    }

    public boolean backupDatabase(Path dbPath, String databaseName, Connection connection) {
        try {
            Path backupPath = this.getBackupPath(dbPath);
            if (!backupPath.toFile().exists()) {
                backupPath.toFile().mkdirs();
            }
            String dbBackupLocation = backupPath.resolve(databaseName + "-" + Instant.now().toEpochMilli() + ".db").toString();
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("BACKUP TO '" + dbBackupLocation + "'");
            }
            XaeroPlus.LOGGER.info("Backed up database: {} to: {}", (Object)databaseName, (Object)dbBackupLocation);
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed backing up database: {}", (Object)databaseName, (Object)e);
            return false;
        }
    }
}

