/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils;

import dcshadow.javax.annotation.Nonnull;
import net.dv8tion.jda.annotations.ForRemoval;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.requests.RestRateLimiter;
import net.dv8tion.jda.api.utils.SessionControllerAdapter;

public interface SessionController {
    public static final int IDENTIFY_DELAY = 5;

    default public void setConcurrency(int level) {
    }

    public void appendSession(@Nonnull SessionConnectNode var1);

    public void removeSession(@Nonnull SessionConnectNode var1);

    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="getRateLimitHandle().getClassic()")
    default public long getGlobalRatelimit() {
        return -1L;
    }

    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="getRateLimitHandle().getClassic()")
    default public void setGlobalRatelimit(long ratelimit) {
    }

    @Nonnull
    default public RestRateLimiter.GlobalRateLimit getRateLimitHandle() {
        return new GlobalRateLimitAdapter(this);
    }

    @Nonnull
    default public String getGateway() {
        return "wss://gateway.discord.gg/";
    }

    @Nonnull
    public ShardedGateway getShardedGateway(@Nonnull JDA var1);

    @Deprecated
    @ForRemoval(deadline="5.0.0")
    @ReplaceWith(value="getRateLimitHandle()")
    public static class GlobalRateLimitAdapter
    implements RestRateLimiter.GlobalRateLimit {
        private final SessionController controller;

        public GlobalRateLimitAdapter(@Nonnull SessionController controller) {
            SessionControllerAdapter.log.warn("Using outdated implementation of global rate-limit handling. It is recommended to use GlobalRateLimit interface instead!");
            this.controller = controller;
        }

        @Override
        public long getClassic() {
            return this.controller.getGlobalRatelimit();
        }

        @Override
        public void setClassic(long ratelimit) {
            this.controller.setGlobalRatelimit(ratelimit);
        }

        @Override
        public long getCloudflare() {
            return this.getClassic();
        }

        @Override
        public void setCloudflare(long timestamp) {
            this.setClassic(timestamp);
        }
    }

    public static interface SessionConnectNode {
        public boolean isReconnect();

        @Nonnull
        public JDA getJDA();

        @Nonnull
        public JDA.ShardInfo getShardInfo();

        public void run(boolean var1) throws InterruptedException;
    }

    public static class ShardedGateway {
        private final String url;
        private final int shardTotal;
        private final int concurrency;

        public ShardedGateway(String url, int shardTotal) {
            this(url, shardTotal, 1);
        }

        public ShardedGateway(String url, int shardTotal, int concurrency) {
            this.url = url;
            this.shardTotal = shardTotal;
            this.concurrency = concurrency;
        }

        public String getUrl() {
            return this.url;
        }

        public int getShardTotal() {
            return this.shardTotal;
        }

        public int getConcurrency() {
            return this.concurrency;
        }
    }
}

