/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dcshadow.dev.vankka.mcdiscordreserializer.discord.DiscordSerializer;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.WorkThread;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.addon.DiscordAddonMeta;
import de.erdbeerbaerlp.dcintegration.common.compat.DynmapListener;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.MCSubCommand;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.McCommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.DownloadSourceChecker;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MinecraftPermission;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import de.erdbeerbaerlp.dcintegration.common.util.UpdateChecker;
import de.erdbeerbaerlp.dcintegration.forge.api.ForgeDiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.forge.command.McCommandDiscord;
import de.erdbeerbaerlp.dcintegration.forge.metrics.Metrics;
import de.erdbeerbaerlp.dcintegration.forge.util.ForgeMessageUtils;
import de.erdbeerbaerlp.dcintegration.forge.util.ForgeServerInterface;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.apache.commons.lang3.ArrayUtils;

@Mod(value="dcintegration")
public class DiscordIntegrationMod {
    public static final String MODID = "dcintegration";
    public static final ArrayList<UUID> timeouts = new ArrayList();
    private boolean stopped = false;
    public static Metrics bstats;
    public static final HashMap<String, PermissionNode<Boolean>> nodes;

    public DiscordIntegrationMod() {
        DiscordIntegration.LOGGER.info("Version is " + DiscordIntegration.VERSION);
        bstats = new Metrics(9765);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        try {
            if (!DiscordIntegration.discordDataDir.exists()) {
                DiscordIntegration.discordDataDir.mkdir();
            }
            DiscordIntegration.loadConfigs();
            if (FMLEnvironment.dist == Dist.CLIENT) {
                DiscordIntegration.LOGGER.error("This mod cannot be used client-side");
            } else if (Configuration.instance().general.botToken.equals("INSERT BOT TOKEN HERE")) {
                DiscordIntegration.LOGGER.error("Please check the config file and set an bot token");
            } else {
                FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }
        catch (IOException e) {
            DiscordIntegration.LOGGER.error("Config loading failed");
            if (!DiscordIntegration.discordDataDir.exists()) {
                DiscordIntegration.LOGGER.error("Please create the folder " + DiscordIntegration.discordDataDir.getAbsolutePath() + " manually");
            }
            DiscordIntegration.LOGGER.error(e.getMessage());
            DiscordIntegration.LOGGER.error((Object)e.getCause());
        }
        catch (IllegalStateException e) {
            DiscordIntegration.LOGGER.error("Failed to read config file! Please check your config file!\nError description: " + e.getMessage());
            DiscordIntegration.LOGGER.error("\nStacktrace: ");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void serverSetup(FMLDedicatedServerSetupEvent ev) {
        DiscordIntegration.INSTANCE = new DiscordIntegration(new ForgeServerInterface());
        try {
            DiscordIntegration.LOGGER.info("Waiting for JDA to initialize to send starting message... (max 5 seconds before skipping)");
            for (int i = 0; i <= 5 && DiscordIntegration.INSTANCE.getJDA() == null; ++i) {
                Thread.sleep(1000L);
            }
            if (DiscordIntegration.INSTANCE.getJDA() != null) {
                Thread.sleep(2000L);
                CommandRegistry.registerDefaultCommands();
                if (!Localization.instance().serverStarting.isBlank() && DiscordIntegration.INSTANCE.getChannel() != null) {
                    MessageCreateData m = Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed ? ((MessageCreateBuilder)new MessageCreateBuilder().setEmbeds(Configuration.instance().embedMode.startMessages.toEmbed().setDescription(Localization.instance().serverStarting).build())).build() : new MessageCreateBuilder().addContent(Localization.instance().serverStarting).build();
                    DiscordIntegration.startingMsg = DiscordIntegration.INSTANCE.sendMessageReturns(m, DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        }
        catch (InterruptedException | NullPointerException exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void addPermissions(PermissionGatherEvent.Nodes ev) {
        for (MinecraftPermission p : MinecraftPermission.values()) {
            nodes.put(p.getAsString(), (PermissionNode<Boolean>)new PermissionNode(MODID, p.getAsString().replace("dcintegration.", ""), PermissionTypes.BOOLEAN, (player, playerUUID, context) -> p.getDefaultValue(), new PermissionDynamicContextKey[0]));
        }
        ev.addNodes(nodes.values().toArray(new PermissionNode[0]));
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (DiscordIntegration.INSTANCE != null) {
            if (LinkManager.isPlayerLinked(ev.getEntity().m_20148_()) && LinkManager.getLink(null, (UUID)ev.getEntity().m_20148_()).settings.hideFromDiscord) {
                return;
            }
            LinkManager.checkGlobalAPI(ev.getEntity().m_20148_());
            if (!Localization.instance().playerJoin.isBlank()) {
                Player p = ev.getEntity();
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerJoinMessage.asEmbed) {
                    String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", p.m_20148_().toString()).replace("%uuid_dashless%", p.m_20148_().toString().replace("-", "")).replace("%name%", p.m_7755_().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.playerJoinMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbedJson(Configuration.instance().embedMode.playerJoinMessage.customJSON.replace("%uuid%", p.m_20148_().toString()).replace("%uuid_dashless%", p.m_20148_().toString().replace("-", "")).replace("%name%", ForgeMessageUtils.formatPlayerName((Entity)p)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID(p.m_20148_()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerJoinMessage.toEmbed();
                        b.setAuthor(ForgeMessageUtils.formatPlayerName((Entity)p), null, avatarURL).setDescription(Localization.instance().playerJoin.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)p)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerJoin.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)p)));
                }
            }
            WorkThread.executeJob(() -> {
                Member member;
                if (Configuration.instance().linking.linkedRoleID.equals("0")) {
                    return;
                }
                UUID uuid = ev.getEntity().m_20148_();
                if (!LinkManager.isPlayerLinked(uuid)) {
                    return;
                }
                Guild guild = DiscordIntegration.INSTANCE.getChannel().getGuild();
                Role linkedRole = guild.getRoleById(Configuration.instance().linking.linkedRoleID);
                if (LinkManager.isPlayerLinked(uuid) && !(member = DiscordIntegration.INSTANCE.getMemberById(LinkManager.getLink(null, (UUID)uuid).discordID)).getRoles().contains(linkedRole)) {
                    guild.addRoleToMember(member, linkedRole).queue();
                }
            });
        }
    }

    @SubscribeEvent
    public void advancement(AdvancementEvent.AdvancementEarnEvent ev) {
        if (Localization.instance().advancementMessage.isBlank()) {
            return;
        }
        if (LinkManager.isPlayerLinked(ev.getEntity().m_20148_()) && LinkManager.getLink(null, (UUID)ev.getEntity().m_20148_()).settings.hideFromDiscord) {
            return;
        }
        if (ev.getEntity().m_20194_().m_6846_().m_11296_((ServerPlayer)ev.getEntity()).m_135996_(ev.getAdvancement()).m_8193_() && DiscordIntegration.INSTANCE != null && ev.getAdvancement() != null && ev.getAdvancement().m_138320_() != null && ev.getAdvancement().m_138320_().m_14996_() && !Localization.instance().advancementMessage.isBlank()) {
            if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.advancementMessage.asEmbed) {
                String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", ev.getEntity().m_20148_().toString()).replace("%uuid_dashless%", ev.getEntity().m_20148_().toString().replace("-", "")).replace("%name%", ev.getEntity().m_7755_().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                if (!Configuration.instance().embedMode.advancementMessage.customJSON.isBlank()) {
                    EmbedBuilder b = Configuration.instance().embedMode.advancementMessage.toEmbedJson(Configuration.instance().embedMode.advancementMessage.customJSON.replace("%uuid%", ev.getEntity().m_20148_().toString()).replace("%uuid_dashless%", ev.getEntity().m_20148_().toString().replace("-", "")).replace("%name%", ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity())).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%advName%", ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14977_().getString())).replace("%advDesc%", ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14985_().getString())).replace("%advNameURL%", URLEncoder.encode(ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14977_().getString()), StandardCharsets.UTF_8)).replace("%advDescURL%", URLEncoder.encode(ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14985_().getString()), StandardCharsets.UTF_8)).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID(ev.getEntity().m_20148_()).getRGB()));
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                } else {
                    EmbedBuilder b = Configuration.instance().embedMode.advancementMessage.toEmbed();
                    b = b.setAuthor(ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity()), null, avatarURL).setDescription(Localization.instance().advancementMessage.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity())).replace("%advName%", ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14977_().getString())).replace("%advDesc%", ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14985_().getString())).replace("\\n", "\n").replace("%advNameURL%", URLEncoder.encode(ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14977_().getString()), StandardCharsets.UTF_8)).replace("%advDescURL%", URLEncoder.encode(ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14985_().getString()), StandardCharsets.UTF_8)));
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                }
            } else {
                DiscordIntegration.INSTANCE.sendMessage(Localization.instance().advancementMessage.replace("%player%", ChatFormatting.m_126649_((String)ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity()))).replace("%advName%", ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14977_().getString())).replace("%advDesc%", ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14985_().getString()).replace("%advNameURL%", URLEncoder.encode(ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14977_().getString()), StandardCharsets.UTF_8)).replace("%advDescURL%", URLEncoder.encode(ChatFormatting.m_126649_((String)ev.getAdvancement().m_138320_().m_14985_().getString()), StandardCharsets.UTF_8))).replace("\\n", "\n"));
            }
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent ev) {
        new McCommandDiscord((CommandDispatcher<CommandSourceStack>)ev.getDispatcher());
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent ev) {
        DiscordIntegration.LOGGER.info("Started");
        DiscordIntegration.started = new Date().getTime();
        if (DiscordIntegration.INSTANCE != null) {
            if (DiscordIntegration.startingMsg != null) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.startMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.startMessages.toEmbedJson(Configuration.instance().embedMode.startMessages.customJSON);
                        DiscordIntegration.startingMsg.thenAccept(a -> a.editMessageEmbeds(b.build()).queue());
                    } else {
                        DiscordIntegration.startingMsg.thenAccept(a -> a.editMessageEmbeds(Configuration.instance().embedMode.startMessages.toEmbed().setDescription(Localization.instance().serverStarted).build()).queue());
                    }
                } else {
                    DiscordIntegration.startingMsg.thenAccept(a -> a.editMessage(Localization.instance().serverStarted).queue());
                }
            } else if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.startMessages.asEmbed) {
                if (!Configuration.instance().embedMode.startMessages.customJSON.isBlank()) {
                    EmbedBuilder b = Configuration.instance().embedMode.startMessages.toEmbedJson(Configuration.instance().embedMode.startMessages.customJSON);
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.startMessages.toEmbed().setDescription(Localization.instance().serverStarted).build()));
                }
            } else {
                DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverStarted);
            }
            DiscordIntegration.INSTANCE.startThreads();
        }
        UpdateChecker.runUpdateCheck("https://raw.githubusercontent.com/ErdbeerbaerLP/Discord-Chat-Integration/1.20.1/update_checker.json");
        if (ModList.get().getModContainerById("dynmap").isPresent()) {
            new DynmapListener().register();
        }
        if (!DownloadSourceChecker.checkDownloadSource(new File(DiscordIntegrationMod.class.getProtectionDomain().getCodeSource().getLocation().getPath().split("%")[0]))) {
            DiscordIntegration.LOGGER.warn("You likely got this mod from a third party website.");
            DiscordIntegration.LOGGER.warn("Some of such websites are distributing malware or old versions.");
            DiscordIntegration.LOGGER.warn("Download this mod from an official source (https://www.curseforge.com/minecraft/mc-mods/dcintegration) to hide this message");
            DiscordIntegration.LOGGER.warn("This warning can also be suppressed in the config file");
        }
        bstats.addCustomChart(new Metrics.DrilldownPie("addons", () -> {
            HashMap map = new HashMap();
            if (Configuration.instance().bstats.sendAddonStats) {
                for (DiscordAddonMeta m : AddonLoader.getAddonMetas()) {
                    HashMap<String, Integer> entry = new HashMap<String, Integer>();
                    entry.put(m.getVersion(), 1);
                    map.put(m.getName(), entry);
                }
            }
            return map;
        }));
        bstats.addCustomChart(new Metrics.SimplePie("webhook_mode", () -> Configuration.instance().webhook.enable ? "Enabled" : "Disabled"));
        bstats.addCustomChart(new Metrics.SimplePie("command_log", () -> !Configuration.instance().commandLog.channelID.equals("0") ? "Enabled" : "Disabled"));
        bstats.addCustomChart(new Metrics.SimplePie("loader", () -> Metrics.capturedServer.get().getServerModName()));
    }

    @SubscribeEvent
    public void command(CommandEvent ev) {
        String command = ev.getParseResults().getReader().getString().replaceFirst(Pattern.quote("/"), "");
        if (DiscordIntegration.INSTANCE != null) {
            String[] args2;
            CommandSourceStack source2 = (CommandSourceStack)ev.getParseResults().getContext().getSource();
            String name = source2.m_81368_();
            Entity sourceEntity = source2.m_81373_();
            boolean raw = false;
            if (Configuration.instance().webhook.enable && name.equals("Rcon") && Configuration.instance().webhook.useServerNameForRcon) {
                name = Configuration.instance().webhook.serverName;
            } else if (Configuration.instance().webhook.enable && name.equals("Server") && Configuration.instance().webhook.useServerNameForConsole) {
                name = Configuration.instance().webhook.serverName;
            }
            if (!Configuration.instance().commandLog.channelID.equals("0") && (!Configuration.instance().commandLog.commandWhitelist && !ArrayUtils.contains((Object[])Configuration.instance().commandLog.ignoredCommands, (Object)command.split(" ")[0]) || Configuration.instance().commandLog.commandWhitelist && ArrayUtils.contains((Object[])Configuration.instance().commandLog.ignoredCommands, (Object)command.split(" ")[0]))) {
                DiscordIntegration.INSTANCE.sendMessage(Configuration.instance().commandLog.message.replace("%sender%", name).replace("%cmd%", command).replace("%cmd-no-args%", command.split(" ")[0]), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().commandLog.channelID));
            }
            if (command.startsWith("say") && Configuration.instance().messages.sendOnSayCommand || command.startsWith("me") && Configuration.instance().messages.sendOnMeCommand) {
                Object msg = command.replace("say ", "");
                if (command.startsWith("say")) {
                    msg = ((String)msg).replaceFirst("say ", "");
                }
                if (command.startsWith("me")) {
                    raw = true;
                    msg = "*" + MessageUtils.escapeMarkdown(((String)msg).replaceFirst("me ", "").trim()) + "*";
                }
                DiscordIntegration.INSTANCE.sendMessage(name, sourceEntity != null ? sourceEntity.m_20148_().toString() : "0000000", new DiscordMessage(null, (String)msg, !raw), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID));
            }
            if (command.startsWith("tellraw ") && !Configuration.instance().messages.tellrawSelector.isBlank() && (args2 = command.replace("tellraw ", "").replace("dc ", "").split(" "))[0].equals(Configuration.instance().messages.tellrawSelector)) {
                DiscordIntegration.INSTANCE.sendMessage(DiscordSerializer.INSTANCE.serialize((Component)GsonComponentSerializer.gson().deserialize(command.replace("tellraw " + args2[0], ""))));
            }
            if (command.startsWith("discord ") || command.startsWith("dc ")) {
                args2 = command.replace("discord ", "").replace("dc ", "").split(" ");
                for (MCSubCommand mcSubCommand : McCommandRegistry.getCommands()) {
                    if (args2[0].equals(mcSubCommand.getName())) {
                        String[] cmdArgs = args2.length > 1 ? Arrays.copyOfRange(args2, 1, args2.length) : new String[]{};
                        switch (mcSubCommand.getType()) {
                            case CONSOLE_ONLY: {
                                String txt;
                                try {
                                    source2.m_81375_();
                                    source2.m_81352_(net.minecraft.network.chat.Component.m_130674_((String)Localization.instance().commands.consoleOnly));
                                }
                                catch (CommandSyntaxException e) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, null));
                                    source2.m_288197_(() -> {
                                        try {
                                            return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                        }
                                        catch (CommandSyntaxException ignored) {
                                            return null;
                                        }
                                    }, false);
                                }
                                break;
                            }
                            case PLAYER_ONLY: {
                                ServerPlayer player;
                                String txt;
                                try {
                                    player = source2.m_81375_();
                                    if (!(mcSubCommand.needsOP() || ModList.get().getModContainerById("dynmap").isPresent() && DiscordIntegration.INSTANCE.getServerInterface().playerHasPermissions(player.m_20148_(), MinecraftPermission.RUN_DISCORD_COMMAND))) {
                                        txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.m_20148_()));
                                        source2.m_288197_(() -> {
                                            try {
                                                return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                            }
                                            catch (CommandSyntaxException ignored) {
                                                return null;
                                            }
                                        }, false);
                                        break;
                                    }
                                    if (source2.m_6761_(4)) {
                                        txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.m_20148_()));
                                        source2.m_288197_(() -> {
                                            try {
                                                return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                            }
                                            catch (CommandSyntaxException ignored) {
                                                return null;
                                            }
                                        }, false);
                                        break;
                                    }
                                    if (DiscordIntegration.INSTANCE.getServerInterface().playerHasPermissions(player.m_20148_(), MinecraftPermission.RUN_DISCORD_COMMAND_ADMIN, MinecraftPermission.ADMIN)) {
                                        txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.m_20148_()));
                                        source2.m_288197_(() -> {
                                            try {
                                                return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                            }
                                            catch (CommandSyntaxException ignored) {
                                                return null;
                                            }
                                        }, false);
                                        break;
                                    }
                                    source2.m_81352_(net.minecraft.network.chat.Component.m_130674_((String)Localization.instance().commands.noPermission));
                                }
                                catch (CommandSyntaxException e) {
                                    source2.m_81352_(net.minecraft.network.chat.Component.m_130674_((String)Localization.instance().commands.ingameOnly));
                                }
                                break;
                            }
                            case BOTH: {
                                ServerPlayer player;
                                String txt;
                                try {
                                    player = source2.m_81375_();
                                    if (!mcSubCommand.needsOP()) {
                                        txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.m_20148_()));
                                        source2.m_288197_(() -> {
                                            try {
                                                return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                            }
                                            catch (CommandSyntaxException ignored) {
                                                return null;
                                            }
                                        }, false);
                                        break;
                                    }
                                    if (source2.m_6761_(4)) {
                                        txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, player.m_20148_()));
                                        source2.m_288197_(() -> {
                                            try {
                                                return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                            }
                                            catch (CommandSyntaxException ignored) {
                                                return null;
                                            }
                                        }, false);
                                        break;
                                    }
                                    source2.m_81352_(net.minecraft.network.chat.Component.m_130674_((String)Localization.instance().commands.noPermission));
                                    break;
                                }
                                catch (CommandSyntaxException e) {
                                    txt = (String)GsonComponentSerializer.gson().serialize(mcSubCommand.execute(cmdArgs, null));
                                    source2.m_288197_(() -> {
                                        try {
                                            return ComponentArgument.m_87114_().parse(new StringReader(txt));
                                        }
                                        catch (CommandSyntaxException ignored) {
                                            return null;
                                        }
                                    }, false);
                                }
                            }
                        }
                    }
                    ev.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppedEvent ev) {
        Metrics.MetricsBase.scheduler.shutdownNow();
        if (DiscordIntegration.INSTANCE != null) {
            ev.getServer().m_18709_(() -> {
                DiscordIntegration.INSTANCE.stopThreads();
                if (!ev.getServer().m_130010_() && !Localization.instance().serverStopped.isBlank()) {
                    if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.stopMessages.asEmbed) {
                        if (!Configuration.instance().embedMode.stopMessages.customJSON.isBlank()) {
                            EmbedBuilder b = Configuration.instance().embedMode.stopMessages.toEmbedJson(Configuration.instance().embedMode.stopMessages.customJSON);
                            DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                        } else {
                            DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.stopMessages.toEmbed().setDescription(Localization.instance().serverStopped).build()));
                        }
                    } else {
                        DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverStopped);
                    }
                } else if (ev.getServer().m_130010_() && !Localization.instance().serverCrash.isBlank()) {
                    if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.stopMessages.asEmbed) {
                        if (!Configuration.instance().embedMode.stopMessages.customJSON.isBlank()) {
                            EmbedBuilder b = Configuration.instance().embedMode.stopMessages.toEmbedJson(Configuration.instance().embedMode.stopMessages.customJSON);
                            DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                        } else {
                            DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(Configuration.instance().embedMode.stopMessages.toEmbed().setDescription(Localization.instance().serverStopped).build()));
                        }
                    } else {
                        DiscordIntegration.INSTANCE.sendMessage(Localization.instance().serverCrash);
                    }
                }
                DiscordIntegration.INSTANCE.kill(false);
                DiscordIntegration.INSTANCE = null;
                this.stopped = true;
                DiscordIntegration.LOGGER.info("Shut-down successfully!");
            });
        }
    }

    @SubscribeEvent
    public void chat(ServerChatEvent ev) {
        if (Localization.instance().discordChatMessage.isBlank()) {
            return;
        }
        if (!DiscordIntegration.INSTANCE.getServerInterface().playerHasPermissions(ev.getPlayer().m_20148_(), MinecraftPermission.SEMD_MESSAGES, MinecraftPermission.USER)) {
            return;
        }
        if (LinkManager.isPlayerLinked(ev.getPlayer().m_20148_()) && LinkManager.getLink(null, (UUID)ev.getPlayer().m_20148_()).settings.hideFromDiscord) {
            return;
        }
        net.minecraft.network.chat.Component msg = ev.getMessage();
        if (DiscordIntegration.INSTANCE != null) {
            String text = MessageUtils.escapeMarkdown(ev.getMessage().getString().replace("@everyone", "[at]everyone").replace("@here", "[at]here"));
            MessageEmbed embed = ForgeMessageUtils.genItemStackEmbedIfAvailable(msg);
            if (DiscordIntegration.INSTANCE.callEvent(e -> {
                if (e instanceof ForgeDiscordEventHandler) {
                    return ((ForgeDiscordEventHandler)e).onMcChatMessage(ev);
                }
                return false;
            })) {
                return;
            }
            GuildMessageChannel channel = DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.chatOutputChannelID);
            if (channel == null) {
                return;
            }
            String json = Component.Serializer.m_130703_((net.minecraft.network.chat.Component)ev.getMessage());
            Object comp = GsonComponentSerializer.gson().deserialize(json);
            if (DiscordIntegration.INSTANCE.callEvent(e -> e.onMinecraftMessage((Component)comp, ev.getPlayer().m_20148_()))) {
                return;
            }
            if (!Localization.instance().discordChatMessage.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.chatMessages.asEmbed) {
                    String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", ev.getPlayer().m_20148_().toString()).replace("%uuid_dashless%", ev.getPlayer().m_20148_().toString().replace("-", "")).replace("%name%", ev.getPlayer().m_7755_().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.chatMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.chatMessages.toEmbedJson(Configuration.instance().embedMode.chatMessages.customJSON.replace("%uuid%", ev.getPlayer().m_20148_().toString()).replace("%uuid_dashless%", ev.getPlayer().m_20148_().toString().replace("-", "")).replace("%name%", ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer())).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%msg%", text).replace("%playerColor%", "" + TextColors.generateFromUUID(ev.getPlayer().m_20148_()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.chatMessages.toEmbed();
                        if (Configuration.instance().embedMode.chatMessages.generateUniqueColors) {
                            b = b.setColor(TextColors.generateFromUUID(ev.getPlayer().m_20148_()));
                        }
                        b = b.setAuthor(ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer()), null, avatarURL).setDescription(text);
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(ForgeMessageUtils.formatPlayerName((Entity)ev.getPlayer()), ev.getPlayer().m_20148_().toString(), new DiscordMessage(embed, text, true), (MessageChannel)channel);
                }
            }
            if (!Configuration.instance().compatibility.disableParsingMentionsIngame) {
                String editedJson = (String)GsonComponentSerializer.gson().serialize(MessageUtils.mentionsToNames(comp, channel.getGuild()));
                ev.setMessage((net.minecraft.network.chat.Component)Component.Serializer.m_130701_((String)editedJson));
            }
        }
    }

    @SubscribeEvent
    public void death(LivingDeathEvent ev) {
        if (Localization.instance().playerDeath.isBlank()) {
            return;
        }
        if (ev.getEntity() instanceof Player) {
            if (LinkManager.isPlayerLinked(ev.getEntity().m_20148_()) && LinkManager.getLink(null, (UUID)ev.getEntity().m_20148_()).settings.hideFromDiscord) {
                return;
            }
            if (DiscordIntegration.INSTANCE != null) {
                net.minecraft.network.chat.Component deathMessage = ev.getSource().m_6157_(ev.getEntity());
                MessageEmbed embed = ForgeMessageUtils.genItemStackEmbedIfAvailable(deathMessage);
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.deathMessage.asEmbed) {
                    String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", ev.getEntity().m_20148_().toString()).replace("%uuid_dashless%", ev.getEntity().m_20148_().toString().replace("-", "")).replace("%name%", ev.getEntity().m_7755_().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                    if (!Configuration.instance().embedMode.deathMessage.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.deathMessage.toEmbedJson(Configuration.instance().embedMode.deathMessage.customJSON.replace("%uuid%", ev.getEntity().m_20148_().toString()).replace("%uuid_dashless%", ev.getEntity().m_20148_().toString().replace("-", "")).replace("%name%", ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity())).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%deathMessage%", ChatFormatting.m_126649_((String)deathMessage.getString()).replace(ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity()) + " ", "")).replace("%playerColor%", "" + TextColors.generateFromUUID(ev.getEntity().m_20148_()).getRGB()));
                        if (embed != null) {
                            b.addBlankField(false);
                            b.addField(embed.getTitle() + " *(" + embed.getFooter().getText() + ")*", embed.getDescription(), false);
                        }
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.deathMessage.toEmbed();
                        b.setDescription(":skull: " + Localization.instance().playerDeath.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity())).replace("%msg%", ChatFormatting.m_126649_((String)deathMessage.getString()).replace(ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity()) + " ", "")));
                        if (embed != null) {
                            b.addBlankField(false);
                            b.addField(embed.getTitle() + " *(" + embed.getFooter().getText() + ")*", embed.getDescription(), false);
                        }
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.deathsChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(embed, Localization.instance().playerDeath.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity())).replace("%msg%", ChatFormatting.m_126649_((String)deathMessage.getString()).replace(ForgeMessageUtils.formatPlayerName((Entity)ev.getEntity()) + " ", ""))), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.deathsChannelID));
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (this.stopped) {
            return;
        }
        if (Localization.instance().playerLeave.isBlank()) {
            return;
        }
        Player player = ev.getEntity();
        if (LinkManager.isPlayerLinked(player.m_20148_()) && LinkManager.getLink(null, (UUID)player.m_20148_()).settings.hideFromDiscord) {
            return;
        }
        DiscordIntegration.INSTANCE.callEventC(a -> a.onPlayerLeave(player.m_20148_()));
        String avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", player.m_20148_().toString()).replace("%uuid_dashless%", player.m_20148_().toString().replace("-", "")).replace("%name%", player.m_7755_().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
        if (DiscordIntegration.INSTANCE != null && !timeouts.contains(player.m_20148_())) {
            if (!Localization.instance().playerLeave.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerLeaveMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.playerLeaveMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbedJson(Configuration.instance().embedMode.playerLeaveMessages.customJSON.replace("%uuid%", player.m_20148_().toString()).replace("%uuid_dashless%", player.m_20148_().toString().replace("-", "")).replace("%name%", ForgeMessageUtils.formatPlayerName((Entity)player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID(player.m_20148_()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbed().setAuthor(ForgeMessageUtils.formatPlayerName((Entity)player), null, avatarURL).setDescription(Localization.instance().playerLeave.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)player)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerLeave.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)player)));
                }
            }
        } else if (DiscordIntegration.INSTANCE != null && timeouts.contains(player.m_20148_())) {
            if (!Localization.instance().playerTimeout.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerLeaveMessages.asEmbed) {
                    EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbed().setAuthor(ForgeMessageUtils.formatPlayerName((Entity)player), null, avatarURL).setDescription(Localization.instance().playerTimeout.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)player)));
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()));
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerTimeout.replace("%player%", ForgeMessageUtils.formatPlayerName((Entity)player)));
                }
            }
            timeouts.remove(player.m_20148_());
        }
    }

    static {
        nodes = new HashMap();
    }
}

