/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

public enum MinecraftPermission {
    USER("user", true, "Default user permissions package"),
    ADMIN("admin", false, "Admin permissions package, unlocks everything"),
    SEMD_MESSAGES("messages.send", false, "Allows users to send messages to discord"),
    READ_MESSAGES("messages.read", false, "Allows users to read messages from discord"),
    BYPASS_WHITELIST("whitelist.bypass", false, "Bypasses discord whitelist"),
    RUN_DISCORD_COMMAND("command", false, "Allows the usage of /discord's user commands"),
    RUN_DISCORD_COMMAND_ADMIN("command.admin", false, "Allows the usage of /discord's admin sub commands");

    private final String permission;
    private final String description;
    private final boolean defaultValue;

    private MinecraftPermission(String perm, boolean defaultValue, String description) {
        this.permission = "dcintegration." + perm;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public String getAsString() {
        return this.permission;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }
}

