/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import com.google.gson.JsonArray;
import dcshadow.com.vdurmont.emoji.EmojiParser;
import dcshadow.dev.vankka.mcdiscordreserializer.discord.DiscordSerializer;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import dcshadow.org.apache.commons.lang3.time.DurationFormatUtils;
import dcshadow.org.jetbrains.annotations.NotNull;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import java.time.Duration;
import java.time.Instant;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;

public class MessageUtils {
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern USER_PING_REGEX = Pattern.compile("(<@!?([0-9]{17,18})>)");
    private static final Pattern ROLE_PING_REGEX = Pattern.compile("(<@&([0-9]{17,20})>)");
    private static final Pattern CHANNEL_REGEX = Pattern.compile("(<#([0-9]{17,20})>)");
    private static final Pattern ANYPING_REGEX = Pattern.compile("(<..?([0-9]{17,20})>)");

    public static String[] makeStringArray(JsonArray channelID) {
        String[] out = new String[channelID.size()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = channelID.get(i).getAsString();
        }
        return out;
    }

    public static String getDiscordName(UUID p) {
        if (DiscordIntegration.INSTANCE == null) {
            return null;
        }
        if (Configuration.instance().linking.enableLinking && LinkManager.isPlayerLinked(p)) {
            PlayerLink link = LinkManager.getLink(null, p);
            if (link.settings.useDiscordNameInChannel) {
                return DiscordIntegration.INSTANCE.getChannel().getGuild().getMemberById(LinkManager.getLink(null, (UUID)p).discordID).getEffectiveName();
            }
        }
        return null;
    }

    public static String escapeMarkdown(String in) {
        return in.replace("(?<!\\\\)[`*_|~]/g", "\\\\$0");
    }

    public static String escapeMarkdownCodeBlocks(String in) {
        return in.replace("(?<!\\\\)`/g", "\\\\$0");
    }

    public static String getFullUptime() {
        if (DiscordIntegration.started == 0L) {
            return "?????";
        }
        Duration duration = Duration.between(Instant.ofEpochMilli(DiscordIntegration.started), Instant.now());
        return DurationFormatUtils.formatDuration(duration.toMillis(), Localization.instance().commands.uptimeFormat);
    }

    public static String convertMCToMarkdown(String in) {
        in = MessageUtils.escapeMarkdownCodeBlocks(in);
        try {
            return DiscordSerializer.INSTANCE.serialize(LegacyComponentSerializer.legacySection().deserialize(in));
        }
        catch (NullPointerException | ConcurrentModificationException ex) {
            ex.printStackTrace();
            return in;
        }
    }

    public static String removeFormatting(String text) {
        return FORMATTING_CODE_PATTERN.matcher(text).replaceAll("");
    }

    public static Component mentionsToNames(Component in, Guild targetGuild) {
        in = in.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(ANYPING_REGEX).replacement((result, builder) -> {
            builder.content(MessageUtils.mentionsToNames(builder.content(), targetGuild));
            return builder;
        }).build());
        return in;
    }

    public static String mentionsToNames(String in, Guild targetGuild) {
        String id;
        String str;
        JDA jda = DiscordIntegration.INSTANCE.getJDA();
        if (jda == null) {
            return in;
        }
        Matcher userMatcher = USER_PING_REGEX.matcher(in);
        Matcher roleMatcher = ROLE_PING_REGEX.matcher(in);
        Matcher channelMatcher = CHANNEL_REGEX.matcher(in);
        while (userMatcher.find()) {
            str = userMatcher.group(1);
            id = userMatcher.group(2);
            User u = jda.getUserById(id);
            if (u == null) continue;
            Member m = DiscordIntegration.INSTANCE.getMemberById(u.getIdLong());
            String name = m != null ? m.getEffectiveName() : u.getName();
            in = in.replace(str, "@" + name);
        }
        while (roleMatcher.find()) {
            str = roleMatcher.group(1);
            id = roleMatcher.group(2);
            Role role = targetGuild.getRoleById(id);
            if (role == null) continue;
            in = in.replace(str, "@" + role.getName());
        }
        while (channelMatcher.find()) {
            str = channelMatcher.group(1);
            id = channelMatcher.group(2);
            TextChannel channel = targetGuild.getTextChannelById(id);
            if (channel == null) continue;
            in = in.replace(str, "#" + channel.getName());
        }
        return in;
    }

    public static String formatEmoteMessage(List<CustomEmoji> emotes, String msg) {
        msg = EmojiParser.parseToAliases(msg);
        for (Emoji emoji : emotes) {
            msg = msg.replace(emoji.toString(), ":" + emoji.getName() + ":");
        }
        return msg;
    }

    @NotNull
    public static String getNameFromUUID(UUID uuid) {
        String name = DiscordIntegration.INSTANCE.getServerInterface().getNameFromUUID(uuid);
        return name == null || name.isEmpty() ? uuid.toString() : name;
    }
}

