/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.club.minnced.discord.webhook.send.AllowedMentions;
import dcshadow.club.minnced.discord.webhook.send.WebhookEmbed;
import dcshadow.club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;

public final class DiscordMessage {
    private final boolean isNotRaw;
    private MessageEmbed embed;
    private boolean isSystemMessage = true;
    private String message;

    public DiscordMessage(MessageEmbed embed, String message, boolean isNotRaw) {
        if (embed != null) {
            for (char c : Configuration.instance().messages.charBlacklist) {
                EmbedBuilder b = EmbedBuilder.fromData(embed.toData());
                if (embed.getDescription() != null) {
                    b.setDescription(embed.getDescription().replace(c, '\u0000'));
                }
                if (embed.getTitle() != null) {
                    b.setTitle(embed.getTitle().replace(c, '\u0000'), embed.getUrl());
                }
                if (embed.getAuthor() != null && embed.getAuthor().getName() != null) {
                    b.setAuthor(embed.getAuthor().getName().replace(c, '\u0000'), embed.getAuthor().getUrl(), embed.getAuthor().getIconUrl());
                }
                if (embed.getFooter() != null && embed.getFooter().getText() != null) {
                    b.setFooter(embed.getFooter().getText().replace(c, '\u0000'), embed.getFooter().getIconUrl());
                }
                b.clearFields();
                for (MessageEmbed.Field field : embed.getFields()) {
                    b.addField(field.getName() == null ? null : field.getName().replace(c, '\u0000'), field.getValue() == null ? null : field.getValue().replace(c, '\u0000'), field.isInline());
                }
                embed = b.build();
            }
        }
        this.embed = embed;
        this.message = message;
        for (char c : Configuration.instance().messages.charBlacklist) {
            this.message = this.message.replace(c, '\u0000');
        }
        this.isNotRaw = isNotRaw;
    }

    public DiscordMessage(MessageEmbed embed, String message) {
        this(embed, message, false);
    }

    public DiscordMessage(String message) {
        this(null, message, false);
    }

    public DiscordMessage(MessageEmbed embed) {
        this(embed, "", false);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        for (char c : Configuration.instance().messages.charBlacklist) {
            this.message = this.message.replace(c, '\u0000');
        }
    }

    public void setIsChatMessage() {
        this.isSystemMessage = false;
    }

    public MessageEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(MessageEmbed embed) {
        for (char c : Configuration.instance().messages.charBlacklist) {
            EmbedBuilder b = EmbedBuilder.fromData(embed.toData());
            if (embed.getDescription() != null) {
                b.setDescription(embed.getDescription().replace(c, '\u0000'));
            }
            if (embed.getTitle() != null) {
                b.setTitle(embed.getTitle().replace(c, '\u0000'), embed.getUrl());
            }
            if (embed.getAuthor() != null && embed.getAuthor().getName() != null) {
                b.setAuthor(embed.getAuthor().getName().replace(c, '\u0000'), embed.getAuthor().getUrl(), embed.getAuthor().getIconUrl());
            }
            if (embed.getFooter() != null && embed.getFooter().getText() != null) {
                b.setFooter(embed.getFooter().getText().replace(c, '\u0000'), embed.getFooter().getIconUrl());
            }
            b.clearFields();
            for (MessageEmbed.Field field : embed.getFields()) {
                b.addField(field.getName().replace(c, '\u0000'), field.getValue().replace(c, '\u0000'), field.isInline());
            }
            embed = b.build();
        }
        this.embed = embed;
    }

    public MessageCreateData buildMessages() {
        MessageCreateBuilder out = new MessageCreateBuilder();
        if (!this.isSystemMessage) {
            ArrayList<Message.MentionType> mentions = new ArrayList<Message.MentionType>();
            mentions.add(Message.MentionType.USER);
            mentions.add(Message.MentionType.CHANNEL);
            mentions.add(Message.MentionType.EMOJI);
            out.setAllowedMentions(mentions);
        } else {
            out.setAllowedMentions(Arrays.asList(Message.MentionType.values()));
        }
        if (!this.message.isEmpty()) {
            if (this.isNotRaw) {
                out.setContent(MessageUtils.convertMCToMarkdown(this.message));
            } else {
                out.setContent(this.message);
            }
        }
        if (this.embed != null) {
            out.setEmbeds(this.embed);
        }
        return out.build();
    }

    private String[] splitMessages(String inMsg) {
        if (inMsg.length() <= 2000) {
            return new String[]{inMsg};
        }
        String[] split = inMsg.split(" ");
        ArrayList<String> outStrings = new ArrayList<String>();
        StringBuilder bufferString = new StringBuilder();
        for (String s : split) {
            if ((bufferString + " " + s).length() > 2000) {
                outStrings.add(bufferString.toString());
                bufferString = new StringBuilder(" ");
                continue;
            }
            bufferString.append(s);
        }
        outStrings.add(bufferString.toString());
        return outStrings.toArray(new String[0]);
    }

    public ArrayList<WebhookMessageBuilder> buildWebhookMessages() {
        ArrayList<WebhookMessageBuilder> out = new ArrayList<WebhookMessageBuilder>();
        if (!this.message.isEmpty()) {
            String content = this.isNotRaw ? MessageUtils.convertMCToMarkdown(this.message) : this.message;
            for (String msg : this.splitMessages(content)) {
                out.add(new WebhookMessageBuilder().setContent(msg).setAllowedMentions(this.isSystemMessage ? AllowedMentions.all() : AllowedMentions.none().withParseUsers(true)));
            }
        }
        if (this.embed != null) {
            WebhookEmbedBuilder eb = new WebhookEmbedBuilder();
            if (this.embed.getAuthor() != null) {
                eb.setAuthor(new WebhookEmbed.EmbedAuthor(this.embed.getAuthor().getName(), this.embed.getAuthor().getIconUrl(), this.embed.getAuthor().getUrl()));
            }
            eb.setColor(this.embed.getColorRaw());
            eb.setDescription(this.embed.getDescription());
            if (this.embed.getFooter() != null) {
                eb.setFooter(new WebhookEmbed.EmbedFooter(this.embed.getFooter().getText(), this.embed.getFooter().getIconUrl()));
            }
            if (this.embed.getImage() != null) {
                eb.setImageUrl(this.embed.getImage().getUrl());
            }
            if (this.embed.getThumbnail() != null) {
                eb.setThumbnailUrl(this.embed.getThumbnail().getUrl());
            }
            for (MessageEmbed.Field f : this.embed.getFields()) {
                eb.addField(new WebhookEmbed.EmbedField(f.isInline(), f.getName(), f.getValue()));
            }
            eb.setTimestamp(this.embed.getTimestamp());
            if (this.embed.getTitle() != null) {
                eb.setTitle(new WebhookEmbed.EmbedTitle(this.embed.getTitle(), this.embed.getUrl()));
            }
            if (out.isEmpty()) {
                out.add(new WebhookMessageBuilder().setAllowedMentions(this.isSystemMessage ? AllowedMentions.all() : AllowedMentions.none().withParseUsers(true)).addEmbeds(eb.build()));
            } else {
                out.set(out.size() - 1, out.get(out.size() - 1).setAllowedMentions(this.isSystemMessage ? AllowedMentions.all() : AllowedMentions.none().withParseUsers(true)).addEmbeds(eb.build()));
            }
        }
        return out;
    }
}

