/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.threads;

import dcshadow.org.apache.commons.collections4.KeyValue;
import dcshadow.org.jetbrains.annotations.NotNull;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.UUID;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Activity;

public class StatusUpdateTask
extends TimerTask {
    private final DiscordIntegration dc;

    public StatusUpdateTask(DiscordIntegration dc) {
        this.dc = dc;
    }

    @Override
    public void run() {
        JDA jda = this.dc.getJDA();
        if (jda != null) {
            String game = this.getString();
            switch (Configuration.instance().general.botStatusType) {
                case DISABLED: {
                    break;
                }
                case LISTENING: {
                    jda.getPresence().setActivity(Activity.listening(game));
                    break;
                }
                case PLAYING: {
                    jda.getPresence().setActivity(Activity.playing(game));
                    break;
                }
                case WATCHING: {
                    jda.getPresence().setActivity(Activity.watching(game));
                    break;
                }
                case COMPETING: {
                    jda.getPresence().setActivity(Activity.competing(game));
                    break;
                }
                case STREAMING: {
                    jda.getPresence().setActivity(Activity.streaming(game, Configuration.instance().general.streamingURL));
                    break;
                }
                case CUSTOM: {
                    jda.getPresence().setActivity(Activity.customStatus(game));
                }
            }
        }
        ArrayList<Integer> remove = new ArrayList<Integer>();
        this.clearLinks(remove, LinkManager.pendingLinks);
        this.clearLinks(remove, LinkManager.pendingBedrockLinks);
        remove.clear();
    }

    @NotNull
    private String getString() {
        String game = this.dc.getServerInterface().getOnlinePlayers() == 1 && !Configuration.instance().general.botStatusNameSingular.isBlank() ? Configuration.instance().general.botStatusNameSingular.replace("%online%", String.valueOf(this.dc.getServerInterface().getOnlinePlayers())).replace("%max%", String.valueOf(this.dc.getServerInterface().getMaxPlayers())) : (this.dc.getServerInterface().getOnlinePlayers() == 0 && !Configuration.instance().general.botStatusNameEmpty.isBlank() ? Configuration.instance().general.botStatusNameEmpty.replace("%online%", String.valueOf(this.dc.getServerInterface().getOnlinePlayers())).replace("%max%", String.valueOf(this.dc.getServerInterface().getMaxPlayers())) : Configuration.instance().general.botStatusName.replace("%online%", String.valueOf(this.dc.getServerInterface().getOnlinePlayers())).replace("%max%", String.valueOf(this.dc.getServerInterface().getMaxPlayers())));
        return game;
    }

    private void clearLinks(ArrayList<Integer> remove, HashMap<Integer, KeyValue<Instant, UUID>> pendingLinks) {
        pendingLinks.forEach((k, v) -> {
            Instant now = Instant.now();
            Duration d = Duration.between((Temporal)v.getKey(), now);
            if (d.toMinutes() > 10L) {
                remove.add((Integer)k);
            }
        });
        for (int i : remove) {
            pendingLinks.remove(i);
        }
    }
}

