/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage;

import dcshadow.com.moandjiezana.toml.Toml;
import dcshadow.com.moandjiezana.toml.TomlComment;
import dcshadow.com.moandjiezana.toml.TomlIgnore;
import dcshadow.com.moandjiezana.toml.TomlWriter;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import java.io.IOException;

public class Localization {
    @TomlIgnore
    private static Localization INSTANCE = new Localization();
    @TomlComment(value={"This is what will be displayed in-game when someone types into the bots channel", "PLACEHOLDERS:", "%user% - The username", "%id% - The user ID", "%msg% - The message"})
    public String ingame_discordMessage = "\u00a76[\u00a7#5865F2DISCORD\u00a76]\u00a7r <%user%> %msg%";
    @TomlComment(value={"This is what will be displayed in-game when someone sends an reply into the bots channel", "PLACEHOLDERS:", "%user% - The username", "%id% - The user ID", "%msg% - The reply message", "%ruser% - The username of the message that got the reply", "%rmsg% - The replied message"})
    public String ingame_discordReplyMessage = "\u00a76[\u00a7#5865F2DISCORD\u00a76]\u00a7r \u00a7a%user%\u00a7r in reply to \u00a73%ruser%\u00a7r: %msg%";
    @TomlComment(value={"Message shown when hovering over the username of an discord message", "PLACEHOLDERS:", "%user% - The users display name (Someone123)", "%user#tag% - The users username (@username) or user tag (User#0001)", "%id% - The user ID", "", "NOTE: using an @ here can cause ping sounds in-game"})
    public String discordUserHover = "\u00a73Discord User %user%\n\u00a7aClick to mention";
    @TomlComment(value={"This message will edited in / sent when the server finished starting"})
    public String serverStarted = "Server Started!";
    @TomlComment(value={"Message to show while the server is starting", "This will be edited to SERVER_STARTED_MSG when webhook is false"})
    public String serverStarting = "Server Starting...";
    @TomlComment(value={"This message will be sent when the server was stopped"})
    public String serverStopped = "Server Stopped!";
    @TomlComment(value={"The message to print to discord when it was possible to detect a server crash"})
    public String serverCrash = "Server Crash Detected :thinking:";
    @TomlComment(value={"Gets sent when an player joins", "", "PLACEHOLDERS:", "%player% - The player's name"})
    public String playerJoin = "%player% joined";
    @TomlComment(value={"Gets sent when an player leaves", "", "PLACEHOLDERS:", "%player% - The player's name"})
    public String playerLeave = "%player% left";
    @TomlComment(value={"Gets sent when an player dies", "", "PLACEHOLDERS:", "%player% - The player's name", "%msg% - The death message"})
    public String playerDeath = "%player% %msg%";
    @TomlComment(value={"Message sent instead of playerLeave, when the player times out", "", "PLACEHOLDERS:", "%player% - The player's name"})
    public String playerTimeout = "%player% timed out!";
    @TomlComment(value={"Gets sent when an player finishes an advancement", "Supports MultiLined messages using \\n", "", "PLACEHOLDERS:", "%player% - The player's name", "%advName% - The advancement name", "%advDesc% - The advancement description", "%advNameURL% - The advancement name in an URL-Encoded form", "%advDescURL% - The advancement description in an URL-Encoded form"})
    public String advancementMessage = "%player% just made the advancement **%advName%**\n_%advDesc%_";
    @TomlComment(value={"The chat message in discord, sent from an player in-game", "", "PLACEHOLDERS:", "%player% - The player's name", "%msg% - The chat message"})
    public String discordChatMessage = "%player%: %msg%";
    @TomlComment(value={"Sent to a player when someone reacts to his messages", "PLACEHOLDERS:", "%name% - (Nick-)Name of the user who reacted (format: 'SomeNickName')", "%name2% - Name of the user who reacted with discord discriminator (format: 'SomeName#0123')", "%msg% - Content of the message which got the reaction", "%emote% - The reacted emote"})
    public String reactionMessage = "\u00a76[\u00a7#5865F2DISCORD\u00a76]\u00a7r\u00a77 %name% reacted to your message \"\u00a79%msg%\u00a77\" with '%emote%'";
    @TomlComment(value={"Message shown for attachments"})
    public String attachment = "Attachment";
    @TomlComment(value={"Message shown for stickers"})
    public String sticker = "Sticker";
    @TomlComment(value={"Header for Embeds"})
    public String embed = "Embed";
    @TomlComment(value={"Message shown for embed images"})
    public String embedImage = "Image";
    @TomlComment(value={"Message shown for embed messages"})
    public String embedMessage = "Message";
    @TomlComment(value={"Hover message for the bot tag in-game"})
    public String bot = "This user is an bot";
    @TomlComment(value={"Strings about the discord commands"})
    public Commands commands = new Commands();
    @TomlComment(value={"Strings about the account linking feature"})
    public Linking linking = new Linking();
    @TomlComment(value={"Strings about the personal settings feature"})
    public PersonalSettings personalSettings = new PersonalSettings();

    public static Localization instance() {
        return INSTANCE;
    }

    public void loadConfig() throws IOException, IllegalStateException {
        if (!DiscordIntegration.messagesFile.exists()) {
            INSTANCE = new Localization();
            INSTANCE.saveConfig();
            return;
        }
        INSTANCE = new Toml().read(DiscordIntegration.messagesFile).to(Localization.class);
        INSTANCE.saveConfig();
    }

    public void saveConfig() throws IOException {
        if (!DiscordIntegration.messagesFile.exists()) {
            if (!DiscordIntegration.messagesFile.getParentFile().exists()) {
                DiscordIntegration.messagesFile.getParentFile().mkdirs();
            }
            DiscordIntegration.messagesFile.createNewFile();
        }
        TomlWriter w = new TomlWriter.Builder().indentValuesBy(2).indentTablesBy(4).padArrayDelimitersBy(2).build();
        w.write((Object)this, DiscordIntegration.messagesFile);
    }

    public static class Commands {
        @TomlComment(value={"Shown in console when trying to use a in-game only command"})
        public String ingameOnly = "This command can only be executed in-game!";
        @TomlComment(value={"Shown in-game when trying to use a console only command"})
        public String consoleOnly = "This command can only be executed from console!";
        @TomlComment(value={"Shown when successfully reloading the config file"})
        public String configReloaded = "Config reloaded!";
        @TomlComment(value={"Shown when an subcommand is disabled"})
        public String subcommandDisabled = "This subcommand is disabled!";
        @TomlComment(value={"Message sent when user does not have permission to run a command"})
        public String noPermission = "You don't have permission to execute this command!";
        @TomlComment(value={"Message sent when an invalid command was typed", "", "PLACEHOLDERS:"})
        public String unknownCommand = "Unknown command, try `/help` for a list of commands";
        @TomlComment(value={"Message if a player provides less arguments than required"})
        public String notEnoughArguments = "Not enough arguments";
        @TomlComment(value={"Message if a player provides too many arguments"})
        public String tooManyArguments = "Too many arguments";
        @TomlComment(value={"Message if a player can not be found", "", "PLACEHOLDERS:", "%player% - The player's name"})
        public String playerNotFound = "Can not find player \"%player%\"";
        @TomlComment(value={"The message for 'list' when no player is online"})
        public String cmdList_empty = "There is no player online...";
        @TomlComment(value={"The header for 'list' when one player is online"})
        public String cmdList_one = "There is 1 player online:";
        @TomlComment(value={"The header for 'list'", "PLACEHOLDERS:", "%amount% - The amount of players online"})
        public String cmdList_header = "There are %amount% players online:";
        @TomlComment(value={"Header of the help command"})
        public String cmdHelp_header = "Your available commands in this channel:";
        @TomlComment(value={"Message sent when ignoring Discord messages"})
        public String commandIgnore_ignore = "You are now ignoring Discord messages!";
        @TomlComment(value={"Message sent when un-ignoring Discord messages"})
        public String commandIgnore_unignore = "You are no longer ignoring Discord messages!";
        @TomlComment(value={"Message sent when using the uptime command", "", "PLACEHOLDERS:", "%uptime% - Uptime in uptime format, see uptimeFormat"})
        public String cmdUptime_message = "The server is running for %uptime%";
        @TomlComment(value={"The format of the uptime command", "For more help with the formatting visit https://commons.apache.org/proper/commons-lang/apidocs/org/apache/commons/lang3/time/DurationFormatUtils.html"})
        public String uptimeFormat = "dd 'days' HH 'hours' mm 'minutes'";
        @TomlComment(value={"Shows when running slash commands as command response"})
        public String executing = "Executing...";
        @TomlComment(value={"Command argument description for the linkcheck command's Discord user parameter"})
        public String cmdLinkcheck_userargDesc = "The discord user to check";
        @TomlComment(value={"Command argument description for the linkcheck command's minecraft player parameter"})
        public String cmdLinkcheck_mcargDesc = "The minecraft player's UUID or Name to check";
        @TomlComment(value={"Sent when checked user is not linked"})
        public String cmdLinkcheck_notlinked = "This account is not linked!";
        @TomlComment(value={""})
        public String cmdLinkcheck_discordAcc = "Discord-Account: ";
        public String cmdLinkcheck_minecraftAcc = "Minecraft Account: ";
        public String cmdLinkcheck_minecraftAccFloodgate = "Minecraft (Bedrock) UUID: ";
        public String cmdLinkcheck_cannotGetPlayer = "Error getting player information! Maybe you used an invalid name / UUID";
        public String cmdSett_key = "Destination settings key";
        public String cmdSett_val = "Settings value";
        public String cmdSett_set = "Change an setting";
        public String cmdSett_get = "Retrieve an setting value";
        @TomlComment(value={"Command descriptions"})
        public Descriptions descriptions = new Descriptions();

        public static class Descriptions {
            public String settings = "Allows you to edit your personal settings";
            public String uptime = "Displays the server uptime";
            public String help = "Displays a list of all commands";
            public String list = "Lists all players currently online";
            public String link = "Links your Discord account with your Minecraft account";
            public String whitelist = "Whitelists you on the server by linking with Discord";
            public String linkcheck = "Shows info about an linked discord user or an in-game player";
        }
    }

    public static class Linking {
        @TomlComment(value={"Sent to the user when he linked his discord successfully", "PLACEHOLDERS:", "%player% - The in-game player name"})
        public String linkSuccessful = "Your account is now linked with %player%.\nUse /settings to view and set some user-specific settings";
        @TomlComment(value={"Sent to the user when linking fails"})
        public String linkFailed = "Account link failed";
        @TomlComment(value={"Sent when an already linked user attempts to link an account", "PLACEHOLDERS:", "%player% - The in-game player name"})
        public String alreadyLinked = "Your account is already linked with %player%";
        @TomlComment(value={"Sent when attempting to use personal commands while not linked", "PLACEHOLDERS:", "%method% - The currently enabled method for linking"})
        public String notLinked = "Your account is not linked! Link it first using %method%";
        @TomlComment(value={"Message of the link method in whitelist mode", "Used by %method% placeholder"})
        public String linkMethodWhitelistCode = "joining the server and then using `/link <whitelist-code>` here";
        @TomlComment(value={"Message of the link method in normal mode", "Used by %method% placeholder"})
        public String linkMethodIngame = "`/discord link` in-game";
        @TomlComment(value={"Sent when attempting to whitelist-link with an non uuid string", "PLACEHOLDERS:", "%arg% - The provided argument"})
        public String link_argumentNotUUID = "Argument \"%arg%\" is not an valid UUID or Name.";
        @TomlComment(value={"Sent when attempting to link with an unknown number"})
        public String invalidLinkNumber = "Invalid link number!";
        @TomlComment(value={"Sent when attempting to link with an invalid number"})
        public String linkNumberNAN = "This is not a number!";
        @TomlComment(value={"Message shown to players who are not whitelisted using discord", "No effect if discord whitelist is off"})
        public String notWhitelistedCode = "\u00a7cYou are not whitelisted.\nJoin the discord server for more information\nhttps://discord.gg/someserver\nYour Whitelist-Code is: \u00a76%code%";
        @TomlComment(value={"Message shown to players who are whitelisted using discord but don't have the required role anymore", "No effect if discord whitelist is off"})
        public String notWhitelistedRole = "\u00a7cYou are whitelisted, but you need an role to join.\nSee the discord server for more information";
        @TomlComment(value={"Sent when trying to link without an required role"})
        public String link_requiredRole = "You need to have an role to use this";
        @TomlComment(value={"Sent when trying to link as an non-member"})
        public String link_notMember = "You are not member of the Discord-Server this bot is operating in!";
        @TomlComment(value={"Sent to the user when he linked his discord successfully", "PLACEHOLDERS:", "%name% - The linked discord name", "%name#tag% - The linked discord name with tag"})
        public String linkSuccessfulIngame = "Your account is now linked with discord-user %name#tag%";
        @TomlComment(value={"Message shown to players who want to link their discord account in-game", "", "PLACEHOLDERS:", "%num% - The link number"})
        public String linkMsgIngame = "Send this command to the server channel to link your account: /link %num%\nThis number will expire after 10 minutes";
        @TomlComment(value={"Shown when hovering over the link message"})
        public String hoverMsg_copyClipboard = "Click to copy command to clipboard";
    }

    public static class PersonalSettings {
        @TomlComment(value={"Message for getting an setting's value"})
        public String personalSettingGet = "This settings value is `%bool%`";
        @TomlComment(value={"Sent when user successfully updates an personal setting"})
        public String settingUpdateSuccessful = "Successfully updated setting!";
        @TomlComment(value={"Header of the personal settings list"})
        public String personalSettingsHeader = "Personal Settings list:";
        @TomlComment(value={"Error message when providing an invalid personal setting name"})
        public String invalidPersonalSettingKey = "`%key%` is not an valid setting!";
        @TomlComment(value={})
        public String settingsCommandUsage = "Usages:\n\n/settings - lists all available keys\n/settings get <key> - Gets the current settings value\n/settings set <key> <value> - Sets an Settings value";
        @TomlComment(value={"Sent when setting an personal setting fails"})
        public String settingUpdateFailed = "Failed to set value :/";
        @TomlComment(value={"Sent when attempting to change an blacklisted setting"})
        public String settingUpdateBlocked = "The server owner disabled changing of this setting";
        @TomlComment(value={"Descriptions of the settings"})
        public Descriptions descriptons = new Descriptions();

        public static class Descriptions {
            public String ignoreDiscordChatIngame = "Configure if you want to ignore discord chat in-game";
            public String useDiscordNameInChannel = "Should the bot send messages using your discord name and avatar instead of your in-game name and skin?";
            public String ignoreReactions = "Configure if you want to ignore discord reactions in-game";
            public String pingSound = "Toggle the in-game ping sound";
            public String hideFromDiscord = "Setting this to true will hide all of your minecraft messages from discord";
        }
    }
}

