/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage;

import dcshadow.org.apache.commons.lang3.ArrayUtils;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandFromConfig;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandLink;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandLinkcheck;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandList;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandSettings;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.CommandUptime;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.configCmd.ConfigCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;

public class CommandRegistry {
    public static final HashMap<String, DiscordCommand> registeredCMDs = new HashMap();
    private static List<DiscordCommand> commands = new ArrayList<DiscordCommand>();

    public static void registerDefaultCommands() {
        if (Configuration.instance().commands.listCmdEnabled) {
            CommandRegistry.registerCommand(new CommandList());
        }
        if (Configuration.instance().commands.uptimeCmdEnabled) {
            CommandRegistry.registerCommand(new CommandUptime());
        }
        if (Configuration.instance().linking.enableLinking) {
            CommandRegistry.registerCommand(new CommandSettings());
            CommandRegistry.registerCommand(new CommandLinkcheck());
            CommandRegistry.registerCommand(new CommandLink());
        }
        CommandRegistry.registerConfigCommands();
    }

    public static void updateSlashCommands() throws IllegalStateException {
        CommandListUpdateAction commandListUpdateAction;
        GuildMessageChannel channel = DiscordIntegration.INSTANCE.getChannel();
        if (channel == null) {
            throw new IllegalStateException("Channel does not exist, check channel ID and bot permissions on both channel and category. Also make sure to enable all intents for the bot on https://discord.com/developers/applications/" + DiscordIntegration.INSTANCE.getJDA().getSelfUser().getApplicationId() + "/bot");
        }
        List<Command> localCmds = channel.getGuild().retrieveCommands().complete();
        List<Command> globalCmds = DiscordIntegration.INSTANCE.getJDA().retrieveCommands().complete();
        boolean localCommandsStale = !localCmds.isEmpty() && !Configuration.instance().commands.useLocalCommands;
        boolean globalCommandsStale = !globalCmds.isEmpty() && Configuration.instance().commands.useLocalCommands;
        boolean regenLocal = false;
        boolean regenGlobal = false;
        if (Configuration.instance().commands.useLocalCommands) {
            if (commands.size() == localCmds.size()) {
                for (DiscordCommand discordCommand : commands) {
                    cm = null;
                    for (Command c : localCmds) {
                        if (!discordCommand.getName().equals(c.getName())) continue;
                        cm = c;
                        break;
                    }
                    if (cm == null) {
                        regenLocal = true;
                    } else {
                        if (CommandRegistry.optionsEqual(discordCommand.getOptions(), cm.getOptions())) continue;
                        regenLocal = true;
                    }
                    break;
                }
            } else {
                regenLocal = true;
            }
        } else if (commands.size() == globalCmds.size()) {
            for (DiscordCommand discordCommand : commands) {
                cm = null;
                for (Command c : globalCmds) {
                    if (!discordCommand.getName().equals(c.getName())) continue;
                    cm = c;
                    break;
                }
                if (cm == null) {
                    regenGlobal = true;
                } else {
                    if (CommandRegistry.optionsEqual(discordCommand.getOptions(), cm.getOptions())) continue;
                    regenGlobal = true;
                }
                break;
            }
        } else {
            regenGlobal = true;
        }
        if (regenLocal || localCommandsStale) {
            DiscordIntegration.LOGGER.info("Regenerating local commands...");
            commandListUpdateAction = channel.getGuild().updateCommands();
            if (Configuration.instance().commands.useLocalCommands) {
                for (DiscordCommand cmd : commands) {
                    commandListUpdateAction = commandListUpdateAction.addCommands(cmd);
                }
            }
            CompletableFuture completableFuture = commandListUpdateAction.submit();
            if (Configuration.instance().commands.useLocalCommands) {
                completableFuture.thenAccept(CommandRegistry::addCmds);
            }
        } else {
            DiscordIntegration.LOGGER.info("No need to regenerate local commands");
            CommandRegistry.addCmds(localCmds);
        }
        if (regenGlobal || globalCommandsStale) {
            DiscordIntegration.LOGGER.info("Regenerating global commands...");
            commandListUpdateAction = DiscordIntegration.INSTANCE.getJDA().updateCommands();
            if (!Configuration.instance().commands.useLocalCommands) {
                for (DiscordCommand cmd : commands) {
                    commandListUpdateAction = commandListUpdateAction.addCommands(cmd);
                }
            }
            CompletableFuture completableFuture = commandListUpdateAction.submit();
            if (!Configuration.instance().commands.useLocalCommands) {
                completableFuture.thenAccept(CommandRegistry::addCmds);
            }
        } else {
            DiscordIntegration.LOGGER.info("No need to regenerate global commands");
            CommandRegistry.addCmds(globalCmds);
        }
    }

    private static boolean optionsEqual(List<OptionData> data, List<Command.Option> options) {
        if (data.size() != options.size()) {
            return false;
        }
        int i = 0;
        if (i < data.size()) {
            OptionData optionData = data.get(i);
            Command.Option option = options.get(i);
            return option.getName().equals(optionData.getName()) && option.getChoices().equals(optionData.getChoices()) && option.getDescription().equals(optionData.getDescription()) && option.isRequired() == optionData.isRequired() && option.getType().equals((Object)optionData.getType());
        }
        return true;
    }

    private static void registerConfigCommands() {
        for (ConfigCommand cmd : Configuration.instance().commands.customCommands) {
            try {
                CommandFromConfig regCmd = new CommandFromConfig(cmd.name, cmd.description, cmd.mcCommand, cmd.adminOnly, cmd.args, cmd.hidden, cmd.textToSend);
                if (CommandRegistry.registerCommand(regCmd)) continue;
                DiscordIntegration.LOGGER.error("Failed Registering command \"" + cmd.name + "\" because it would override an existing command!");
            }
            catch (IllegalArgumentException e) {
                DiscordIntegration.LOGGER.error("Failed Registering command \"" + cmd.name + "\":");
                e.printStackTrace();
            }
        }
        DiscordIntegration.LOGGER.info("Finished registering! Registered " + commands.size() + " commands");
    }

    public static boolean registerCommand(DiscordCommand cmd) {
        if (DiscordIntegration.started != -1L) {
            DiscordIntegration.LOGGER.info("Attempted to register command " + cmd.getName() + "after server finished loading");
            return false;
        }
        ArrayList<DiscordCommand> toRemove = new ArrayList<DiscordCommand>();
        for (DiscordCommand c : commands) {
            if (!cmd.isConfigCommand() && cmd.equals(c)) {
                return false;
            }
            if (!cmd.isConfigCommand() || !cmd.equals(c)) continue;
            toRemove.add(c);
        }
        for (DiscordCommand cm : toRemove) {
            commands.remove(cm);
        }
        commands.add(cmd);
        if (cmd instanceof CommandFromConfig && cmd.isUsingArgs()) {
            cmd.addOption(OptionType.STRING, "args", cmd.getArgText());
        }
        return true;
    }

    private static void addCmds(List<Command> cmds) {
        for (Command cmd : cmds) {
            for (DiscordCommand cfcmd : commands) {
                if (!cmd.getName().equals(cfcmd.getName())) continue;
                registeredCMDs.put(cmd.getId(), cfcmd);
                DiscordIntegration.LOGGER.info("Added command " + cmd.getName() + " with ID " + cmd.getIdLong());
            }
        }
    }

    private static ArrayList<Role> getAdminRoles(Guild g) {
        List<Role> gRoles = g.getRoles();
        ArrayList<Role> adminRoles = new ArrayList<Role>();
        for (Role r : gRoles) {
            if (!ArrayUtils.contains(Configuration.instance().commands.adminRoleIDs, r.getId())) continue;
            adminRoles.add(r);
        }
        return adminRoles;
    }

    public static void reRegisterAllCommands() {
        List<DiscordCommand> cmds = commands;
        DiscordIntegration.LOGGER.info("Reloading " + cmds.size() + " commands");
        commands = new ArrayList<DiscordCommand>();
        for (DiscordCommand cmd : cmds) {
            if (cmd.isConfigCommand()) continue;
            commands.add(cmd);
        }
        DiscordIntegration.LOGGER.info("Registered " + commands.size() + " commands");
    }

    public static List<DiscordCommand> getCommandList() {
        return commands;
    }
}

