/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dcshadow.club.minnced.discord.webhook.external.JDAWebhookClient;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import dcshadow.dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dcshadow.dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import dcshadow.dev.vankka.simpleast.core.node.Node;
import dcshadow.dev.vankka.simpleast.core.node.TextNode;
import dcshadow.dev.vankka.simpleast.core.parser.ParseSpec;
import dcshadow.dev.vankka.simpleast.core.parser.Parser;
import dcshadow.dev.vankka.simpleast.core.parser.Rule;
import dcshadow.okhttp.OkHttpClient;
import dcshadow.org.apache.commons.lang3.ArrayUtils;
import dcshadow.org.apache.commons.lang3.StringUtils;
import de.erdbeerbaerlp.dcintegration.common.DiscordEventListener;
import de.erdbeerbaerlp.dcintegration.common.WorkThread;
import de.erdbeerbaerlp.dcintegration.common.addon.AddonLoader;
import de.erdbeerbaerlp.dcintegration.common.api.DiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.common.minecraftCommands.McCommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.database.DBInterface;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.database.JSONInterface;
import de.erdbeerbaerlp.dcintegration.common.threads.MessageQueueTask;
import de.erdbeerbaerlp.dcintegration.common.threads.StatusUpdateTask;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.McServerInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildMessageChannel;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.exceptions.InvalidTokenException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.requests.RestConfig;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscordIntegration {
    public static DiscordIntegration INSTANCE;
    public static final String VERSION;
    public static final File discordDataDir;
    private static final File IGNORED_PLAYERS;
    public static final Gson gson;
    public final ArrayList<UUID> ignoringPlayers = new ArrayList();
    public static final Logger LOGGER;
    public static final MinecraftSerializerOptions mcSerializerOptions;
    public static final int apiVersion = 3;
    final ArrayList<DiscordEventHandler> eventHandlers = new ArrayList();
    public static File configFile;
    public static File messagesFile;
    public static CompletableFuture<Message> startingMsg;
    public static final UUID dummyUUID;
    public static long started;
    private JDA jda;
    private final HashMap<String, GuildMessageChannel> channelCache;
    static final Map<Long, Member> memberCache;
    private DiscordEventListener listener;
    final HashMap<String, UUID> recentMessages;
    private DBInterface linkDbInterface;
    private final McServerInterface serverInterface;
    private Thread launchThread;
    private TimerTask messageSender;
    private TimerTask statusUpdater;
    private static Timer timer;
    private final HashMap<String, Webhook> webhookHashMap;
    private final HashMap<String, JDAWebhookClient> webhookClis;

    public DiscordIntegration(McServerInterface serverInterface) {
        this.eventHandlers.add(new DiscordEventHandler(){});
        this.jda = null;
        this.channelCache = new HashMap();
        this.recentMessages = new HashMap(150);
        this.webhookHashMap = new HashMap();
        this.webhookClis = new HashMap();
        this.serverInterface = serverInterface;
        try {
            DiscordIntegration.loadConfigs();
        }
        catch (IOException e) {
            LOGGER.error("Error loading config");
            e.printStackTrace();
            return;
        }
        this.launchThread = new LaunchThread();
        this.launchThread.start();
    }

    public void registerEventHandler(DiscordEventHandler handler) {
        if (!this.eventHandlers.contains(handler)) {
            this.eventHandlers.add(handler);
        }
    }

    public void unregisterEventHandler(DiscordEventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    private void unregisterAllEventHandlers() {
        this.eventHandlers.clear();
    }

    public <T> T callEventO(Function<DiscordEventHandler, T> func) {
        for (DiscordEventHandler h : this.eventHandlers) {
            T result = func.apply(h);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean callEvent(Function<DiscordEventHandler, Boolean> func) {
        for (DiscordEventHandler h : this.eventHandlers) {
            if (!func.apply(h).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void callEventC(Consumer<DiscordEventHandler> consumer) {
        for (DiscordEventHandler h : this.eventHandlers) {
            consumer.accept(h);
        }
    }

    public static void loadConfigs() throws IOException {
        block13: {
            if (!discordDataDir.exists()) {
                discordDataDir.mkdirs();
            }
            Configuration.instance().loadConfig();
            if (!Configuration.instance().messages.language.equals("local")) {
                File backupFile = new File(messagesFile, ".bak");
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                try {
                    URL langURL = new URL("https://raw.githubusercontent.com/ErdbeerbaerLP/Discord-Integration-Translations/main/" + Configuration.instance().messages.language + ".toml");
                    HttpsURLConnection urlConnection = (HttpsURLConnection)langURL.openConnection();
                    urlConnection.setRequestMethod("GET");
                    urlConnection.connect();
                    if (urlConnection.getResponseCode() != 200) break block13;
                    messagesFile.renameTo(backupFile);
                    try (InputStream in = urlConnection.getInputStream();){
                        Files.copy(in, messagesFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException ex) {
                    if (!backupFile.exists()) break block13;
                    backupFile.renameTo(messagesFile);
                }
            }
        }
        Localization.instance().loadConfig();
        if (StringUtils.containsIgnoreCase(Configuration.instance().webhook.webhookName, "discord")) {
            StringUtils.replaceIgnoreCase(Configuration.instance().webhook.webhookName, "discord", "dc");
            LOGGER.info("Fixed webhook name containing the word \"Discord\".");
            Configuration.instance().saveConfig();
        }
        if (Localization.instance().advancementMessage.contains("%desc%") || Localization.instance().advancementMessage.contains("%name%")) {
            Localization.instance().advancementMessage = Localization.instance().advancementMessage.replace("%msg%", "%advDesc%").replace("%name%", "%advName%");
            LOGGER.info("Migrated advancement message string");
            Localization.instance().saveConfig();
        }
    }

    public void startThreads() {
        if (Configuration.instance().commands.enabled) {
            WorkThread.executeJob(() -> {
                block3: {
                    try {
                        CommandRegistry.updateSlashCommands();
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error((Object)e);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                        if (!Configuration.instance().commands.useLocalCommands) break block3;
                        LOGGER.error("Failed to register slash commands! Please re-invite the bot to all servers the bot is on using this link: " + this.jda.getInviteUrl(Permission.getPermissions(2953964624L)).replace("scope=", "scope=applications.commands%20"));
                    }
                }
            });
        }
        if (this.statusUpdater == null) {
            this.statusUpdater = new StatusUpdateTask(this);
        }
        if (this.messageSender == null) {
            this.messageSender = new MessageQueueTask(this);
        }
        timer.scheduleAtFixedRate(this.statusUpdater, 0L, TimeUnit.SECONDS.toMillis(10L));
        timer.scheduleAtFixedRate(this.messageSender, 0L, TimeUnit.SECONDS.toMillis(1L));
        if (JSONInterface.jsonFile.exists() && !Configuration.instance().linking.databaseClass.equals(JSONInterface.class.getCanonicalName())) {
            LOGGER.info("PlayerLinks.json found, but using custom database implementation");
            LOGGER.info("If you want to use the old data, please enter \"discord migrate\" into the server console");
        }
    }

    public void stopThreads() {
        timer.cancel();
        timer.purge();
        if (this.launchThread.isAlive()) {
            this.launchThread.interrupt();
        }
    }

    public void kill(boolean instant) {
        LOGGER.info("Unloading addons...");
        AddonLoader.unloadAddons(this);
        LOGGER.info("Unloaded addons");
        if (this.jda != null) {
            LOGGER.info("Unloading instance: " + this.jda);
            if (this.listener != null) {
                LOGGER.info("Unloading listener: " + this.listener);
                this.jda.removeEventListener(this.listener);
            }
            this.stopThreads();
            this.unregisterAllEventHandlers();
            this.webhookClis.forEach((i, w) -> w.close());
            OkHttpClient client = this.jda.getHttpClient();
            try {
                if (instant) {
                    LOGGER.info("Killing JDA...");
                    this.jda.shutdownNow();
                    this.jda.awaitShutdown();
                    LOGGER.info("JDA was killed");
                } else {
                    LOGGER.info("Waiting for JDA to shut-down...");
                    this.jda.shutdown();
                    if (!this.jda.awaitShutdown(Duration.ofSeconds(10L))) {
                        LOGGER.info("Killing JDA due to timeout...");
                        this.jda.shutdownNow();
                        this.jda.awaitShutdown();
                        LOGGER.info("JDA was killed");
                    } else {
                        LOGGER.info("JDA shut-down gracefully");
                    }
                }
                client.dispatcher().cancelAll();
                client.connectionPool().evictAll();
                client.dispatcher().executorService().shutdown();
            }
            catch (LinkageError ignored) {
                ignored.printStackTrace();
            }
            catch (InterruptedException ignored) {
                ignored.printStackTrace();
            }
            this.jda = null;
            INSTANCE = null;
        }
    }

    public GuildMessageChannel getChannel() {
        return this.getChannel("default");
    }

    private GuildMessageChannel retrieveChannel(String id2) {
        TextChannel chan = this.jda.getTextChannelById(id2);
        if (chan == null) {
            for (Guild g : this.jda.getGuilds()) {
                for (GuildChannel gChannel : g.getChannels(true)) {
                    if (gChannel == null) continue;
                    if (gChannel.getId().equals(id2)) {
                        if (gChannel instanceof StandardGuildMessageChannel) {
                            return (StandardGuildMessageChannel)gChannel;
                        }
                        LOGGER.error("Target Channel ID is not a valid message channel!");
                        continue;
                    }
                    if (!(gChannel instanceof StandardGuildMessageChannel)) continue;
                    for (ThreadChannel c : ((StandardGuildMessageChannel)gChannel).getThreadChannels()) {
                        if (!c.getId().equals(id2)) continue;
                        return c;
                    }
                }
            }
        }
        return chan;
    }

    public GuildMessageChannel getChannel(String id) {
        boolean isDefault;
        if (this.jda == null) {
            return null;
        }
        boolean bl = isDefault = id.equals("default") || id.equals(Configuration.instance().general.botChannel);
        if (isDefault) {
            id = Configuration.instance().general.botChannel;
        }
        if (id.isEmpty()) {
            LOGGER.error("Cannot get channel from empty ID! Check your config!");
            if (isDefault) {
                return null;
            }
            LOGGER.info("Falling back to default channel!");
            return this.getChannel();
        }
        GuildMessageChannel channel = this.channelCache.computeIfAbsent(id, this::retrieveChannel);
        if (channel == null) {
            LOGGER.error("Failed to get Channel with ID '" + id + "', falling back to default channel");
            channel = this.channelCache.computeIfAbsent(Configuration.instance().general.botChannel, this::retrieveChannel);
        }
        return channel;
    }

    public Member getMemberById(String userid) {
        return this.getMemberById(Long.parseLong(userid));
    }

    public Member getMemberById(Long userid) {
        if (memberCache.containsKey(userid)) {
            return memberCache.get(userid);
        }
        Member out = (Member)this.getChannel().getGuild().retrieveMember(UserSnowflake.fromId(userid)).complete();
        memberCache.put(userid, out);
        return out;
    }

    public JDA getJDA() {
        return this.jda;
    }

    public McServerInterface getServerInterface() {
        return this.serverInterface;
    }

    public DBInterface getDatabaseInterface() {
        return this.linkDbInterface;
    }

    public UUID getSenderUUIDFromMessageID(String messageID) {
        return this.recentMessages.getOrDefault(messageID, dummyUUID);
    }

    public boolean hasAdminRole(List<Role> roles) {
        for (Role role : roles) {
            if (!ArrayUtils.contains(Configuration.instance().commands.adminRoleIDs, role.getId())) continue;
            return true;
        }
        return false;
    }

    public void loadIgnoreList() throws IOException {
        if (IGNORED_PLAYERS.exists()) {
            BufferedReader r = new BufferedReader(new FileReader(IGNORED_PLAYERS));
            r.lines().iterator().forEachRemaining(s -> {
                try {
                    this.ignoringPlayers.add(UUID.fromString(s));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Found invalid entry for ignoring player, skipping");
                }
            });
            r.close();
        }
    }

    public boolean togglePlayerIgnore(UUID uuid) {
        if (LinkManager.isPlayerLinked(uuid)) {
            PlayerLink link = LinkManager.getLink(null, uuid);
            link.settings.ignoreDiscordChatIngame = !link.settings.ignoreDiscordChatIngame;
            LinkManager.addLink(link);
            return !link.settings.ignoreDiscordChatIngame;
        }
        if (this.ignoringPlayers.contains(uuid)) {
            this.ignoringPlayers.remove(uuid);
            try {
                this.saveIgnoreList();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        this.ignoringPlayers.add(uuid);
        return false;
    }

    private void saveIgnoreList() throws IOException {
        if (!IGNORED_PLAYERS.exists() && !this.ignoringPlayers.isEmpty()) {
            IGNORED_PLAYERS.createNewFile();
        }
        if (!IGNORED_PLAYERS.exists() && this.ignoringPlayers.isEmpty()) {
            IGNORED_PLAYERS.delete();
            return;
        }
        FileWriter w = new FileWriter(IGNORED_PLAYERS);
        w.write("");
        for (UUID a : this.ignoringPlayers) {
            if (LinkManager.isPlayerLinked(a)) continue;
            w.append(a.toString()).append("\n");
        }
        w.close();
    }

    public Webhook getWebhook(GuildMessageChannel ic) {
        if (!Configuration.instance().webhook.enable || ic == null) {
            return null;
        }
        if (ic instanceof ThreadChannel) {
            ThreadChannel c = (ThreadChannel)ic;
            return this.webhookHashMap.computeIfAbsent(c.getId(), cid -> {
                if (!PermissionUtil.checkPermission(c.getParentChannel(), this.getMemberById(this.jda.getSelfUser().getIdLong()), Permission.MANAGE_WEBHOOKS)) {
                    LOGGER.info("ERROR! Bot does not have permission to manage webhooks, disabling webhook");
                    Configuration.instance().webhook.enable = false;
                    try {
                        Configuration.instance().saveConfig();
                    }
                    catch (IOException e) {
                        LOGGER.error("FAILED TO SAVE CONFIGURATION");
                        e.printStackTrace();
                    }
                    return null;
                }
                for (Webhook web : c.getParentMessageChannel().asStandardGuildMessageChannel().retrieveWebhooks().complete()) {
                    if (!web.getName().equals(Configuration.instance().webhook.webhookName)) continue;
                    return web;
                }
                return (Webhook)c.getParentMessageChannel().asStandardGuildMessageChannel().createWebhook(Configuration.instance().webhook.webhookName).complete();
            });
        }
        if (ic instanceof StandardGuildMessageChannel) {
            StandardGuildMessageChannel c = (StandardGuildMessageChannel)ic;
            return this.webhookHashMap.computeIfAbsent(c.getId(), cid -> {
                if (!PermissionUtil.checkPermission(c, this.getMemberById(this.jda.getSelfUser().getIdLong()), Permission.MANAGE_WEBHOOKS)) {
                    LOGGER.info("ERROR! Bot does not have permission to manage webhooks, disabling webhook");
                    Configuration.instance().webhook.enable = false;
                    try {
                        Configuration.instance().saveConfig();
                    }
                    catch (IOException e) {
                        LOGGER.error("FAILED TO SAVE CONFIGURATION");
                        e.printStackTrace();
                    }
                    return null;
                }
                for (Webhook web : c.retrieveWebhooks().complete()) {
                    if (!web.getName().equals(Configuration.instance().webhook.webhookName)) continue;
                    return web;
                }
                return (Webhook)c.createWebhook(Configuration.instance().webhook.webhookName).complete();
            });
        }
        return null;
    }

    public JDAWebhookClient getWebhookCli(String channelID) {
        return this.webhookClis.computeIfAbsent(channelID, id -> {
            GuildMessageChannel channel = this.getChannel((String)id);
            Webhook wh = this.getWebhook(channel);
            if (wh == null) {
                return null;
            }
            JDAWebhookClient cli = JDAWebhookClient.from(wh);
            if (channel instanceof ThreadChannel) {
                ThreadChannel c = (ThreadChannel)channel;
                cli = cli.onThread(c.getIdLong());
            }
            return cli;
        });
    }

    public void sendMessageFuture(String msg, String channelID) {
        if (msg.isEmpty() || channelID.isEmpty()) {
            return;
        }
        ArrayList<Object> msgs = MessageQueueTask.messages.containsKey(channelID) ? MessageQueueTask.messages.get(channelID) : new ArrayList();
        msgs.add(msg);
        MessageQueueTask.messages.put(channelID, msgs);
    }

    public void sendMessage(String playerName, String uuid, MessageEmbed embed, MessageChannel channel) {
        this.sendMessage(playerName, uuid, new DiscordMessage(embed), channel);
    }

    public void sendMessage(String msg) {
        this.sendMessage(Configuration.instance().webhook.serverName, "0000000", msg, (MessageChannel)this.getChannel(Configuration.instance().advanced.serverChannelID));
    }

    public void sendMessage(DiscordMessage msg) {
        this.sendMessage(Configuration.instance().webhook.serverName, "0000000", msg, (MessageChannel)this.getChannel(Configuration.instance().advanced.serverChannelID));
    }

    public void sendMessage(String playerName, String uuid, String msg, MessageChannel channel) {
        this.sendMessage(playerName, uuid, new DiscordMessage(msg), channel);
    }

    public void sendMessage(MessageChannel channel, String message, String avatarURL, String name) {
        this.sendMessage(name, new DiscordMessage(message), avatarURL, channel, false);
    }

    public void sendMessage(String msg, String avatarURL, String name) {
        this.sendMessage(name, new DiscordMessage(msg), avatarURL, this.getChannel(Configuration.instance().advanced.serverChannelID), true);
    }

    public void sendMessage(String name, String msg, MessageChannel channel, String avatarURL) {
        this.sendMessage(name, new DiscordMessage(msg), avatarURL, channel, true);
    }

    public void sendMessage(String name, DiscordMessage message, String avatarURL, MessageChannel channel, boolean isChatMessage) {
        this.sendMessage(name, message, avatarURL, channel, isChatMessage, dummyUUID.toString());
    }

    public void sendMessage(String name, DiscordMessage message, String avatarURL, MessageChannel channel, boolean isChatMessage, String uuid) {
        if (this.jda == null || channel == null) {
            return;
        }
        WorkThread.executeJob(() -> {
            try {
                if (Configuration.instance().webhook.enable) {
                    if (isChatMessage) {
                        message.setIsChatMessage();
                    }
                    ArrayList<WebhookMessageBuilder> messages = message.buildWebhookMessages();
                    messages.forEach(builder -> {
                        builder.setUsername(name);
                        builder.setAvatarUrl(avatarURL);
                        JDAWebhookClient webhookCli = this.getWebhookCli(channel.getId());
                        if (webhookCli != null) {
                            webhookCli.send(builder.build()).thenAccept(a -> this.rememberRecentMessage(String.valueOf(a.getId()), UUID.fromString(uuid)));
                        }
                    });
                } else if (isChatMessage) {
                    message.setMessage(Localization.instance().discordChatMessage.replace("%player%", name).replace("%msg%", message.getMessage()));
                    message.setIsChatMessage();
                    channel.sendMessage(message.buildMessages()).submit().thenAccept(a -> this.rememberRecentMessage(a.getId(), UUID.fromString(uuid)));
                } else {
                    channel.sendMessage(message.buildMessages()).submit().thenAccept(a -> this.rememberRecentMessage(a.getId(), UUID.fromString(uuid)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<Message> sendMessageReturns(MessageCreateData msg, GuildMessageChannel c) {
        if (Configuration.instance().webhook.enable || c == null) {
            return null;
        }
        return c.sendMessage(msg).submit();
    }

    public boolean canPlayerJoin(UUID uuid) {
        if (!Configuration.instance().linking.whitelistMode) {
            return true;
        }
        if (LinkManager.isPlayerLinked(uuid)) {
            if (Configuration.instance().linking.requiredRoles.length != 0) {
                Member mem = this.getMemberById(LinkManager.getLink(null, (UUID)uuid).discordID);
                if (mem == null) {
                    return false;
                }
                Guild g = this.getChannel().getGuild();
                for (String requiredRole : Configuration.instance().linking.requiredRoles) {
                    Role role = g.getRoleById(requiredRole);
                    if (role == null || !mem.getRoles().contains(role)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void sendMessage(String msg, MessageChannel textChannel) {
        this.sendMessage(new DiscordMessage(msg), textChannel);
    }

    public void sendMessage(DiscordMessage msg, MessageChannel channel) {
        this.sendMessage(Configuration.instance().webhook.serverName, "0000000", msg, channel);
    }

    public void sendMessage(String playerName, String uuid, DiscordMessage msg, MessageChannel channel) {
        WorkThread.executeJob(() -> {
            String pName = playerName;
            if (channel == null) {
                return;
            }
            boolean isServerMessage = pName.equals(Configuration.instance().webhook.serverName) && uuid.equals("0000000");
            UUID uUUID = uuid.equals("0000000") ? null : UUID.fromString(uuid);
            String avatarURL = "";
            if (!isServerMessage && uUUID != null) {
                if (LinkManager.isPlayerLinked(uUUID)) {
                    PlayerLink l = LinkManager.getLink(null, uUUID);
                    Member dc = this.getMemberById(Long.parseLong(l.discordID));
                    if (dc != null && l.settings.useDiscordNameInChannel) {
                        pName = dc.getEffectiveName();
                        avatarURL = dc.getUser().getAvatarUrl();
                    }
                }
                if (avatarURL != null && avatarURL.isEmpty()) {
                    avatarURL = Configuration.instance().webhook.playerAvatarURL.replace("%uuid%", uUUID.toString()).replace("%uuid_dashless%", uUUID.toString().replace("-", "")).replace("%name%", pName).replace("%randomUUID%", UUID.randomUUID().toString());
                }
            }
            if (isServerMessage) {
                avatarURL = Configuration.instance().webhook.serverAvatarURL;
            }
            this.sendMessage(pName, msg, avatarURL, channel, !isServerMessage, uuid);
        });
    }

    public void rememberRecentMessage(String msgID, UUID uuid) {
        if (this.recentMessages.size() + 1 >= 150) {
            do {
                this.recentMessages.remove(this.recentMessages.keySet().toArray(new String[0])[0]);
            } while (this.recentMessages.size() + 1 >= 150);
        }
        this.recentMessages.put(msgID, uuid);
    }

    static {
        VERSION = DiscordIntegration.class.getPackage().getImplementationVersion();
        discordDataDir = new File("./DiscordIntegration-Data/");
        IGNORED_PLAYERS = new File(discordDataDir, ".PlayerIgnores");
        gson = new GsonBuilder().setPrettyPrinting().create();
        LOGGER = LogManager.getLogger((String)"Discord Integration");
        ArrayList<Rule<Object, Node<Object>, Object>> rules = new ArrayList<Rule<Object, Node<Object>, Object>>(DiscordMarkdownRules.createAllRulesForDiscord(false));
        rules.add(new Rule<Object, Node<Object>, Object>(Pattern.compile("(.*)")){

            @Override
            public ParseSpec<Object, Node<Object>, Object> parse(Matcher matcher, Parser<Object, Node<Object>, Object> parser, Object state) {
                return ParseSpec.createTerminal(new TextNode(matcher.group()), state);
            }
        });
        mcSerializerOptions = MinecraftSerializerOptions.defaults().withRules(rules);
        configFile = new File("./config/Discord-Integration.toml");
        messagesFile = new File("./DiscordIntegration-Data/Messages.toml");
        dummyUUID = new UUID(0L, 0L);
        started = -1L;
        memberCache = new HashMap<Long, Member>();
        timer = new Timer();
    }

    public class LaunchThread
    extends Thread {
        private final JDABuilder b;

        public LaunchThread() {
            this.setDaemon(true);
            this.setName("DiscordIntegration Launch Thread");
            this.b = JDABuilder.createDefault(Configuration.instance().general.botToken);
            if (!Configuration.instance().advanced.baseAPIUrl.equals("https://discord.com")) {
                try {
                    this.b.setRestConfig(new RestConfig().setBaseUrl(Configuration.instance().advanced.baseAPIUrl));
                    LOGGER.info("Now using " + Configuration.instance().advanced.baseAPIUrl + " as target Discord!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) lbl-1000:
            // 2 sources

            {
                this.b.enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[]{GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_EMOJIS_AND_STICKERS, GatewayIntent.MESSAGE_CONTENT});
                this.b.setAutoReconnect(true);
                this.b.setEnableShutdownHook(true);
                try {
                    DiscordIntegration.this.jda = this.b.build();
                    DiscordIntegration.this.jda.awaitReady();
                    break;
                }
                catch (InvalidTokenException e) {
                    DiscordIntegration.this.jda = null;
                    if (e.getMessage().equals("The provided token is invalid!")) {
                        DiscordIntegration.LOGGER.error("Invalid token, please set correct token in the config file!");
                        return;
                    }
                    DiscordIntegration.LOGGER.error("Login failed, retrying");
                    try {
                        LaunchThread.sleep(6000L);
                        continue;
                    }
                    catch (InterruptedException ignored) {
                        return;
                    }
                }
                ** while (true)
                catch (IllegalStateException | InterruptedException e) {
                    DiscordIntegration.this.jda = null;
                    return;
                }
                break;
            }
            if (DiscordIntegration.this.getChannel() == null) {
                DiscordIntegration.LOGGER.error("ERROR! Channel ID of the default bot channel not valid!");
                DiscordIntegration.this.kill(true);
                return;
            }
            if (!PermissionUtil.checkPermission(DiscordIntegration.this.getChannel().getPermissionContainer(), DiscordIntegration.this.getMemberById(DiscordIntegration.this.jda.getSelfUser().getIdLong()), new Permission[]{Permission.VIEW_CHANNEL, Permission.MESSAGE_SEND, Permission.MESSAGE_EMBED_LINKS, Permission.MESSAGE_MANAGE})) {
                DiscordIntegration.LOGGER.error("ERROR! Bot does not have all permissions to work!");
                DiscordIntegration.this.kill(true);
                throw new PermissionException("Bot requires message read, message write, embed links and manage messages");
            }
            if (Configuration.instance().webhook.enable && !PermissionUtil.checkPermission(DiscordIntegration.this.getChannel().getPermissionContainer(), DiscordIntegration.this.getMemberById(DiscordIntegration.this.jda.getSelfUser().getIdLong()), new Permission[]{Permission.MANAGE_WEBHOOKS})) {
                DiscordIntegration.LOGGER.error("ERROR! Bot does not have permission to manage webhooks, disabling webhook");
                Configuration.instance().webhook.enable = false;
                try {
                    Configuration.instance().saveConfig();
                }
                catch (IOException e) {
                    DiscordIntegration.LOGGER.error("FAILED TO SAVE CONFIG");
                    e.printStackTrace();
                }
            }
            DiscordIntegration.LOGGER.info("Bot ready");
            v0 = new Object[1];
            DiscordIntegration.this.listener = new DiscordEventListener();
            v0[0] = DiscordIntegration.this.listener;
            DiscordIntegration.this.jda.addEventListener(v0);
            try {
                DiscordIntegration.this.loadIgnoreList();
            }
            catch (IOException e) {
                DiscordIntegration.LOGGER.error("Error while loading the ignoring players list!");
                e.printStackTrace();
            }
            McCommandRegistry.registerDefaultCommands();
            DiscordIntegration.LOGGER.info("Loading DiscordIntegration Addons...");
            AddonLoader.loadAddons(DiscordIntegration.this);
            DiscordIntegration.LOGGER.info("Addon loading complete!");
            if (Configuration.instance().linking.enableLinking) {
                DiscordIntegration.LOGGER.info("Loading Linking Database...");
                sqLite = Configuration.instance().linking.databaseClass.equals("de.erdbeerbaerlp.dcintegration.common.storage.linking.database.SQLiteInterface");
                try {
                    DiscordIntegration.this.linkDbInterface = (DBInterface)Class.forName(Configuration.instance().linking.databaseClass, true, AddonLoader.getAddonClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DiscordIntegration.this.linkDbInterface.connect();
                    DiscordIntegration.this.linkDbInterface.initialize();
                    DiscordIntegration.LOGGER.info("Linking Database initialized!");
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    if (sqLite) {
                        Configuration.instance().linking.databaseClass = "de.erdbeerbaerlp.dcintegration.common.storage.linking.database.JSONInterface";
                        try {
                            Configuration.instance().saveConfig();
                        }
                        catch (IOException ex) {
                            DiscordIntegration.LOGGER.error("Failed to save configuration change");
                            ex.printStackTrace();
                        }
                        DiscordIntegration.this.linkDbInterface = new JSONInterface();
                        DiscordIntegration.this.linkDbInterface.connect();
                        DiscordIntegration.this.linkDbInterface.initialize();
                        DiscordIntegration.LOGGER.info("Linking Database initialized!");
                    }
                    e.printStackTrace();
                }
                LinkManager.load();
                if (Configuration.instance().linking.unlinkOnLeave) {
                    WorkThread.executeJob((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(), ()V)((LaunchThread)this));
                }
            }
        }

        private /* synthetic */ void lambda$run$0() {
            for (PlayerLink p : LinkManager.getAllLinks()) {
                try {
                    DiscordIntegration.this.getChannel().getGuild().retrieveMemberById(p.discordID).submit();
                }
                catch (ErrorResponseException e) {
                    LinkManager.unlinkPlayer(p.discordID);
                }
            }
        }
    }
}

