/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.com.moandjiezana.toml;

import dcshadow.com.moandjiezana.toml.BooleanValueReaderWriter;
import dcshadow.com.moandjiezana.toml.DateValueReaderWriter;
import dcshadow.com.moandjiezana.toml.MapValueWriter;
import dcshadow.com.moandjiezana.toml.NumberValueReaderWriter;
import dcshadow.com.moandjiezana.toml.ObjectValueWriter;
import dcshadow.com.moandjiezana.toml.PrimitiveArrayValueWriter;
import dcshadow.com.moandjiezana.toml.StringValueReaderWriter;
import dcshadow.com.moandjiezana.toml.TableArrayValueWriter;
import dcshadow.com.moandjiezana.toml.ValueWriter;

class ValueWriters {
    static final ValueWriters WRITERS = new ValueWriters();
    private static final ValueWriter[] VALUE_WRITERS = new ValueWriter[]{StringValueReaderWriter.STRING_VALUE_READER_WRITER, NumberValueReaderWriter.NUMBER_VALUE_READER_WRITER, BooleanValueReaderWriter.BOOLEAN_VALUE_READER_WRITER, ValueWriters.getPlatformSpecificDateConverter(), MapValueWriter.MAP_VALUE_WRITER, PrimitiveArrayValueWriter.PRIMITIVE_ARRAY_VALUE_WRITER, TableArrayValueWriter.TABLE_ARRAY_VALUE_WRITER};

    ValueWriter findWriterFor(Object value) {
        for (ValueWriter valueWriter : VALUE_WRITERS) {
            if (!valueWriter.canWrite(value)) continue;
            return valueWriter;
        }
        return ObjectValueWriter.OBJECT_VALUE_WRITER;
    }

    private ValueWriters() {
    }

    private static DateValueReaderWriter getPlatformSpecificDateConverter() {
        String specificationVersion = Runtime.class.getPackage().getSpecificationVersion();
        return specificationVersion != null && specificationVersion.startsWith("1.6") ? DateValueReaderWriter.DATE_PARSER_JDK_6 : DateValueReaderWriter.DATE_VALUE_READER_WRITER;
    }
}

