/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.EntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.EntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.StopTriggeredEntityAnimPacket;

public interface GeoReplacedEntity
extends SingletonGeoAnimatable {
    public EntityType<?> getReplacingEntityType();

    @Nullable
    default public <D> D getAnimData(Entity entity, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(entity.m_19879_()).getData(dataTicket);
    }

    default public <D> void setAnimData(Entity relatedEntity, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.m_19879_()).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.send(new EntityAnimDataSyncPacket<D>(relatedEntity.m_19879_(), dataTicket, data), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    default public void triggerAnim(Entity relatedEntity, @Nullable String controllerName, String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.m_19879_()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new EntityAnimTriggerPacket(relatedEntity.m_19879_(), controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnimation(Entity relatedEntity, @Nullable String controllerName, @Nullable String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(relatedEntity.m_19879_());
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibNetwork.send(new StopTriggeredEntityAnimPacket(relatedEntity.m_19879_(), controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((Entity)entity).f_19797_;
    }
}

