/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stock;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import ru.zznty.create_factory_abstractions.api.generic.key.GenericKey;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.impl.GenericContentExtender;
import ru.zznty.create_factory_abstractions.generic.key.item.ItemKey;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;

@Mixin(value={InventorySummary.class})
public class InventorySummaryMixin
implements GenericInventorySummary {
    @Unique
    private final Multimap<GenericKey, BigGenericStack> createFactoryLogistics$stacks = HashMultimap.create();
    @Unique
    private List<BigGenericStack> createFactoryLogistics$stacksByCount;
    @Shadow(remap=false)
    private int totalCount;
    @Shadow(remap=false)
    public int contributingLinks;

    @Overwrite(remap=false)
    public void add(ItemStack stack, int count) {
        if (stack.m_41619_() || count == 0) {
            return;
        }
        this.add(GenericStack.wrap((ItemStack)stack).withAmount(count));
    }

    @Overwrite(remap=false)
    public int getCountOf(ItemStack stack) {
        return this.getCountOf(GenericStack.wrap((ItemStack)stack).key());
    }

    @Overwrite(remap=false)
    public List<BigGenericStack> getStacks() {
        ArrayList<BigGenericStack> stacks = new ArrayList<BigGenericStack>();
        for (Collection value : this.createFactoryLogistics$stacks.asMap().values()) {
            Iterator iter = value.iterator();
            BigGenericStack stack = BigGenericStack.of((GenericStack)((BigGenericStack)iter.next()).get());
            while (iter.hasNext()) {
                stack.setAmount(stack.get().amount() + ((BigGenericStack)iter.next()).get().amount());
            }
            stacks.add(stack);
        }
        return stacks;
    }

    public List<GenericStack> get() {
        ArrayList<GenericStack> list = new ArrayList<GenericStack>(this.createFactoryLogistics$stacks.size());
        for (BigGenericStack stack : this.createFactoryLogistics$stacks.values()) {
            list.add(stack.get());
        }
        return list;
    }

    public Map<GenericKey, Collection<BigGenericStack>> getMap() {
        return this.createFactoryLogistics$stacks.asMap();
    }

    @Overwrite(remap=false)
    public boolean erase(ItemStack stack) {
        return this.erase(GenericStack.wrap((ItemStack)stack).key());
    }

    @Overwrite(remap=false)
    public void add(InventorySummary summary) {
        GenericInventorySummary otherSummary = GenericInventorySummary.of((InventorySummary)summary);
        for (GenericStack stack : otherSummary.get()) {
            this.add(stack);
        }
        this.contributingLinks += summary.contributingLinks;
    }

    @Overwrite(remap=false)
    public InventorySummary copy() {
        GenericInventorySummary copy = GenericInventorySummary.empty();
        copy.add((GenericInventorySummary)this);
        return copy.asSummary();
    }

    @Overwrite(remap=false)
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("List", (Tag)NBTHelper.writeCompoundList((Iterable)this.createFactoryLogistics$stacks.values(), stack -> stack.asStack().write()));
        return tag;
    }

    @Overwrite(remap=false)
    public static InventorySummary read(CompoundTag tag) {
        GenericInventorySummary summary = GenericInventorySummary.empty();
        ListTag listTag = tag.m_128437_("List", 10);
        NBTHelper.iterateCompoundList((ListTag)listTag, compoundTag -> summary.add(GenericStackSerializer.read((CompoundTag)compoundTag)));
        return summary.asSummary();
    }

    @Overwrite(remap=false)
    public boolean isEmpty() {
        return this.createFactoryLogistics$stacks.isEmpty();
    }

    @Overwrite(remap=false)
    public List<BigGenericStack> getStacksByCount() {
        if (this.createFactoryLogistics$stacksByCount == null) {
            this.createFactoryLogistics$stacksByCount = this.getStacks();
            this.createFactoryLogistics$stacksByCount.sort(BigGenericStack.COMPARATOR);
        }
        return this.createFactoryLogistics$stacksByCount;
    }

    @Overwrite(remap=false)
    public Map<Item, List<BigGenericStack>> getItemMap() {
        IdentityHashMap<Item, List<BigGenericStack>> map = new IdentityHashMap<Item, List<BigGenericStack>>();
        for (Map.Entry entry : this.createFactoryLogistics$stacks.asMap().entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof ItemKey)) continue;
            ItemKey itemKey = (ItemKey)k;
            map.put(itemKey.stack().m_41720_(), new ArrayList((Collection)entry.getValue()));
        }
        return map;
    }

    @Overwrite(remap=false)
    public void add(BigItemStack stack) {
        this.add(BigGenericStack.of((BigItemStack)stack).get());
    }

    public void add(GenericStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.createFactoryLogistics$invalidate();
        if (this.totalCount < 1000000000) {
            this.totalCount += stack.amount();
        }
        Collection stacks = this.createFactoryLogistics$stacks.get((Object)GenericContentExtender.registrationOf((GenericKey)stack.key()).provider().wrapGeneric((Object)stack.key()));
        for (BigGenericStack bigStack : stacks) {
            if (!bigStack.get().canStack(stack)) continue;
            if (bigStack.get().amount() != 1000000000) {
                bigStack.setAmount(bigStack.get().amount() + stack.amount());
            }
            return;
        }
        stacks.add(BigGenericStack.of((GenericStack)stack));
    }

    public void add(GenericInventorySummary summary) {
        this.add(summary.asSummary());
    }

    public int getCountOf(GenericKey key) {
        int count = 0;
        for (BigGenericStack stack : this.createFactoryLogistics$stacks.get((Object)GenericContentExtender.registrationOf((GenericKey)key).provider().wrapGeneric((Object)key))) {
            if (!stack.get().canStack(key) || count >= 1000000000) continue;
            count += stack.get().amount();
        }
        return count;
    }

    public boolean erase(GenericKey key) {
        Collection stacks = this.createFactoryLogistics$stacks.get((Object)GenericContentExtender.registrationOf((GenericKey)key).provider().wrapGeneric((Object)key));
        if (stacks.isEmpty()) {
            return false;
        }
        Iterator iterator = stacks.iterator();
        while (iterator.hasNext()) {
            BigGenericStack existing = (BigGenericStack)iterator.next();
            if (!existing.get().canStack(key)) continue;
            this.totalCount -= existing.get().amount();
            iterator.remove();
            this.createFactoryLogistics$invalidate();
            return true;
        }
        return false;
    }

    public InventorySummary asSummary() {
        return (InventorySummary)this;
    }

    @Unique
    private void createFactoryLogistics$invalidate() {
        this.createFactoryLogistics$stacksByCount = null;
    }
}

