/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import ru.zznty.create_factory_logistics.FactoryBlockEntities;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBlockEntity;

public class FactoryFluidPanelBlock
extends FactoryPanelBlock {
    public FactoryFluidPanelBlock(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
    }

    public Class getBlockEntityClass() {
        return FactoryFluidPanelBlockEntity.class;
    }

    public BlockEntityType<? extends FactoryPanelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)FactoryBlockEntities.FACTORY_FLUID_PANEL.get();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        ItemStack item = pPlayer.m_21120_(pHand);
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!FactoryBlocks.FACTORY_FLUID_GAUGE.isIn(item)) {
            return InteractionResult.SUCCESS;
        }
        Vec3 location = pHit.m_82450_();
        if (location == null) {
            return InteractionResult.SUCCESS;
        }
        if (!FactoryPanelBlockItem.isTuned((ItemStack)item)) {
            AllSoundEvents.DENY.playOnServer(pLevel, (Vec3i)pPos);
            pPlayer.m_5661_((Component)CreateLang.translate((String)"factory_panel.tune_before_placing", (Object[])new Object[0]).component(), true);
            return InteractionResult.FAIL;
        }
        FactoryPanelBlock.PanelSlot newSlot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pPos, (BlockState)pState, (Vec3)location);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, fpbe -> {
            if (!fpbe.addPanel(newSlot, LogisticallyLinkedBlockItem.networkFromStack((ItemStack)FactoryPanelBlockItem.fixCtrlCopiedStack((ItemStack)item)))) {
                return;
            }
            pPlayer.m_5661_((Component)CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]), true);
            pLevel.m_247517_(null, pPos, this.f_60446_.m_56777_(), SoundSource.BLOCKS);
            if (pPlayer.m_7500_()) {
                return;
            }
            item.m_41774_(1);
            if (item.m_41619_()) {
                pPlayer.m_21008_(pHand, ItemStack.f_41583_);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        if (pUseContext.m_7078_()) {
            return false;
        }
        if (!FactoryBlocks.FACTORY_FLUID_GAUGE.isIn(pUseContext.m_43722_())) {
            return false;
        }
        Vec3 location = pUseContext.m_43720_();
        if (location == null) {
            return false;
        }
        BlockPos pos = pUseContext.m_8083_();
        FactoryPanelBlock.PanelSlot slot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)pState, (Vec3)location);
        FactoryPanelBlockEntity blockEntity = (FactoryPanelBlockEntity)this.getBlockEntity((BlockGetter)pUseContext.m_43725_(), pos);
        if (blockEntity == null) {
            return false;
        }
        return !((FactoryPanelBehaviour)blockEntity.panels.get(slot)).isActive();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        FactoryPanelBlock.PanelSlot slot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)state, (Vec3)context.m_43720_());
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)world, pos, be -> {
            FactoryPanelBehaviour behaviour = (FactoryPanelBehaviour)be.panels.get(slot);
            if (behaviour == null || !behaviour.isActive()) {
                return InteractionResult.SUCCESS;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return InteractionResult.SUCCESS;
            }
            if (!be.removePanel(slot)) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                player.m_150109_().m_150079_(FactoryBlocks.FACTORY_FLUID_GAUGE.asStack());
            }
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
            if (be.activePanels() == 0) {
                world.m_46961_(pos, false);
            }
            return InteractionResult.SUCCESS;
        });
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.tryDestroySubPanelFirst(state, level, pos, player)) {
            return false;
        }
        this.m_5707_(level, pos, state, player);
        return level.m_7731_(pos, fluid.m_76188_(), level.f_46443_ ? 11 : 3);
    }

    private boolean tryDestroySubPanelFirst(BlockState state, Level level, BlockPos pos, Player player) {
        double range = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 1.0;
        HitResult hitResult = player.m_19907_(range, 1.0f, false);
        Vec3 location = hitResult.m_82450_();
        FactoryPanelBlock.PanelSlot destroyedSlot = FactoryFluidPanelBlock.getTargetedSlot((BlockPos)pos, (BlockState)state, (Vec3)location);
        return InteractionResult.SUCCESS == this.onBlockEntityUse((BlockGetter)level, pos, fpbe -> {
            if (fpbe.activePanels() < 2) {
                return InteractionResult.FAIL;
            }
            if (!fpbe.removePanel(destroyedSlot)) {
                return InteractionResult.FAIL;
            }
            if (!player.m_7500_()) {
                FactoryFluidPanelBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)FactoryBlocks.FACTORY_FLUID_GAUGE.asStack());
            }
            return InteractionResult.SUCCESS;
        });
    }
}

