/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.utils.Util;
import me.wesley1808.servercore.common.utils.statistics.GroupBy;
import me.wesley1808.servercore.common.utils.statistics.StatisticType;
import me.wesley1808.servercore.common.utils.statistics.Statistics;
import me.wesley1808.servercore.common.utils.statistics.entry.StatisticEntry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StatisticsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)Commands.m_82127_((String)"statistics").requires(Permission.require("command.statistics", 2));
        statistics.executes(ctx -> StatisticsCommand.displayOverview((CommandSourceStack)ctx.getSource()));
        for (StatisticType type : StatisticType.values()) {
            statistics.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)type.getCommandFormat()).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"byType").executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.TYPE, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.TYPE, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, 1, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"byPlayer").executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.PLAYER, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> StatisticsCommand.display((CommandContext<CommandSourceStack>)ctx, type, GroupBy.PLAYER, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
        }
        dispatcher.register(statistics);
    }

    private static int displayOverview(CommandSourceStack source) {
        Statistics statistics = Statistics.getInstance(source.m_81377_());
        CommandConfig config = Config.get().commands();
        source.m_288197_(() -> {
            MutableComponent component = Component.m_237119_();
            MutableComponent title = Component.m_237113_((String)"Statistics").m_130938_(style -> style.m_178520_(config.tertiaryValue()));
            if (source.m_230897_()) {
                Formatter.addLines(component, 16, config.primaryValue(), (Component)title);
            } else {
                component.m_7220_((Component)title);
            }
            double mspt = DynamicManager.getInstance(source.m_81377_()).getAverageTickTime();
            double tps = mspt != 0.0 ? Math.min(1000.0 / mspt, 20.0) : 20.0;
            component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>TPS: <c:#secondary>%.2f</c> - MSPT: <c:#secondary>%.2f".formatted(tps, mspt)));
            component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total chunk count: <c:#secondary>%d".formatted(statistics.getChunkCount(true))));
            component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total entity count: <c:#secondary>%d".formatted(statistics.getAllEntities().size())));
            component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Total block entity count: <c:#secondary>%d".formatted(statistics.getAllBlockEntities().size())));
            return component;
        }, false);
        return 1;
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, int page) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player != null) {
            return StatisticsCommand.display(context, type, GroupBy.TYPE, page, player);
        }
        return StatisticsCommand.display(context, type, GroupBy.TYPE, page);
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, GroupBy groupBy, int page) {
        return StatisticsCommand.display(context, type, groupBy, page, null);
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, int page, @Nullable ServerPlayer player) {
        return StatisticsCommand.display(context, type, GroupBy.TYPE, page, player);
    }

    private static int display(CommandContext<CommandSourceStack> context, StatisticType type, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case StatisticType.ENTITY -> StatisticsCommand.displayEntities(context, groupBy, page, player);
            case StatisticType.BLOCK_ENTITY -> StatisticsCommand.displayBlockEntities(context, groupBy, page, player);
        };
    }

    private static int displayEntities(CommandContext<CommandSourceStack> context, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, StatisticEntry<Entity>> map = groupBy == GroupBy.PLAYER ? statistics.getEntitiesByPlayer(server.m_6846_().m_11314_()) : statistics.getEntitiesByType(player == null ? statistics.getAllEntities() : statistics.getEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, Util.sortByValue(map), StatisticType.ENTITY, groupBy, page, player);
        return 1;
    }

    private static int displayBlockEntities(CommandContext<CommandSourceStack> context, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        Statistics statistics = Statistics.getInstance(server);
        Map<String, StatisticEntry<TickingBlockEntity>> map = groupBy == GroupBy.PLAYER ? statistics.getBlockEntitiesByPlayer(server.m_6846_().m_11314_()) : statistics.getBlockEntitiesByType(player == null ? statistics.getAllBlockEntities() : statistics.getBlockEntitiesNear(player));
        StatisticsCommand.displayFeedback(context, Util.sortByValue(map), StatisticType.BLOCK_ENTITY, groupBy, page, player);
        return 1;
    }

    private static <T> void displayFeedback(CommandContext<CommandSourceStack> context, List<Map.Entry<String, StatisticEntry<T>>> formattedEntries, StatisticType type, GroupBy groupBy, int page, @Nullable ServerPlayer player) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent component = Component.m_237119_();
        CommandConfig config = Config.get().commands();
        component.m_7220_(StatisticsCommand.createHeader(type, groupBy, source, player, config));
        boolean success = Util.iteratePage(formattedEntries, page, 8, (entry, index) -> component.m_7220_(StatisticsCommand.createEntry(entry, index, type, groupBy, config)));
        if (success) {
            source.m_288197_(() -> component.m_7220_(StatisticsCommand.createFooter(page, Util.getPage(formattedEntries.size(), 8), type, context, config)), false);
        } else if (page == 1) {
            source.m_81352_((Component)Component.m_237113_((String)String.format("No %s were found!", type.getName().toLowerCase())));
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Page doesn't exist!"));
        }
    }

    private static <T> Component createEntry(Map.Entry<String, StatisticEntry<T>> entry, int index, StatisticType type, GroupBy groupBy, CommandConfig config) {
        MutableComponent component = Component.m_237119_();
        component.m_7220_(Formatter.parse("\n<c:#secondary>%d. <c:#primary>%s %s".formatted(index, entry.getKey(), entry.getValue().formatValue())));
        if (groupBy == GroupBy.PLAYER) {
            component.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/statistics %s byType %s".formatted(type.getCommandFormat(), entry.getKey()))));
        }
        return component;
    }

    private static Component createHeader(StatisticType type, GroupBy groupBy, CommandSourceStack source, ServerPlayer player, CommandConfig config) {
        MutableComponent component = Component.m_237119_();
        Component title = player == null ? Formatter.parse("<c:#primary><c:#tertiary>%s</c> by <c:#tertiary>%s".formatted(type.getName(), groupBy.getName())) : Formatter.parse("<c:#primary><c:#tertiary>%s</c> for <c:#tertiary>%s".formatted(type.getName(), player.m_6302_()));
        if (source.m_230897_()) {
            Formatter.addLines(component, 16, config.primaryValue(), title);
        } else {
            component.m_7220_(title);
        }
        return component;
    }

    private static Component createFooter(int page, int pageCount, StatisticType type, CommandContext<CommandSourceStack> context, CommandConfig config) {
        MutableComponent component = Component.m_237113_((String)"\n");
        MutableComponent footer = Component.m_237119_();
        String command = StatisticsCommand.parseCommand(context.getInput());
        MutableComponent prevPage = Component.m_237113_((String)"<<").m_130938_(style -> style.m_178520_(config.secondaryValue()));
        if (page > 1) {
            prevPage.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.replace("%page_nr%", String.valueOf(page - 1)))));
        }
        MutableComponent nextPage = Component.m_237113_((String)">>").m_130938_(style -> style.m_178520_(config.secondaryValue()));
        nextPage.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command.replace("%page_nr%", String.valueOf(page + 1)))));
        footer.m_7220_((Component)prevPage);
        footer.m_7220_(Formatter.parse(" <c:#primary>Page <c:#tertiary>%d</c> of <c:#tertiary>%d ".formatted(page, pageCount)));
        footer.m_7220_((Component)nextPage);
        if (((CommandSourceStack)context.getSource()).m_230897_()) {
            Formatter.addLines(component, type == StatisticType.BLOCK_ENTITY ? 20 : 16, config.primaryValue(), (Component)footer);
        } else {
            component.m_7220_((Component)footer);
        }
        return component;
    }

    private static String parseCommand(String input) {
        Object command = input.replaceAll("\\b\\d+\\b", "%page_nr%");
        if (!((String)command).contains("%page_nr%")) {
            command = (String)command + " %page_nr%";
        }
        return "/" + (String)command;
    }
}

