/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex.transform;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;

public enum CommonVertexElement {
    POSITION,
    COLOR,
    TEXTURE,
    OVERLAY,
    LIGHT,
    NORMAL;

    public static final int COUNT;

    public static CommonVertexElement getCommonType(VertexFormatElement element) {
        if (element == DefaultVertexFormat.f_85804_) {
            return POSITION;
        }
        if (element == DefaultVertexFormat.f_85805_) {
            return COLOR;
        }
        if (element == DefaultVertexFormat.f_85806_) {
            return TEXTURE;
        }
        if (element == DefaultVertexFormat.f_85807_) {
            return OVERLAY;
        }
        if (element == DefaultVertexFormat.f_85808_) {
            return LIGHT;
        }
        if (element == DefaultVertexFormat.f_85809_) {
            return NORMAL;
        }
        return null;
    }

    public static int[] getOffsets(VertexFormat format) {
        int[] results = new int[COUNT];
        Arrays.fill(results, -1);
        ImmutableList elements = format.m_86023_();
        IntList offsets = format.f_86013_;
        for (int i = 0; i < elements.size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            int offset = offsets.getInt(i);
            CommonVertexElement type = CommonVertexElement.getCommonType(element);
            if (type == null) continue;
            results[type.ordinal()] = offset;
        }
        return results;
    }

    static {
        COUNT = CommonVertexElement.values().length;
    }
}

