/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class Owner {
    private static final String NBT_ID = "OwnerId";
    private static final String NBT_NAME = "Name";
    private final UUID id;
    private final String name;

    public Owner(Player player) {
        this(player.m_20148_());
    }

    public Owner(UUID id) {
        this(id, id == null ? "Server" : CRNPlatformSpecific.getLastKnownPlayerName(id).orElse("?"));
    }

    public Owner(UUID id, String name) {
        this.name = name;
        this.id = id;
    }

    public Owner() {
        this((UUID)null);
    }

    public UUID uuid() {
        return this.id == null ? Constants.ZERO_UUID : this.id;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Owner) {
            Owner o = (Owner)obj;
            return this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? Constants.ZERO_UUID.hashCode() : this.id.hashCode();
    }

    public String toString() {
        return String.format("%s[%s]", this.name, this.id == null ? Constants.ZERO_UUID : this.id);
    }

    public void toNbt(CompoundTag nbt) {
        if (this.id != null) {
            nbt.m_128362_(NBT_ID, this.id);
        }
        if (this.name != null) {
            nbt.m_128359_(NBT_NAME, this.name);
        }
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        this.toNbt(nbt);
        return nbt;
    }

    public static Owner fromNbt(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_ID)) {
            if (!DragonLib.hasServer() && nbt.m_128441_(NBT_NAME)) {
                return new Owner(nbt.m_128342_(NBT_ID), nbt.m_128461_(NBT_NAME));
            }
            return new Owner(nbt.m_128342_(NBT_ID));
        }
        return new Owner((UUID)null);
    }
}

