/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface IListenable<T> {
    public Map<String, IdentityHashMap<Object, Consumer<T>>> getListeners();

    default public void createEvent(String name) {
        if (this.getListeners().containsKey(name)) {
            throw new IllegalArgumentException("An event with this ID has already been created: " + name);
        }
        this.getListeners().put(name, new IdentityHashMap());
    }

    default public void deleteEvent(String name) {
        if (this.getListeners().containsKey(name)) {
            this.getListeners().remove(name);
        }
    }

    default public void clearEvents() {
        this.getListeners().clear();
    }

    default public int eventsCount() {
        return this.getListeners().size();
    }

    default public int listenersCount(String name) {
        if (!this.hasEvent(name)) {
            throw new IllegalArgumentException("This listener event does not exist: " + name + ". Valid events are: [" + this.getListeners().keySet().stream().collect(Collectors.joining(", ")) + "]");
        }
        return this.getListeners().get(name).size();
    }

    default public boolean hasEvent(String name) {
        return this.getListeners().containsKey(name);
    }

    default public void listen(String name, Object listenerObject, Consumer<T> listener) {
        if (!this.hasEvent(name)) {
            throw new IllegalArgumentException("This listener event does not exist: " + name + ". Valid events are: [" + this.getListeners().keySet().stream().collect(Collectors.joining(", ")) + "]");
        }
        this.getListeners().get(name).put(listenerObject, listener);
    }

    default public void stopListening(String name, Object listenerObject) {
        if (!this.hasEvent(name)) {
            throw new IllegalArgumentException("This listener event does not exist: " + name + ". Valid events are: [" + this.getListeners().keySet().stream().collect(Collectors.joining(", ")) + "]");
        }
        this.getListeners().get(name).remove(listenerObject);
    }

    default public void stopListeningAll(Object listenerObject) {
        Iterator<IdentityHashMap<Object, Consumer<T>>> iterator = this.getListeners().values().iterator();
        while (iterator.hasNext()) {
            Map x = iterator.next();
            if (!x.containsKey(listenerObject)) continue;
            iterator.remove();
        }
    }

    default public void notifyListeners(String name, T data) {
        if (!this.hasEvent(name)) {
            throw new IllegalArgumentException("This listener event does not exist: " + name + ". Valid events are: [" + this.getListeners().keySet().stream().collect(Collectors.joining(", ")) + "]");
        }
        Iterator<Consumer<T>> iterator = this.getListeners().get(name).values().iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(data);
        }
    }
}

