/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.TooltipHelper;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.RouteDetailsOverlay;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIndicator;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.RouteDetailsViewer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.SavedRoutesManager;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.OverlayManager;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class RouteDetailsScreen
extends AbstractNavigatorScreen {
    private final MutableComponent textDeparture = CustomLanguage.translate("gui.createrailwaysnavigator.route_details.departure");
    private final MutableComponent textArrival = CustomLanguage.translate("gui.createrailwaysnavigator.route_details.arrival");
    private final MutableComponent timeNowText = CustomLanguage.translate("gui.createrailwaysnavigator.time.now");
    private final MutableComponent tooltipSaveRoute = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.save_route.tooltip");
    private final MutableComponent tooltipRemoveRoute = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.remove_route.tooltip");
    private final MutableComponent tooltipShowPopup = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.show_popup.tooltip");
    private final MutableComponent tooltipShowNotifications = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications");
    private final MutableComponent tooltipShowNotificationsDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications.description").m_130940_(ChatFormatting.GRAY);
    private final ClientRoute route;
    private RouteDetailsViewer viewer;
    private DLCreateIconButton notificationButton;
    private DLCreateIndicator notificationIndicator;
    private DLCreateIconButton saveRouteBtn;
    private DLTooltip saveBtnTooltip;
    private DLCreateIconButton popupBtn;
    private final Map<IconButton, Pair<Component, Component>> buttonTooltips = new LinkedHashMap<IconButton, Pair<Component, Component>>();
    private final WidgetsCollection buttons = new WidgetsCollection();

    public RouteDetailsScreen(Screen lastScreen, ClientRoute route) {
        super(lastScreen, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.title"), CreateDynamicWidgets.BarColor.GOLD);
        this.route = route;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.buttons.clear();
        this.buttonTooltips.clear();
        final int fWidth = this.f_96543_;
        final int fHeight = this.f_96544_;
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 38;
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)this, this.guiLeft + 240 - 8, this.guiTop + dy, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, null);
        this.viewer = new RouteDetailsViewer((Screen)this, this.guiLeft + 3, this.guiTop + dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, (DLAbstractScrollBar<?>)scrollBar);
        this.m_142416_((GuiEventListener)this.viewer);
        this.m_142416_((GuiEventListener)scrollBar);
        this.viewer.displayRoute(this.route);
        this.saveRouteBtn = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 30, this.guiTop + 223, 18, 18, (ScreenElement)(SavedRoutesManager.isSaved(this.route) ? ModGuiIcons.BOOKMARK_FILLED.getAsCreateIcon() : ModGuiIcons.BOOKMARK.getAsCreateIcon())){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                RouteDetailsScreen.this.removeTooltips(x -> x == RouteDetailsScreen.this.saveBtnTooltip);
                RouteDetailsScreen.this.addTooltip(DLTooltip.of((FormattedText)(SavedRoutesManager.isSaved(RouteDetailsScreen.this.route) ? RouteDetailsScreen.this.tooltipRemoveRoute : RouteDetailsScreen.this.tooltipSaveRoute)).assignedTo((AbstractWidget)RouteDetailsScreen.this.saveRouteBtn));
                if (SavedRoutesManager.isSaved(RouteDetailsScreen.this.route)) {
                    SavedRoutesManager.removeRoute(RouteDetailsScreen.this.route);
                    this.setIcon((ScreenElement)ModGuiIcons.BOOKMARK.getAsCreateIcon());
                } else {
                    SavedRoutesManager.saveRoute(RouteDetailsScreen.this.route);
                    this.setIcon((ScreenElement)ModGuiIcons.BOOKMARK_FILLED.getAsCreateIcon());
                }
                SavedRoutesManager.push(true, null);
                boolean isSaved = SavedRoutesManager.isSaved(RouteDetailsScreen.this.route);
                RouteDetailsScreen.this.notificationButton.set_visible(isSaved);
                RouteDetailsScreen.this.notificationIndicator.set_visible(isSaved);
                RouteDetailsScreen.this.route.setShowNotifications(isSaved);
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)(SavedRoutesManager.isSaved(this.route) ? this.tooltipRemoveRoute : this.tooltipSaveRoute)).assignedTo((AbstractWidget)this.saveRouteBtn));
        this.popupBtn = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 52, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.POPUP.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                InstanceManager.setRouteOverlay(OverlayManager.add((DLOverlayScreen)new RouteDetailsOverlay(ModCommonEvents.getPhysicalLevel(), RouteDetailsScreen.this.route, fWidth, fHeight)));
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipShowPopup).assignedTo((AbstractWidget)this.popupBtn));
        this.notificationIndicator = (DLCreateIndicator)this.m_142416_((GuiEventListener)new DLCreateIndicator(this.guiLeft + 240 - 18 - 8, this.guiTop + 220, (Component)TextUtils.empty()));
        this.notificationButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 240 - 18 - 8, this.guiTop + 225, 18, 18, (ScreenElement)ModGuiIcons.INFO.getAsCreateIcon()));
        this.notificationButton.withCallback(() -> this.route.setShowNotifications(!this.route.shouldShowNotifications()));
        this.buttonTooltips.put(this.notificationButton, (Pair<Component, Component>)Pair.of((Object)this.tooltipShowNotifications, (Object)this.tooltipShowNotificationsDescription));
        boolean isSaved = SavedRoutesManager.isSaved(this.route);
        this.notificationButton.set_visible(isSaved);
        this.notificationIndicator.set_visible(isSaved);
    }

    public void m_86600_() {
        super.m_86600_();
        this.notificationIndicator.state = this.route.shouldShowNotifications() ? Indicator.State.ON : Indicator.State.OFF;
        this.saveRouteBtn.set_visible(!this.route.getEnd().isDeparted() && !this.route.isClosed());
        this.popupBtn.set_visible(!this.route.getEnd().isDeparted() && !this.route.isClosed());
        this.buttons.performForEachOfType(IconButton.class, x -> {
            if (!this.buttonTooltips.containsKey(x)) {
                return;
            }
            x.setToolTip((Component)this.buttonTooltips.get(x).getFirst());
            x.getToolTip().add(TooltipHelper.holdShift((FontHelper.Palette)FontHelper.Palette.YELLOW, (boolean)RouteDetailsScreen.m_96638_()));
            if (RouteDetailsScreen.m_96638_()) {
                x.getToolTip().add((Component)this.buttonTooltips.get(x).getSecond());
            }
        });
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, 38, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + (y += 37), 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GOLD);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (!this.route.isAnyCancelled()) {
            if (this.route.getStart().isDeparted()) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 120), (int)(this.guiTop + 19), (FormattedText)this.textArrival, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            } else {
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 120), (int)(this.guiTop + 19), (FormattedText)this.textDeparture, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            }
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(2.0f, 2.0f, 2.0f);
            long time = 0L;
            if (this.route.getStart().isDeparted()) {
                time = this.route.getEnd().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime();
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)((this.guiLeft + 120) / 2), (int)((this.guiTop + 31) / 2), (FormattedText)(time < 0L ? this.timeNowText : TextUtils.text((String)TimeUtils.parseDurationShort((long)time))), (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            } else {
                time = this.route.getStart().getRealTimeDepartureTime() - DragonLib.getCurrentWorldTime();
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)((this.guiLeft + 120) / 2), (int)((this.guiTop + 31) / 2), (FormattedText)(time < 0L ? this.timeNowText : TextUtils.text((String)TimeUtils.parseDurationShort((long)time))), (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            }
            graphics.poseStack().m_85849_();
        }
    }
}

