/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayTableSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERPlatformDetailed
implements AbstractAdvancedDisplayRenderer<PlatformDisplayTableSettings> {
    private final MutableComponent textTrainTerminatesHere = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private static final float LINE_HEIGHT = 5.4f;
    private boolean showInfoLine = false;
    private MutableComponent infoLineText = TextUtils.empty();
    private int maxLines = 0;
    private final BERLabel timeLabel = new BERLabel((Component)TextUtils.empty()).setCentered(true).setScale(0.4f, 0.4f).setYScale(0.4f);
    private final BERLabel statusLabel = new BERLabel((Component)TextUtils.empty()).setCentered(true).setScale(0.4f, 0.4f).setYScale(0.4f).setColor(-15658735).setBackground(-1, true).setScrollingSpeed(2.0f);
    private BERLabel[][] lines = new BERLabel[0][];

    @Override
    public void renderTick(float deltaTime) {
        this.timeLabel.renderTick();
        this.statusLabel.renderTick();
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                BERLabel[] line = x[i];
                if (line == null) continue;
                for (int k = 0; k < line.length; ++k) {
                    DLUtils.doIfNotNull((Object)line[k], y -> y.renderTick());
                }
            }
        });
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        this.timeLabel.setText((Component)(blockEntity.getXSize() > 1 ? CustomLanguage.translate(keyTime, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)) : TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false))));
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        for (int i = 0; i < this.lines.length && i < this.maxLines; ++i) {
            for (int k = 0; k < this.lines[i].length; ++k) {
                if (((PlatformDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showTimeAndDate() && i >= this.maxLines - 1 && DragonLib.getCurrentWorldTime() % 200L > 100L) {
                    this.timeLabel.render(graphics, light);
                    continue;
                }
                this.lines[i][k].render(graphics, light);
            }
        }
        if (((PlatformDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showTimeAndDate() && this.lines.length < this.maxLines) {
            this.timeLabel.render(graphics, light);
        }
        if (this.showInfoLine) {
            this.statusLabel.render(graphics, light);
        }
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        ArrayList<StationDisplayData> preds = new ArrayList<StationDisplayData>();
        for (int i = 0; i < blockEntity.getStops().size(); ++i) {
            StationDisplayData data = blockEntity.getStops().get(i);
            if (i != 0 && (data.getStationData().getRealTimeArrivalTime() >= DragonLib.getCurrentWorldTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue() || data.getTrainData().isCancelled() && DragonLib.getCurrentWorldTime() >= data.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())) continue;
            preds.add(data);
        }
        this.showInfoLine = !preds.isEmpty() && (((StationDisplayData)preds.get(0)).getStationData().isDepartureDelayed() && ((StationDisplayData)preds.get(0)).getTrainData().hasStatusInfo() || ((StationDisplayData)preds.get(0)).getStationData().isStationChanged() || ((StationDisplayData)preds.get(0)).isNextSectionExcluded());
        this.infoLineText = this.showInfoLine ? TextUtils.concat((Component)TextUtils.text((String)"  +++  "), (Component[])((Component[])preds.stream().limit(this.maxLines).filter(x -> x.getTrainData().hasStatusInfo() && x.getStationData().isDepartureDelayed() || x.getStationData().isStationChanged() || x.isNextSectionExcluded()).map(x -> {
            ArrayList<Object> content = new ArrayList<Object>();
            if (x.getTrainData().isCancelled()) {
                return CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled");
            }
            if (x.isNextSectionExcluded()) {
                content.add(this.textTrainTerminatesHere);
            }
            if (x.getStationData().isDepartureDelayed()) {
                String delay = ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(x.getStationData().getDepartureTimeDeviation()) : String.valueOf(TimeUtils.formatToMinutes((long)x.getStationData().getDepartureTimeDeviation()));
                MutableComponent delayComponent = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed", delay);
                if (((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS) {
                    delayComponent.m_130946_(" ").m_7220_((Component)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix"));
                }
                content.add(delayComponent);
            }
            if (x.getStationData().isStationChanged()) {
                if (!x.getStationData().getScheduledStation().tagId().equals(x.getStationData().getRealTimeStation().tagId())) {
                    content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_and_station_changed", x.getStationData().getRealTimeStation().tagName(), x.getStationData().getRealTimeStation().info().platform()));
                } else {
                    content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_changed", x.getStationData().getRealTimeStation().info().platform()));
                }
            }
            for (TrainStatus.CompiledTrainStatus status : x.getTrainData().getStatus()) {
                content.add(status.text());
            }
            return CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.information_about_train", x.getTrainData().getName()).m_7220_((Component)TextUtils.text((String)": ")).m_7220_((Component)TextUtils.concat((Component)TextUtils.text((String)" - "), content));
        }).toArray(Component[]::new))) : TextUtils.empty();
        int defaultMaxLines = blockEntity.getYSizeScaled() * 3 - 1;
        this.maxLines = defaultMaxLines - (this.showInfoLine ? 1 : 0);
        int maxIndices = Math.max(0, Math.min(this.maxLines, preds.size()));
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.lines.length != maxIndices) {
            this.updateLayout(blockEntity, preds, maxIndices);
        }
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = (StationDisplayData)preds.get(i);
            this.updateContent(blockEntity, stop, i);
        }
        this.statusLabel.setText((Component)this.infoLineText).setPos(3.0f, (float)(blockEntity.getYSizeScaled() * 16) - 12.0f * this.statusLabel.getYScale() - 2.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL);
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds, int maxIndices) {
        this.lines = new BERLabel[maxIndices][];
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = preds.get(i);
            this.lines[i] = this.createLine(blockEntity, stop, i);
            this.updateContent(blockEntity, stop, i);
        }
        this.statusLabel.setBackground(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, true).setColor(ColorUtils.brightnessDependingFontColor((int)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (int)-1118482, (int)-15658735));
        this.timeLabel.setPos(3.0f, 3.0f + (float)(Math.min(this.lines.length, this.maxLines) - (this.lines.length < this.maxLines ? 0 : 1)) * 5.4f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        PlatformDisplayTableSettings settings = (PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        BERLabel[] components = this.lines[index];
        components[LineComponent.TIME.i()].setText((Component)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        components[LineComponent.REAL_TIME.i()].setText((Component)TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(stop.getRealTime(), ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA) : "")))).setColor(ColorUtils.brightnessDependingFontColor((int)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (int)-1118482, (int)-15658735));
        BERLabel trainNameLabel = components[LineComponent.TRAIN_NAME.i()].setText((Component)TextUtils.text((String)stop.getTrainData().getName()));
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainNameLabel.setBackground(0xFF000000 | stop.getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)stop.getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            trainNameLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        components[LineComponent.PLATFORM.i()].setText((Component)TextUtils.text((String)stop.getStationData().getRealTimeStation().info().platform()));
        components[LineComponent.DESTINATION.i()].setText((Component)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        int x = 3;
        components[LineComponent.TIME.i()].setPos((float)x, 3.0f + (float)index * 5.4f);
        x = (int)((float)x + (components[LineComponent.TIME.i()].getTextWidth() + 2.0f));
        components[LineComponent.REAL_TIME.i()].setPos((float)x, 3.0f + (float)index * 5.4f);
        x = (int)((float)x + (components[LineComponent.REAL_TIME.i()].getTextWidth() + 2.0f + (float)(!components[LineComponent.REAL_TIME.i()].getText().getString().isEmpty() ? 2 : 0)));
        trainNameLabel.setPos((float)x, 3.0f + (float)index * 5.4f);
        float trainNameWidth = Math.min(settings.isAutoTrainNameWidth() ? trainNameLabel.getTextWidth() : (float)settings.getTrainNameWidth(), (float)(blockEntity.getXSizeScaled() * 16 - 3) - trainNameLabel.getX());
        trainNameLabel.setMaxWidth(trainNameWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        x = (int)((float)x + (trainNameLabel.getMaxWidth() + 2.0f));
        BERLabel platformLabel = components[LineComponent.PLATFORM.i()];
        float platformWidth = settings.isAutoPlatformWidth() ? platformLabel.getTextWidth() : (float)settings.getPlatformWidth();
        platformLabel.setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformLabel.getTextWidth(), 3.0f + (float)index * 5.4f).setMaxWidth(platformWidth, BERLabel.BoundsHitReaction.SCALE_SCROLL);
        if (stop.getStationData().isStationChanged()) {
            platformLabel.setBackground(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        } else {
            platformLabel.setBackground(0, false).setColor(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        }
        components[LineComponent.DESTINATION.i()].setPos((float)x, 3.0f + (float)index * 5.4f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 3 - x) - platformWidth - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL);
    }

    private BERLabel[] createLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        BERLabel[] components = new BERLabel[LineComponent.values().length];
        components[LineComponent.TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.REAL_TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setBackground(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF, false).setColor(-15658735);
        components[LineComponent.TRAIN_NAME.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.PLATFORM.i()] = new BERLabel().setYScale(0.4f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        components[LineComponent.DESTINATION.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        return components;
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

