/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Zebra
extends AbstractChestedHorse {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_, Items.f_42501_, Blocks.f_50335_.m_5456_(), Items.f_42410_, Items.f_42677_, Items.f_42436_, Items.f_42437_});

    public Zebra(@NotNull EntityType<? extends AbstractChestedHorse> entityType, @NotNull Level level) {
        super(entityType, level);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new MMPathNavigatorGround((Mob)this, level);
    }

    protected void m_214179_(RandomSource randomSource) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomMaxHealth(randomSource));
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomSpeed(randomSource));
        this.m_21051_(Attributes.f_22288_).m_22100_(this.generateRandomJumpStrength(randomSource));
    }

    protected float generateRandomMaxHealth(@NotNull RandomSource randomSource) {
        return 15.0f + (float)randomSource.m_188503_(8) + (float)randomSource.m_188503_(9);
    }

    protected double generateRandomJumpStrength(RandomSource randomSource) {
        return (double)0.4f + randomSource.m_188500_() * 0.1;
    }

    protected double generateRandomSpeed(@NotNull RandomSource randomSource) {
        return (0.5 + randomSource.m_188500_() * 0.3 + randomSource.m_188500_() * 0.3 + randomSource.m_188500_() * 0.3) * 0.25;
    }

    protected float m_6108_() {
        return 0.96f;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof Zebra) {
            Zebra zebra = (Zebra)otherAnimal;
            return this.m_30628_() && zebra.m_30628_();
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        AbstractHorse zebra = (AbstractHorse)NaturalistEntityTypes.ZEBRA.get().m_20615_((Level)serverLevel);
        this.m_149508_(ageableMob, zebra);
        return zebra;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, AbstractHorse.class));
        this.f_21345_.m_25352_(3, (Goal)new ZebraTemptGoal(this, 1.25, FOOD_ITEMS, true));
        this.f_21345_.m_25352_(4, (Goal)new ZebraAvoidPlayersGoal(this, 16.0f, 1.6, 1.6));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_5877_(SoundType soundType) {
        super.m_5877_(soundType);
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_(NaturalistSoundEvents.ZEBRA_BREATHE.get(), soundType.m_56773_() * 0.6f, soundType.m_56774_());
        }
    }

    public double m_6048_() {
        return super.m_6048_() + 0.0;
    }

    protected void m_7486_() {
        this.m_5496_(NaturalistSoundEvents.ZEBRA_JUMP.get(), 0.4f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return NaturalistSoundEvents.ZEBRA_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.ZEBRA_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return NaturalistSoundEvents.ZEBRA_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        super.m_7975_(damageSource);
        return NaturalistSoundEvents.ZEBRA_HURT.get();
    }

    protected SoundEvent m_7871_() {
        super.m_7871_();
        return NaturalistSoundEvents.ZEBRA_ANGRY.get();
    }

    protected void m_7609_() {
        this.m_5496_(SoundEvents.f_12078_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    static class ZebraTemptGoal
    extends TemptGoal {
        private final Zebra zebra;

        public ZebraTemptGoal(Zebra zebra, double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)zebra, speedModifier, items, canScare);
            this.zebra = zebra;
        }

        protected boolean m_7497_() {
            return super.m_7497_() && !this.zebra.m_30614_();
        }
    }

    static class ZebraAvoidPlayersGoal
    extends AvoidEntityGoal<Player> {
        private final Zebra zebra;

        public ZebraAvoidPlayersGoal(Zebra zebra, float maxDistance, double walkSpeed, double sprintSpeed) {
            super((PathfinderMob)zebra, Player.class, maxDistance, walkSpeed, sprintSpeed, EntitySelector.f_20406_::test);
            this.zebra = zebra;
        }

        public boolean m_8036_() {
            return !this.zebra.m_30614_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.zebra.m_30614_() && super.m_8045_();
        }
    }
}

