/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.util.SmoothChasingValue;

public class ProgressTracker {
    private final ListMultimap<ResourceLocation, TrackInfo> map = ArrayListMultimap.create();

    public TrackInfo createInfo(ResourceLocation tag, float progress, boolean canDecrease, float expectedWidth) {
        List infos = this.map.get((Object)tag);
        TrackInfo info = null;
        for (TrackInfo o : infos) {
            if (o.updatedThisTick) continue;
            info = o;
            break;
        }
        if (info == null) {
            info = new TrackInfo();
            info.width = expectedWidth;
            info.progress.start(progress);
            this.map.put((Object)tag, (Object)info);
        }
        info.updatedThisTick = true;
        if (progress == info.progress.getTarget()) {
            ++info.ticksSinceValueChanged;
        } else {
            if (info.ticksSinceValueChanged > 10) {
                info.progress.withSpeed(0.4f);
            } else if (canDecrease || progress >= info.progress.getTarget()) {
                float spd = Math.abs(progress - info.progress.getTarget()) / (float)info.ticksSinceValueChanged;
                spd = Math.max(0.1f, 4.0f * spd);
                info.progress.withSpeed(spd);
            }
            info.ticksSinceValueChanged = 1;
        }
        if (!canDecrease && progress < info.progress.getTarget()) {
            if (info.progress.isMoving()) {
                info.progress.withSpeed(Math.max(0.5f, info.progress.getSpeed()));
                if (info.progress.getTarget() > 0.9f) {
                    info.progress.target(1.0f);
                }
            } else {
                info.progress.start(progress);
            }
        } else {
            info.progress.target(progress);
        }
        if (info.width != expectedWidth && (expectedWidth > info.width || ++info.ticksSinceWidthChanged > 10)) {
            info.width = expectedWidth;
            info.ticksSinceWidthChanged = 0;
        }
        return info;
    }

    public void tick() {
        this.map.values().removeIf(info -> {
            if (info.updatedThisTick) {
                info.updatedThisTick = false;
                return false;
            }
            return true;
        });
    }

    public void clear() {
        this.map.clear();
    }

    public static class TrackInfo {
        private float width;
        private int ticksSinceWidthChanged;
        private int ticksSinceValueChanged;
        private boolean updatedThisTick;
        private SmoothChasingValue progress = new SmoothChasingValue();

        public float getWidth() {
            return this.width;
        }

        public float tick(float pTicks) {
            this.progress.tick(pTicks);
            return this.progress.value;
        }
    }
}

