/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.worldgen.feature.config.StructureTemplateConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StructureTemplateFeature
extends Feature<StructureTemplateConfig> {
    public static final StructureTemplateFeature FEATURE = new StructureTemplateFeature();

    public StructureTemplateFeature() {
        super(StructureTemplateConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<StructureTemplateConfig> context) {
        StructureTemplateConfig config = (StructureTemplateConfig)context.m_159778_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        StructureTemplateManager templateManager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate template = templateManager.m_230359_(config.template());
        Rotation rotation = config.rotation().orElse(Rotation.m_221990_((RandomSource)random));
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_230324_(random);
        for (StructureProcessor processor : ((StructureProcessorList)config.processors().m_203334_()).m_74425_()) {
            settings.m_74383_(processor);
        }
        BlockPos jigsawPos = origin;
        if (config.startJigsawName().isPresent()) {
            ResourceLocation startName = config.startJigsawName().get();
            ObjectArrayList jigsawBlocks = template.m_230335_(origin, new StructurePlaceSettings().m_74379_(rotation.m_55952_(Rotation.CLOCKWISE_180)), Blocks.f_50678_, true);
            for (StructureTemplate.StructureBlockInfo jigsaw : jigsawBlocks) {
                ResourceLocation jigsawName = ResourceLocation.m_135820_((String)Objects.requireNonNull(jigsaw.f_74677_(), () -> jigsaw + " nbt was null").m_128461_("name"));
                if (jigsawName == null || !jigsawName.equals((Object)startName)) continue;
                jigsawPos = jigsaw.f_74675_();
                break;
            }
        }
        BlockPos offset = jigsawPos.m_121996_((Vec3i)origin).m_142393_(-1);
        BlockPos placePos = origin.m_121996_((Vec3i)offset).m_7918_(0, offset.m_123342_() * 2, 0);
        template.m_230328_((ServerLevelAccessor)level, placePos, placePos, settings, random, 3);
        return true;
    }
}

