/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackOpenMessage {
    private static final int CHEST_SLOT = 38;
    private static final int OFFHAND_SLOT = 40;
    private final int slotIndex;
    private final String identifier;
    private final String handlerName;

    public BackpackOpenMessage() {
        this(-1);
    }

    public BackpackOpenMessage(int backpackSlot) {
        this(backpackSlot, "");
    }

    public BackpackOpenMessage(int backpackSlot, String identifier, String handlerName) {
        this.slotIndex = backpackSlot;
        this.identifier = identifier;
        this.handlerName = handlerName;
    }

    public BackpackOpenMessage(int backpackSlot, String identifier) {
        this(backpackSlot, identifier, "");
    }

    public static void encode(BackpackOpenMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
        packetBuffer.m_130070_(msg.identifier);
        packetBuffer.m_130070_(msg.handlerName);
    }

    public static BackpackOpenMessage decode(FriendlyByteBuf packetBuffer) {
        return new BackpackOpenMessage(packetBuffer.readInt(), packetBuffer.m_130277_(), packetBuffer.m_130277_());
    }

    static void onMessage(BackpackOpenMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackOpenMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, BackpackOpenMessage msg) {
        if (player == null) {
            return;
        }
        if (!msg.handlerName.isEmpty()) {
            BackpackContainer backpackContainer;
            AbstractContainerMenu abstractContainerMenu;
            int slotIndex = msg.slotIndex;
            if (msg.slotIndex == 38) {
                slotIndex -= 36;
            } else if (msg.slotIndex == 40) {
                slotIndex = 0;
            }
            BackpackContext.Item backpackContext = new BackpackContext.Item(msg.handlerName, msg.identifier, slotIndex, player.f_36096_ instanceof InventoryMenu || (abstractContainerMenu = player.f_36096_) instanceof BackpackContainer && (backpackContainer = (BackpackContainer)abstractContainerMenu).getBackpackContext().wasOpenFromInventory());
            BackpackOpenMessage.openBackpack(player, backpackContext);
        } else {
            AbstractContainerMenu slotIndex = player.f_36096_;
            if (slotIndex instanceof BackpackContainer) {
                BackpackContainer backpackContainer = (BackpackContainer)slotIndex;
                backpackContext = backpackContainer.getBackpackContext();
                if (msg.slotIndex == -1) {
                    BackpackOpenMessage.openBackpack(player, ((BackpackContext)backpackContext).getParentBackpackContext());
                } else if (backpackContainer.isStorageInventorySlot(msg.slotIndex)) {
                    BackpackOpenMessage.openBackpack(player, ((BackpackContext)backpackContext).getSubBackpackContext(msg.slotIndex, ((BackpackContext)backpackContext).getBackpackWrapper((Player)player).getInventoryHandler().getSlotStack(msg.slotIndex).getCapability(CapabilityBackpackWrapper.BACKPACK_WRAPPER_CAPABILITY).map(backpackWrapper -> backpackWrapper.getContentsUuid().isEmpty()).orElse(false)));
                }
            } else {
                backpackContext = player.f_36096_;
                if (backpackContext instanceof IContextAwareContainer) {
                    IContextAwareContainer contextAwareContainer = (IContextAwareContainer)backpackContext;
                    backpackContext = contextAwareContainer.getBackpackContext();
                    BackpackOpenMessage.openBackpack(player, (BackpackContext)backpackContext);
                } else {
                    BackpackOpenMessage.findAndOpenFirstBackpack(player);
                }
            }
        }
    }

    private static void findAndOpenFirstBackpack(ServerPlayer player) {
        PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, inventoryName, identifier, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, identifier, slot);
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.m_41786_()), backpackContext::toBuffer);
            return true;
        });
    }

    private static void openBackpack(ServerPlayer player, BackpackContext backpackContext) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpackContext.getDisplayName((Player)player)), backpackContext::toBuffer);
    }
}

