/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModelManager;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.IBackpackModel;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;

public class BackpackBlockEntityRenderer
implements BlockEntityRenderer<BackpackBlockEntity> {
    public void render(BackpackBlockEntity backpackBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IRenderedTankUpgrade.TankRenderInfo tankRenderInfo;
        BlockState state = backpackBlockEntity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)BackpackBlock.FACING);
        boolean showLeftTank = (Boolean)state.m_61143_((Property)BackpackBlock.LEFT_TANK);
        boolean showRightTank = (Boolean)state.m_61143_((Property)BackpackBlock.RIGHT_TANK);
        boolean showBattery = (Boolean)state.m_61143_((Property)BackpackBlock.BATTERY);
        IBackpackWrapper backpackWrapper = backpackBlockEntity.getBackpackWrapper();
        RenderInfo renderInfo = backpackWrapper.getRenderInfo();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(facing.m_122435_()));
        poseStack.m_85836_();
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85837_(0.0, -2.5, 0.0);
        IBackpackModel model = BackpackModelManager.getBackpackModel(backpackWrapper.getBackpack().m_41720_());
        if (showLeftTank && (tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.LEFT)) != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(1.45, 0.0, 0.0);
            tankRenderInfo.getFluid().ifPresent(fluid -> model.renderFluid(poseStack, buffer, combinedLight, (FluidStack)fluid, tankRenderInfo.getFillRatio(), true));
            poseStack.m_85849_();
        }
        if (showRightTank && (tankRenderInfo = (IRenderedTankUpgrade.TankRenderInfo)renderInfo.getTankRenderInfos().get(TankPosition.RIGHT)) != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(-1.45, 0.0, 0.0);
            tankRenderInfo.getFluid().ifPresent(fluid -> model.renderFluid(poseStack, buffer, combinedLight, (FluidStack)fluid, tankRenderInfo.getFillRatio(), false));
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        if (showBattery) {
            renderInfo.getBatteryRenderInfo().ifPresent(batteryRenderInfo -> {
                if (batteryRenderInfo.getChargeRatio() > 0.1f) {
                    poseStack.m_85836_();
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
                    poseStack.m_85837_(0.0, -1.5, 0.0);
                    model.renderBatteryCharge(poseStack, buffer, combinedLight, batteryRenderInfo.getChargeRatio());
                    poseStack.m_85849_();
                }
            });
        }
        this.renderItemDisplay(poseStack, buffer, combinedLight, combinedOverlay, renderInfo, backpackBlockEntity.m_58904_());
        poseStack.m_85849_();
    }

    private void renderItemDisplay(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, RenderInfo renderInfo, @Nullable Level level) {
        renderInfo.getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.6, 0.25);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f + (float)displayItem.getRotation()));
            Minecraft.m_91087_().m_91291_().m_269128_(displayItem.getItem(), ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, level, 0);
            poseStack.m_85849_();
        });
    }
}

