/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.playerwatching.optimize_nearby_player_lookups;

import com.ishland.vmp.common.chunkwatching.AreaPlayerChunkWatchingManager;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LocalMobCapCalculator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalMobCapCalculator.class}, priority=950)
public abstract class MixinSpawnDensityCapper {
    @Shadow
    @Final
    private ChunkMap f_186499_;
    @Mutable
    @Shadow
    @Final
    private Map<ServerPlayer, LocalMobCapCalculator.MobCounts> f_186498_;
    private static final Function<ServerPlayer, LocalMobCapCalculator.MobCounts> newDensityCap = ignored -> new LocalMobCapCalculator.MobCounts();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo info) {
        this.f_186498_ = new Reference2ReferenceOpenHashMap();
    }

    @Unique
    private Object[] getMobSpawnablePlayersArray(ChunkPos chunkPos) {
        AreaPlayerChunkWatchingManager manager = (AreaPlayerChunkWatchingManager)((IThreadedAnvilChunkStorage)this.f_186499_).getPlayerChunkWatchingManager();
        return manager.getPlayersInGeneralAreaMap(chunkPos.m_45588_());
    }

    private static double sqrDistance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    @Overwrite
    public void m_186512_(ChunkPos chunkPos, MobCategory spawnGroup) {
        double centerX = chunkPos.m_151390_();
        double centerZ = chunkPos.m_151393_();
        for (Object _player : this.getMobSpawnablePlayersArray(chunkPos)) {
            ServerPlayer player;
            if (!(_player instanceof ServerPlayer) || (player = (ServerPlayer)_player).m_5833_() || !(MixinSpawnDensityCapper.sqrDistance(centerX, centerZ, player.m_20185_(), player.m_20189_()) <= 16384.0)) continue;
            this.f_186498_.computeIfAbsent(player, newDensityCap).m_186517_(spawnGroup);
        }
    }

    @Overwrite
    public boolean m_186504_(MobCategory spawnGroup, ChunkPos chunkPos) {
        double centerX = chunkPos.m_151390_();
        double centerZ = chunkPos.m_151393_();
        for (Object _player : this.getMobSpawnablePlayersArray(chunkPos)) {
            LocalMobCapCalculator.MobCounts densityCap;
            ServerPlayer player;
            if (!(_player instanceof ServerPlayer) || (player = (ServerPlayer)_player).m_5833_() || !(MixinSpawnDensityCapper.sqrDistance(centerX, centerZ, player.m_20185_(), player.m_20189_()) <= 16384.0) || (densityCap = this.f_186498_.get(player)) != null && !densityCap.m_186522_(spawnGroup)) continue;
            return true;
        }
        return false;
    }
}

