/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.playerwatching.optimize_nearby_player_lookups;

import com.ishland.vmp.common.chunkwatching.AreaPlayerChunkWatchingManager;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import io.papermc.paper.util.MCUtil;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerWorld
extends Level
implements WorldGenLevel {
    protected MixinServerWorld(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow
    public abstract ServerChunkCache m_7726_();

    @Nullable
    public Player m_5788_(double x, double y, double z, double maxDistance, @Nullable Predicate<Entity> targetPredicate) {
        ChunkMap threadedAnvilChunkStorage = this.m_7726_().f_8325_;
        AreaPlayerChunkWatchingManager playerChunkWatchingManager = (AreaPlayerChunkWatchingManager)((IThreadedAnvilChunkStorage)threadedAnvilChunkStorage).getPlayerChunkWatchingManager();
        int chunkX = SectionPos.m_175552_((double)x);
        int chunkZ = SectionPos.m_175552_((double)z);
        if ((double)(AreaPlayerChunkWatchingManager.GENERAL_PLAYER_AREA_MAP_DISTANCE * 16) < maxDistance || maxDistance < 0.0) {
            return super.m_5788_(x, y, z, maxDistance, targetPredicate);
        }
        Object[] playersWatchingChunkArray = playerChunkWatchingManager.getPlayersInGeneralAreaMap(MCUtil.getCoordinateKey(chunkX, chunkZ));
        ServerPlayer nearestPlayer = null;
        double nearestDistance = maxDistance * maxDistance;
        for (Object __player : playersWatchingChunkArray) {
            double distance;
            if (!(__player instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)__player;
            if (targetPredicate != null && !targetPredicate.test((Entity)player) || !((distance = player.m_20275_(x, y, z)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    @Nullable
    public Player m_45946_(TargetingConditions targetPredicate, LivingEntity entity) {
        return this.m_45949_(targetPredicate, entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    @Nullable
    public Player m_45949_(TargetingConditions targetPredicate, LivingEntity entity, double x, double y, double z) {
        ChunkMap threadedAnvilChunkStorage = this.m_7726_().f_8325_;
        AreaPlayerChunkWatchingManager playerChunkWatchingManager = (AreaPlayerChunkWatchingManager)((IThreadedAnvilChunkStorage)threadedAnvilChunkStorage).getPlayerChunkWatchingManager();
        int chunkX = SectionPos.m_175552_((double)x);
        int chunkZ = SectionPos.m_175552_((double)z);
        Object[] playersWatchingChunkArray = playerChunkWatchingManager.getPlayersInGeneralAreaMap(MCUtil.getCoordinateKey(chunkX, chunkZ));
        ServerPlayer nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Object __player : playersWatchingChunkArray) {
            double distance;
            if (!(__player instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)__player;
            if (targetPredicate != null && !targetPredicate.m_26885_(entity, (LivingEntity)player) || !((distance = player.m_20275_(x, y, z)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    @Nullable
    public Player m_45941_(TargetingConditions targetPredicate, double x, double y, double z) {
        return this.m_45949_(targetPredicate, null, x, y, z);
    }

    public boolean m_45914_(double x, double y, double z, double range) {
        ChunkMap threadedAnvilChunkStorage = this.m_7726_().f_8325_;
        AreaPlayerChunkWatchingManager playerChunkWatchingManager = (AreaPlayerChunkWatchingManager)((IThreadedAnvilChunkStorage)threadedAnvilChunkStorage).getPlayerChunkWatchingManager();
        int chunkX = SectionPos.m_175552_((double)x);
        int chunkZ = SectionPos.m_175552_((double)z);
        if ((double)(AreaPlayerChunkWatchingManager.GENERAL_PLAYER_AREA_MAP_DISTANCE * 16) < range) {
            return super.m_45914_(x, y, z, range);
        }
        Object[] playersWatchingChunkArray = playerChunkWatchingManager.getPlayersWatchingChunkArray(MCUtil.getCoordinateKey(chunkX, chunkZ));
        double rangeSquared = range * range;
        for (Object __player : playersWatchingChunkArray) {
            ServerPlayer player;
            if (!(__player instanceof ServerPlayer) || (player = (ServerPlayer)__player).m_5833_() || !player.m_6084_()) continue;
            double distance = player.m_20275_(x, y, z);
            if (!(range < 0.0) && !(distance < rangeSquared)) continue;
            return true;
        }
        return false;
    }
}

