/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.general.cache_ops.biome;

import com.ishland.vmp.common.general.cache_ops.biome.PreloadingBiome;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LevelChunk.class})
public abstract class MixinWorldChunk
extends ChunkAccess
implements PreloadingBiome {
    @Shadow
    @Final
    private Level f_62776_;
    @Unique
    private CompletableFuture<Void> vmp$preloadBiomeFuture = null;
    @Unique
    private PalettedContainer<Holder<Biome>>[] vmp$preloadedBiome = null;
    @Unique
    private boolean vmp$needBiomeReload = false;

    public MixinWorldChunk(ChunkPos pos, UpgradeData upgradeData, LevelHeightAccessor heightLimitView, Registry<Biome> biome, long inhabitedTime, @Nullable LevelChunkSection[] sectionArrayInitializer, @Nullable BlendingData blendingData) {
        super(pos, upgradeData, heightLimitView, biome, inhabitedTime, sectionArrayInitializer, blendingData);
    }

    private static int vmp$getBiomeIndex(int x, int z) {
        return (z & 0xF) << 4 | x & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vmp$tryPreloadBiome(WorldGenRegion chunkRegion) {
        MixinWorldChunk mixinWorldChunk = this;
        synchronized (mixinWorldChunk) {
            if (this.vmp$preloadBiomeFuture == null) {
                this.vmp$preloadBiomeFuture = CompletableFuture.runAsync(() -> {
                    PalettedContainer[] preloadedBiome = new PalettedContainer[this.m_151559_()];
                    Registry biomeRegistry = this.f_62776_.m_9598_().m_175515_(Registries.f_256952_);
                    for (int y = 0; y < preloadedBiome.length; ++y) {
                        preloadedBiome[y] = new PalettedContainer(biomeRegistry.m_206115_(), (Object)biomeRegistry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188137_);
                    }
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            for (int y = this.m_141937_(); y < this.m_151558_(); ++y) {
                                preloadedBiome[this.m_151564_(y)].m_156470_(x & 0xF, y & 0xF, z & 0xF, (Object)chunkRegion.m_204166_(new BlockPos(this.f_187604_.m_45604_() + x, y, this.f_187604_.m_45605_() + z)));
                            }
                        }
                    }
                    this.vmp$preloadedBiome = preloadedBiome;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vmp$tryReloadBiome(WorldGenRegion chunkRegion) {
        MixinWorldChunk mixinWorldChunk = this;
        synchronized (mixinWorldChunk) {
            if (this.vmp$preloadBiomeFuture == null) {
                this.vmp$tryPreloadBiome(chunkRegion);
            } else if (this.vmp$preloadBiomeFuture.isDone()) {
                this.vmp$preloadBiomeFuture = null;
                this.vmp$tryPreloadBiome(chunkRegion);
            } else {
                this.vmp$needBiomeReload = true;
                this.vmp$preloadBiomeFuture.thenRun(() -> {
                    MixinWorldChunk mixinWorldChunk = this;
                    synchronized (mixinWorldChunk) {
                        if (this.vmp$needBiomeReload) {
                            this.vmp$needBiomeReload = false;
                            this.vmp$tryPreloadBiome(chunkRegion);
                        }
                    }
                });
            }
        }
    }

    @Override
    public Holder<Biome> vmp$getBiomeCached(int x, int y, int z) {
        if (this.vmp$preloadedBiome == null) {
            return null;
        }
        int yIndex = Mth.m_14045_((int)this.m_151564_(y), (int)0, (int)(this.vmp$preloadedBiome.length - 1));
        return (Holder)this.vmp$preloadedBiome[yIndex].m_63087_(x & 0xF, y & 0xF, z & 0xF);
    }
}

