/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.portals;

import com.ibm.asyncutil.iteration.AsyncIterator;
import com.ishland.vmp.common.chunk.loading.IEntityPortalInterface;
import com.ishland.vmp.common.chunk.loading.IPOIAsyncPreload;
import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.AsyncChunkLoadUtil;
import com.ishland.vmp.common.config.Config;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEntityPortalInterface {
    @Unique
    private static final CompletableFuture<PortalInfo> TARGET_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    @Shadow
    protected boolean f_19817_;
    @Shadow
    public Level f_19853_;
    @Shadow
    @Final
    private static Logger f_19849_;
    @Shadow
    protected int f_19818_;
    @Shadow
    protected BlockPos f_19819_;
    @Unique
    private CompletableFuture<PortalInfo> vmp$locatePortalFuture;
    @Unique
    private CompletableFuture<PortalInfo> vmp$lastLocateFuture = TARGET_COMPLETED_FUTURE;
    @Unique
    private long vmp$locateIndex = 0L;

    @Shadow
    public abstract boolean m_20159_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract int m_6078_();

    @Shadow
    @Nullable
    protected abstract PortalInfo m_7937_(ServerLevel var1);

    @Shadow
    @Nullable
    public abstract Entity m_5489_(ServerLevel var1);

    @Shadow
    protected abstract Vec3 m_7643_(Direction.Axis var1, BlockUtil.FoundRectangle var2);

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract Pose m_20089_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    public abstract float m_146908_();

    @Shadow
    public abstract float m_146909_();

    @Shadow
    public abstract boolean m_213877_();

    @Shadow
    public abstract void m_19877_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Inject(method={"tickPortal"}, at={@At(value="HEAD")})
    private void onTickNetherPortal(CallbackInfo ci) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this instanceof ServerPlayer) {
            if (this.f_19817_ && this.f_19818_ >= this.m_6078_() - 50) {
                if (this.vmp$locatePortalFuture == null && this.vmp$lastLocateFuture.isDone()) {
                    MixinEntity mixinEntity;
                    MinecraftServer minecraftServer = this.f_19853_.m_7654_();
                    ResourceKey registryKey = this.f_19853_.m_46472_() == Level.f_46429_ ? Level.f_46428_ : Level.f_46429_;
                    ServerLevel destination = minecraftServer.m_129880_(registryKey);
                    long currentLocateIndex = ++this.vmp$locateIndex;
                    long startTime = System.nanoTime();
                    if (Config.SHOW_ASYNC_LOADING_MESSAGES && (mixinEntity = this) instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)mixinEntity;
                        player.m_5661_((Component)Component.m_237113_((String)"Locating portal destination..."), true);
                    }
                    this.vmp$locatePortalFuture = this.getTeleportTargetAtAsync(destination).thenComposeAsync(target -> {
                        if (target != null) {
                            return AsyncChunkLoadUtil.scheduleChunkLoad(destination, new ChunkPos(BlockPos.m_274561_((double)target.f_77676_.f_82479_, (double)target.f_77676_.f_82480_, (double)target.f_77676_.f_82481_))).thenApplyAsync(unused -> {
                                BlockPos blockPos = BlockPos.m_274561_((double)target.f_77676_.f_82479_, (double)target.f_77676_.f_82480_, (double)target.f_77676_.f_82481_);
                                destination.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockPos), 3, (Object)blockPos);
                                return target;
                            }, (Executor)destination.m_7654_());
                        }
                        return CompletableFuture.completedFuture(null);
                    }, (Executor)destination.m_7654_()).whenCompleteAsync((target, throwable) -> {
                        if (currentLocateIndex != this.vmp$locateIndex) {
                            return;
                        }
                        if (throwable != null) {
                            MixinEntity patt6944$temp;
                            f_19849_.error("Error occurred for entity {} while locating portal", (Object)this, throwable);
                            if (Config.SHOW_ASYNC_LOADING_MESSAGES && (patt6944$temp = this) instanceof ServerPlayer) {
                                ServerPlayer player = (ServerPlayer)patt6944$temp;
                                player.m_5661_((Component)Component.m_237113_((String)"Error occurred while locating portal"), true);
                            }
                        } else if (target != null) {
                            if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                                f_19849_.info("Portal located for entity {} at {}", (Object)this, target);
                                BlockPos blockPos = BlockPos.m_274561_((double)target.f_77676_.f_82479_, (double)target.f_77676_.f_82480_, (double)target.f_77676_.f_82481_);
                                MixinEntity patt7643$temp = this;
                                if (patt7643$temp instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)patt7643$temp;
                                    player.m_5661_((Component)Component.m_237113_((String)"Portal located after %.1fms, waiting for portal teleportation...".formatted((double)(System.nanoTime() - startTime) / 1000000.0)), true);
                                }
                            }
                        } else if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                            f_19849_.info("Portal not located for entity {} at {}", (Object)this, target);
                            MixinEntity patt8314$temp = this;
                            if (patt8314$temp instanceof ServerPlayer) {
                                ServerPlayer player = (ServerPlayer)patt8314$temp;
                                player.m_5661_((Component)Component.m_237113_((String)"Portal not located, will spawn a new portal later"), true);
                            }
                        }
                    }, (Executor)destination.m_7654_()).toCompletableFuture();
                    this.vmp$lastLocateFuture = this.vmp$locatePortalFuture;
                }
            } else if (this.vmp$locatePortalFuture != null) {
                MixinEntity mixinEntity;
                boolean done = this.vmp$locatePortalFuture.isDone();
                this.vmp$locatePortalFuture.cancel(false);
                this.vmp$locatePortalFuture = null;
                ++this.vmp$locateIndex;
                if (!done && Config.SHOW_ASYNC_LOADING_MESSAGES && (mixinEntity = this) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)mixinEntity;
                    player.m_5661_((Component)Component.m_237113_((String)"Portal location cancelled"), true);
                }
            }
        }
    }

    @Redirect(method={"tickPortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getMaxNetherPortalTime()I"))
    private int redirectMaxPortalTime(Entity instance) {
        if (instance instanceof ServerPlayer) {
            return this.vmp$locatePortalFuture != null && this.vmp$locatePortalFuture.isDone() ? instance.m_6078_() : Integer.MAX_VALUE;
        }
        return instance.m_6078_();
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeGetTeleportTarget(ServerLevel destination, CallbackInfoReturnable<PortalInfo> cir) {
        PortalInfo value;
        if (this.vmp$locatePortalFuture != null && this.vmp$locatePortalFuture.isDone() && !this.vmp$locatePortalFuture.isCompletedExceptionally() && (value = this.vmp$locatePortalFuture.join()) != null) {
            cir.setReturnValue((Object)value);
        }
    }

    @Unique
    public CompletionStage<PortalInfo> getTeleportTargetAtAsync(ServerLevel destination) {
        boolean bl2;
        boolean bl = this.f_19853_.m_46472_() == Level.f_46430_ && destination.m_46472_() == Level.f_46428_;
        boolean bl3 = bl2 = destination.m_46472_() == Level.f_46430_;
        if (!bl && !bl2) {
            boolean bl32;
            boolean bl4 = bl32 = destination.m_46472_() == Level.f_46429_;
            if (this.f_19853_.m_46472_() != Level.f_46429_ && !bl32) {
                return CompletableFuture.completedFuture(null);
            }
            WorldBorder worldBorder = destination.m_6857_();
            double d = DimensionType.m_63908_((DimensionType)this.f_19853_.m_6042_(), (DimensionType)destination.m_6042_());
            BlockPos destPos = worldBorder.m_187569_(this.m_20185_() * d, this.m_20186_(), this.m_20189_() * d);
            return this.getPortalRectAtAsync(destination, destPos, bl32, worldBorder).thenComposeAsync(optional -> optional.map(rect -> AsyncChunkLoadUtil.scheduleChunkLoad(destination, new ChunkPos(this.f_19819_)).thenComposeAsync(unused -> {
                Vec3 vec3d;
                Direction.Axis axis;
                BlockState blockState = this.f_19853_.m_8055_(this.f_19819_);
                if (blockState.m_61138_((Property)BlockStateProperties.f_61364_)) {
                    axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_);
                    BlockUtil.FoundRectangle rectangle = BlockUtil.m_124334_((BlockPos)this.f_19819_, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> this.f_19853_.m_8055_(pos) == blockState);
                    vec3d = this.m_7643_(axis, rectangle);
                } else {
                    axis = Direction.Axis.X;
                    vec3d = new Vec3(0.5, 0.0, 0.0);
                }
                return AsyncChunkLoadUtil.scheduleChunkLoad(destination, new ChunkPos(rect.f_124348_)).thenApplyAsync(unused1 -> PortalShape.m_257966_((ServerLevel)destination, (BlockUtil.FoundRectangle)rect, (Direction.Axis)axis, (Vec3)vec3d, (Entity)((Entity)this), (Vec3)this.m_20184_(), (float)this.m_146908_(), (float)this.m_146909_()), (Executor)destination.m_7654_());
            }, (Executor)destination.m_7654_())).orElse(CompletableFuture.completedFuture(null)), (Executor)destination.m_7654_());
        }
        BlockPos blockPos = bl2 ? ServerLevel.f_8562_ : destination.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destination.m_220360_());
        return CompletableFuture.completedFuture(new PortalInfo(new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5), this.m_20184_(), this.m_146908_(), this.m_146909_()));
    }

    @Unique
    public CompletionStage<Optional<BlockUtil.FoundRectangle>> getPortalRectAtAsync(ServerLevel destination, BlockPos destPos, boolean destIsNether, WorldBorder worldBorder) {
        PoiManager pointOfInterestStorage = destination.m_8904_();
        int i = destIsNether ? 16 : 128;
        return ((IPOIAsyncPreload)pointOfInterestStorage).preloadChunksAtAsync(destination, destPos, i).thenComposeAsync(unused -> {
            Iterator<PoiRecord> iterator = pointOfInterestStorage.m_27166_(registryEntry -> registryEntry.m_203565_(PoiTypes.f_218064_), destPos, i, PoiManager.Occupancy.ANY).filter(poi -> worldBorder.m_61937_(poi.m_27257_())).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)destPos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).toList().iterator();
            return AsyncIterator.fromIterator(iterator).filterCompose(poi -> AsyncChunkLoadUtil.scheduleChunkLoadWithRadius(destination, new ChunkPos(poi.m_27257_()), 0).thenApplyAsync(either -> (Optional)either.map(chunk -> chunk.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_) ? Optional.of(poi) : Optional.empty(), unloaded -> {
                throw new IllegalStateException();
            }), (Executor)destination.m_7654_())).take(1L).thenComposeAsync(poi -> {
                BlockPos blockPos = poi.m_27257_();
                return AsyncChunkLoadUtil.scheduleChunkLoad(destination, new ChunkPos(blockPos)).thenApplyAsync(unused1 -> {
                    destination.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockPos), 3, (Object)blockPos);
                    BlockState blockState = destination.m_8055_(blockPos);
                    return BlockUtil.m_124334_((BlockPos)blockPos, (Direction.Axis)((Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posx -> destination.m_8055_(posx) == blockState);
                }, (Executor)destination.m_7654_());
            }, (Executor)destination.m_7654_()).collect(Collectors.toCollection(() -> new ReferenceArrayList(1))).thenApply(list -> list.isEmpty() ? Optional.empty() : Optional.of((BlockUtil.FoundRectangle)list.get(0)));
        }, (Executor)destination.m_7654_());
    }
}

