/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.async_chunk_on_player_login;

import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.AsyncChunkLoadUtil;
import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.IAsyncChunkPlayer;
import com.ishland.vmp.common.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class MixinServerPlayNetworkHandler {
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    @Final
    private MinecraftServer f_9745_;
    @Shadow
    @Final
    private static Logger f_9744_;
    @Shadow
    @Final
    public Connection f_9742_;
    @Unique
    private boolean isPerformingRespawn = false;

    @Shadow
    public abstract void m_6272_(ServerboundClientCommandPacket var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;updatePositionAndAngles(DDDFF)V"))
    private void suppressUpdatePositionDuringChunkLoad(ServerPlayer instance, double x, double y, double z, float yaw, float pitch) {
        if (((IAsyncChunkPlayer)instance).isChunkLoadCompleted()) {
            instance.m_19890_(x, y, z, yaw, pitch);
        }
    }

    @Inject(method={"onClientStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetworkThreadUtils;forceMainThread(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/listener/PacketListener;Lnet/minecraft/server/world/ServerWorld;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void performAsyncRespawn(ServerboundClientCommandPacket packet, CallbackInfo ci) {
        if (packet.m_133850_() == ServerboundClientCommandPacket.Action.PERFORM_RESPAWN) {
            if (AsyncChunkLoadUtil.isRespawnChunkLoadFinished()) {
                return;
            }
            if (!this.f_9743_.f_8944_ && this.f_9743_.m_21223_() > 0.0f) {
                return;
            }
            ci.cancel();
            if (this.isPerformingRespawn) {
                return;
            }
            this.isPerformingRespawn = true;
            ServerLevel spawnPointWorld = this.f_9745_.m_129880_(this.f_9743_.m_8963_());
            spawnPointWorld = spawnPointWorld != null ? spawnPointWorld : this.f_9745_.m_129783_();
            BlockPos spawnPointPosition = this.f_9743_.m_8961_();
            spawnPointPosition = spawnPointPosition != null ? spawnPointPosition : spawnPointWorld.m_220360_();
            ChunkPos pos = new ChunkPos(spawnPointPosition);
            if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                this.f_9743_.m_5661_((Component)Component.m_237113_((String)"Performing respawn..."), true);
            }
            long startTime = System.nanoTime();
            AsyncChunkLoadUtil.scheduleChunkLoad(spawnPointWorld, pos).whenCompleteAsync((unused, throwable) -> {
                if (!this.f_9742_.m_129536_()) {
                    return;
                }
                if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                    f_9744_.info("Async chunk loading for player {} completed", (Object)this.f_9743_.m_7755_().getString());
                }
                this.isPerformingRespawn = false;
                try {
                    AsyncChunkLoadUtil.setIsRespawnChunkLoadFinished(true);
                    this.m_6272_(packet);
                }
                finally {
                    AsyncChunkLoadUtil.setIsRespawnChunkLoadFinished(false);
                }
                if (Config.SHOW_ASYNC_LOADING_MESSAGES) {
                    this.f_9743_.m_5661_((Component)Component.m_237113_((String)"Respawn finished after %.1fms".formatted((double)(System.nanoTime() - startTime) / 1000000.0)), true);
                }
            }, runnable -> this.f_9745_.m_6937_((Runnable)new TickTask(0, runnable)));
        }
    }
}

