/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.chunk.loading.async_chunk_on_player_login;

import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.AsyncChunkLoadUtil;
import com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login.IAsyncChunkPlayer;
import com.ishland.vmp.mixins.access.IServerChunkManager;
import com.mojang.datafixers.util.Either;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerManager {
    @Shadow
    @Final
    private static Logger f_11188_;

    @Shadow
    public abstract void m_11229_(ServerPlayer var1, ServerLevel var2);

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;requestTeleport(DDDFF)V"))
    private void redirectRequestTeleport(ServerGamePacketListenerImpl instance, double x, double y, double z, float yaw, float pitch) {
        ServerChunkCache chunkManager = instance.f_9743_.m_284548_().m_7726_();
        DistanceManager ticketManager = ((IServerChunkManager)chunkManager).getTicketManager();
        ((IAsyncChunkPlayer)instance.f_9743_).markPlayerForAsyncChunkLoad();
        ChunkPos pos = new ChunkPos(BlockPos.m_274561_((double)x, (double)y, (double)z));
        instance.f_9743_.f_8944_ = true;
        MinecraftServer server = instance.f_9743_.f_8924_;
        BiConsumer<Either, Throwable> action = (worldChunkUnloadedEither, throwable) -> {
            if (throwable != null) {
                f_11188_.error("Error while loading chunks", throwable);
                return;
            }
            if (!instance.m_6198_()) {
                return;
            }
            instance.f_9743_.f_8944_ = false;
            instance.m_9774_(x, y, z, yaw, pitch);
            this.m_11229_(instance.f_9743_, instance.f_9743_.m_284548_());
            instance.f_9743_.m_284548_().m_8834_(instance.f_9743_);
            instance.f_9743_.m_143429_();
            CompoundTag playerData = ((IAsyncChunkPlayer)instance.f_9743_).getPlayerData();
            ((IAsyncChunkPlayer)instance.f_9743_).setPlayerData(null);
            this.vmp$mountSavedVehicles(instance.f_9743_, playerData);
            ((IAsyncChunkPlayer)instance.f_9743_).onChunkLoadComplete();
            f_11188_.info("Async chunk loading for player {} completed", (Object)instance.f_9743_.m_7755_().getString());
        };
        if (instance.f_9743_.getClass() != ServerPlayer.class) {
            action.accept(null, null);
            return;
        }
        AsyncChunkLoadUtil.scheduleChunkLoad(instance.f_9743_.m_284548_(), pos).whenCompleteAsync(action, runnable -> server.m_6937_((Runnable)new TickTask(0, runnable)));
    }

    @Unique
    private void vmp$mountSavedVehicles(ServerPlayer player, CompoundTag playerData) {
        if (playerData != null && playerData.m_128425_("RootVehicle", 10)) {
            CompoundTag nbtCompound2 = playerData.m_128469_("RootVehicle");
            ServerLevel world = player.m_284548_();
            Entity entity = EntityType.m_20645_((CompoundTag)nbtCompound2.m_128469_("Entity"), (Level)world, vehicle -> !world.m_8847_(vehicle) ? null : vehicle);
            if (entity != null) {
                UUID uUID = nbtCompound2.m_128403_("Attach") ? nbtCompound2.m_128342_("Attach") : null;
                if (entity.m_20148_().equals(uUID)) {
                    player.m_7998_(entity, true);
                } else {
                    for (Entity entity2 : entity.m_146897_()) {
                        if (!entity2.m_20148_().equals(uUID)) continue;
                        player.m_7998_(entity2, true);
                        break;
                    }
                }
                if (!player.m_20159_()) {
                    f_11188_.warn("Couldn't reattach entity to player");
                    entity.m_146870_();
                    for (Entity entity2 : entity.m_146897_()) {
                        entity2.m_146870_();
                    }
                }
            }
        }
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;onPlayerConnected(Lnet/minecraft/server/network/ServerPlayerEntity;)V"))
    private void delayAddToWorld(ServerLevel instance, ServerPlayer player) {
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;sendWorldInfo(Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/server/world/ServerWorld;)V"))
    private void delaySendWorldInfo(PlayerList instance, ServerPlayer player, ServerLevel world) {
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;onSpawn()V"))
    private void delayPlayerSpawn(ServerPlayer instance) {
    }

    @Redirect(method={"onPlayerConnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityType;loadEntityWithPassengers(Lnet/minecraft/nbt/NbtCompound;Lnet/minecraft/world/World;Ljava/util/function/Function;)Lnet/minecraft/entity/Entity;"))
    @Nullable
    private Entity delayPassengerMount(CompoundTag nbt, Level world, Function<Entity, Entity> entityProcessor) {
        return null;
    }

    @Inject(method={"loadPlayerData"}, at={@At(value="RETURN")})
    private void onLoadPlayerData(ServerPlayer player, CallbackInfoReturnable<CompoundTag> cir) {
        ((IAsyncChunkPlayer)player).setPlayerData((CompoundTag)cir.getReturnValue());
    }

    @Inject(method={"savePlayerData"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeSavePlayerData(ServerPlayer player, CallbackInfo ci) {
        if (!((IAsyncChunkPlayer)player).isChunkLoadCompleted()) {
            ci.cancel();
        }
    }
}

