/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.playerwatching;

import com.ishland.vmp.common.maps.AreaMap;
import com.ishland.vmp.common.playerwatching.EntityTrackerExtension;
import com.ishland.vmp.common.playerwatching.ServerPlayerEntityExtension;
import com.ishland.vmp.common.playerwatching.compat.EntityPositionTransformer;
import com.ishland.vmp.common.util.ModLoaderUtils;
import com.ishland.vmp.common.util.SimpleObjectPool;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorageEntityTracker;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class NearbyEntityTracking {
    private static final EntityPositionTransformer[] transformers;
    private final SimpleObjectPool<ReferenceLinkedOpenHashSet<?>> pooledHashSets = new SimpleObjectPool<ReferenceLinkedOpenHashSet>(unused -> new ReferenceLinkedOpenHashSet(), ReferenceLinkedOpenHashSet::clear, ts -> {
        ts.clear();
        ts.trim(4);
    }, 8192);
    private final AreaMap<ChunkMap.TrackedEntity> areaMap = new AreaMap<ChunkMap.TrackedEntity>((object, x, z) -> {}, (object, x, z) -> {}, false);
    private final Reference2ReferenceLinkedOpenHashMap<ServerPlayer, ReferenceLinkedOpenHashSet<ChunkMap.TrackedEntity>> playerTrackers = new Reference2ReferenceLinkedOpenHashMap();
    private final Reference2LongOpenHashMap<ChunkMap.TrackedEntity> tracker2ChunkPos = new Reference2LongOpenHashMap();
    private final ReferenceLinkedOpenHashSet<ChunkMap.TrackedEntity> trackerTickList = new ReferenceLinkedOpenHashSet<ChunkMap.TrackedEntity>(){

        protected void rehash(int newN) {
            if (this.n < newN) {
                super.rehash(newN);
            }
        }
    };

    public static void init() {
    }

    public void addEntityTracker(ChunkMap.TrackedEntity tracker) {
        ChunkPos pos = NearbyEntityTracking.getEntityChunkPos(((IThreadedAnvilChunkStorageEntityTracker)tracker).getEntity());
        this.areaMap.add(tracker, pos.f_45578_, pos.f_45579_, this.getChunkViewDistance(tracker));
        this.tracker2ChunkPos.put((Object)tracker, pos.m_45588_());
    }

    public void removeEntityTracker(ChunkMap.TrackedEntity tracker) {
        this.areaMap.remove(tracker);
        this.tracker2ChunkPos.removeLong((Object)tracker);
    }

    public void addPlayer(ServerPlayer player) {
        this.playerTrackers.put((Object)player, this.pooledHashSets.alloc());
    }

    public void removePlayer(ServerPlayer player) {
        ReferenceLinkedOpenHashSet originalTrackers = (ReferenceLinkedOpenHashSet)this.playerTrackers.remove((Object)player);
        if (originalTrackers != null) {
            for (ChunkMap.TrackedEntity tracker : originalTrackers) {
                tracker.m_140485_(player);
            }
            this.pooledHashSets.release(originalTrackers);
        }
    }

    private static ChunkPos getEntityChunkPos(Entity entity) {
        Vec3 pos = entity.m_20182_();
        for (EntityPositionTransformer transformer : transformers) {
            pos = transformer.transform(entity, pos);
        }
        return new ChunkPos(SectionPos.m_175552_((double)pos.f_82479_), SectionPos.m_175552_((double)pos.f_82481_));
    }

    public void tick() {
        for (Object entry : this.tracker2ChunkPos.reference2LongEntrySet()) {
            ChunkPos pos = NearbyEntityTracking.getEntityChunkPos(((IThreadedAnvilChunkStorageEntityTracker)entry.getKey()).getEntity());
            if (pos.m_45588_() == entry.getLongValue()) continue;
            this.areaMap.update((ChunkMap.TrackedEntity)entry.getKey(), pos.f_45578_, pos.f_45579_, this.getChunkViewDistance((ChunkMap.TrackedEntity)entry.getKey()));
            entry.setValue(pos.m_45588_());
        }
        this.trackerTickList.clear();
        for (Object entry : this.playerTrackers.entrySet()) {
            Set<ChunkMap.TrackedEntity> currentTrackers = this.areaMap.getObjectsInRange(NearbyEntityTracking.getEntityChunkPos((Entity)entry.getKey()).m_45588_());
            boolean isPlayerPositionUpdated = ((ServerPlayerEntityExtension)entry.getKey()).vmpTracking$isPositionUpdated();
            ((ServerPlayerEntityExtension)entry.getKey()).vmpTracking$updatePosition();
            ReferenceLinkedOpenHashSet trackers = (ReferenceLinkedOpenHashSet)entry.getValue();
            ObjectListIterator iterator = trackers.iterator();
            while (iterator.hasNext()) {
                ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)iterator.next();
                if (currentTrackers.contains(entityTracker)) {
                    if (this.trackerTickList.add((Object)entityTracker)) {
                        NearbyEntityTracking.tryTickTracker(entityTracker);
                    }
                    if (!isPlayerPositionUpdated && !((EntityTrackerExtension)entityTracker).isPositionUpdated()) continue;
                    NearbyEntityTracking.tryUpdateTracker(entityTracker, (ServerPlayer)entry.getKey());
                    continue;
                }
                entityTracker.m_140485_((ServerPlayer)entry.getKey());
                iterator.remove();
            }
            for (ChunkMap.TrackedEntity entityTracker : currentTrackers) {
                if (trackers.contains((Object)entityTracker)) continue;
                if (this.trackerTickList.add((Object)entityTracker)) {
                    NearbyEntityTracking.tryTickTracker(entityTracker);
                }
                if (isPlayerPositionUpdated || ((EntityTrackerExtension)entityTracker).isPositionUpdated()) {
                    NearbyEntityTracking.tryUpdateTracker(entityTracker, (ServerPlayer)entry.getKey());
                }
                trackers.add((Object)entityTracker);
            }
        }
        for (ChunkMap.TrackedEntity entityTracker : this.trackerTickList) {
            ((EntityTrackerExtension)entityTracker).updatePosition();
        }
    }

    private static void tryUpdateTracker(ChunkMap.TrackedEntity entityTracker, ServerPlayer player) {
        entityTracker.m_140497_(player);
    }

    private static void tryTickTracker(ChunkMap.TrackedEntity entityTracker) {
        ((EntityTrackerExtension)entityTracker).tryTick();
    }

    private int getChunkViewDistance(ChunkMap.TrackedEntity tracker) {
        return (int)Math.ceil((double)((IThreadedAnvilChunkStorageEntityTracker)tracker).invokeGetMaxTrackDistance() / 16.0) + 1;
    }

    static {
        ArrayList<EntityPositionTransformer> list = new ArrayList<EntityPositionTransformer>();
        if (ModLoaderUtils.isModLoaded("valkyrienskies")) {
            System.out.println("ValkyrienSkies detected, applying compatibility patch");
            try {
                list.add((EntityPositionTransformer)Class.forName("com.ishland.vmp.common.playerwatching.compat.ValkyrienSkies2ShipPositionTransformer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        transformers = (EntityPositionTransformer[])list.toArray(EntityPositionTransformer[]::new);
    }
}

