/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunk.sending;

import com.google.common.util.concurrent.RateLimiter;
import com.ishland.vmp.common.chunkwatching.PlayerClientVDTracking;
import com.ishland.vmp.common.config.Config;
import com.ishland.vmp.common.maps.AreaMap;
import com.ishland.vmp.common.util.SimpleObjectPool;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.Collection;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerChunkSendingSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerChunkSendingSystem");
    public static final boolean ENABLED = true;
    private final Reference2ReferenceLinkedOpenHashMap<ServerPlayer, PlayerState> players = new Reference2ReferenceLinkedOpenHashMap();
    private final AreaMap<ServerPlayer> areaMap = new AreaMap<ServerPlayer>((player, x, z) -> {
        PlayerState state = (PlayerState)this.players.computeIfAbsent(player, x$0 -> new PlayerState((ServerPlayer)x$0));
        state.sendQueue.add(new ChunkPos(x, z));
    }, (player, x, z) -> {
        PlayerState state = (PlayerState)this.players.get(player);
        if (state != null) {
            state.unloadChunk(x, z);
        }
    }, false);
    private final ChunkMap tacs;
    private final Object2LongOpenHashMap<ServerPlayer> positions = new Object2LongOpenHashMap();
    private final SimpleObjectPool<MutableObject<ClientboundLevelChunkWithLightPacket>> pool = new SimpleObjectPool<MutableObject>(pool -> new MutableObject(), mutableObject -> mutableObject.setValue(null), mutableObject -> mutableObject.setValue(null), 8192);
    private final Long2ObjectFunction<MutableObject<ClientboundLevelChunkWithLightPacket>> allocFunction = unused -> this.pool.alloc();
    private final Long2ObjectOpenHashMap<MutableObject<ClientboundLevelChunkWithLightPacket>> cache = new Long2ObjectOpenHashMap();
    private int watchDistance = 5;

    public PlayerChunkSendingSystem(ChunkMap tacs) {
        this.tacs = tacs;
    }

    public void tick() {
        for (PlayerState state : this.players.values()) {
            state.tick(this.cache);
        }
        for (MutableObject value : this.cache.values()) {
            this.pool.release((MutableObject<ClientboundLevelChunkWithLightPacket>)value);
        }
        this.cache.clear();
        this.cache.trim(64);
    }

    public void onChunkLoaded(long pos) {
        for (Object _player : this.areaMap.getObjectsInRangeArray(pos)) {
            if (!(_player instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)_player;
            PlayerState state = (PlayerState)this.players.get((Object)player);
            state.sendQueue.add(new ChunkPos(pos));
        }
    }

    public void setWatchDistance(int watchDistance) {
        this.watchDistance = Math.max(3, watchDistance);
        for (Object2LongMap.Entry entry : this.positions.object2LongEntrySet()) {
            this.areaMap.update((ServerPlayer)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), this.getActualWatchDistance((ServerPlayer)entry.getKey()));
        }
    }

    public void add(ServerPlayer player, int x, int z) {
        this.areaMap.add(player, x, z, this.getActualWatchDistance(player));
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
    }

    public void remove(ServerPlayer player) {
        this.areaMap.remove(player);
        this.players.remove((Object)player);
        this.positions.removeLong((Object)player);
    }

    public void movePlayer(ServerPlayer player, long currentPos) {
        int x = ChunkPos.m_45592_((long)currentPos);
        int z = ChunkPos.m_45602_((long)currentPos);
        this.areaMap.update(player, x, z, this.getActualWatchDistance(player));
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
        PlayerState state = (PlayerState)this.players.get((Object)player);
        if (state != null) {
            state.updateQueue();
        }
    }

    private int getActualWatchDistance(ServerPlayer player) {
        PlayerClientVDTracking tracking;
        return player instanceof PlayerClientVDTracking && (tracking = (PlayerClientVDTracking)player).getClientViewDistance() != -1 ? Math.min(tracking.getClientViewDistance() + 1, this.watchDistance) : this.watchDistance;
    }

    private void sendChunk(ServerPlayer player, ChunkPos pos, MutableObject<ClientboundLevelChunkWithLightPacket> mutableObject) {
        ((IThreadedAnvilChunkStorage)this.tacs).invokeSendWatchPackets(player, pos, mutableObject, false, true);
    }

    private void unloadChunk(ServerPlayer player, ChunkPos pos) {
        ((IThreadedAnvilChunkStorage)this.tacs).invokeSendWatchPackets(player, pos, null, true, false);
    }

    private class PlayerState {
        private final ObjectArrayList<ChunkPos> tmp = new ObjectArrayList();
        private final PriorityBlockingQueue<ChunkPos> sendQueue = new PriorityBlockingQueue(441, this::compare);
        private final LongOpenHashSet sentChunks = new LongOpenHashSet();
        private final RateLimiter rateLimiter = Config.TARGET_CHUNK_SEND_RATE > 0 ? RateLimiter.create((double)Config.TARGET_CHUNK_SEND_RATE, (long)1L, (TimeUnit)TimeUnit.SECONDS) : null;
        private final ServerPlayer player;
        private ChunkPos center;

        public PlayerState(ServerPlayer player) {
            this.player = player;
            this.center = player.m_146902_();
        }

        public void tick(Long2ObjectOpenHashMap<MutableObject<ClientboundLevelChunkWithLightPacket>> cachedPackets) {
            ChunkPos pos;
            PlayerClientVDTracking tracking;
            ServerPlayer serverPlayer = this.player;
            if (serverPlayer instanceof PlayerClientVDTracking && (tracking = (PlayerClientVDTracking)serverPlayer).isClientViewDistanceChanged() && PlayerChunkSendingSystem.this.positions.containsKey((Object)this.player)) {
                PlayerChunkSendingSystem.this.movePlayer(this.player, PlayerChunkSendingSystem.this.positions.getLong((Object)this.player));
            }
            while ((pos = this.sendQueue.peek()) != null && (this.rateLimiter == null || this.rateLimiter.tryAcquire())) {
                PlayerChunkSendingSystem.this.sendChunk(this.player, pos, (MutableObject<ClientboundLevelChunkWithLightPacket>)((MutableObject)cachedPackets.computeIfAbsent(pos.m_45588_(), PlayerChunkSendingSystem.this.allocFunction)));
                this.sendQueue.poll();
            }
        }

        public void unloadChunk(int x, int z) {
            long coordinateKey = MCUtil.getCoordinateKey(x, z);
            ChunkPos pos = new ChunkPos(x, z);
            this.sendQueue.remove(pos);
            PlayerChunkSendingSystem.this.unloadChunk(this.player, pos);
        }

        public void updateQueue() {
            this.tmp.clear();
            this.sendQueue.drainTo((Collection<ChunkPos>)this.tmp);
            this.center = this.player.m_146902_();
            this.sendQueue.addAll((Collection<ChunkPos>)this.tmp);
            this.tmp.clear();
        }

        private int compare(ChunkPos a, ChunkPos b) {
            return Integer.compare(this.chebyshevDistance(a), this.chebyshevDistance(b));
        }

        private int chebyshevDistance(ChunkPos pos) {
            return Math.max(Math.abs(pos.f_45578_ - this.center.f_45578_), Math.abs(pos.f_45579_ - this.center.f_45579_));
        }
    }

    public static interface ChunkUnloadingHandle {
        public void unloadChunk(ServerPlayer var1, ChunkPos var2);
    }

    public static interface ChunkSendingHandle {
        public void sendChunk(ServerPlayer var1, ChunkPos var2);
    }
}

