/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunk.loading.async_chunks_on_player_login;

import com.ibm.asyncutil.locks.AsyncSemaphore;
import com.ibm.asyncutil.locks.FairAsyncSemaphore;
import com.ishland.vmp.mixins.access.IServerChunkManager;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public class AsyncChunkLoadUtil {
    private static final TicketType<Unit> ASYNC_CHUNK_LOAD = TicketType.m_9462_((String)"vmp_async_chunk_load", (unit, unit2) -> 0);
    private static final AsyncSemaphore SEMAPHORE = new FairAsyncSemaphore(6L);
    private static final ThreadLocal<Boolean> isRespawnChunkLoadFinished = ThreadLocal.withInitial(() -> false);

    public static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> scheduleChunkLoad(ServerLevel world, ChunkPos pos) {
        return AsyncChunkLoadUtil.scheduleChunkLoadWithRadius(world, pos, 3);
    }

    public static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> scheduleChunkLoadWithRadius(ServerLevel world, ChunkPos pos, int radius) {
        return AsyncChunkLoadUtil.scheduleChunkLoadWithLevel(world, pos, 33 - radius);
    }

    public static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> scheduleChunkLoadToStatus(ServerLevel world, ChunkPos pos, ChunkStatus status) {
        return AsyncChunkLoadUtil.scheduleChunkLoadWithLevel(world, pos, 33 + ChunkStatus.m_62370_((ChunkStatus)status));
    }

    public static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> scheduleChunkLoadWithLevel(ServerLevel world, ChunkPos pos, int level) {
        ServerChunkCache chunkManager = world.m_7726_();
        DistanceManager ticketManager = ((IServerChunkManager)chunkManager).getTicketManager();
        CompletionStage future = SEMAPHORE.acquire().toCompletableFuture().thenComposeAsync(unused -> {
            ticketManager.m_140792_(ASYNC_CHUNK_LOAD, pos, level, (Object)Unit.INSTANCE);
            ((IServerChunkManager)chunkManager).invokeTick();
            ChunkHolder chunkHolder = ((IThreadedAnvilChunkStorage)chunkManager.f_8325_).invokeGetCurrentChunkHolder(pos.m_45588_());
            if (chunkHolder == null) {
                throw new IllegalStateException("Chunk not there when requested");
            }
            FullChunkStatus levelType = ChunkLevel.m_287264_((int)level);
            return switch (levelType) {
                default -> throw new IncompatibleClassChangeError();
                case FullChunkStatus.INACCESSIBLE -> chunkHolder.m_140049_(ChunkLevel.m_287158_((int)level), world.m_7726_().f_8325_);
                case FullChunkStatus.FULL -> chunkHolder.m_140082_().thenApply(either -> either.mapLeft(Function.identity()));
                case FullChunkStatus.BLOCK_TICKING -> chunkHolder.m_140026_().thenApply(either -> either.mapLeft(Function.identity()));
                case FullChunkStatus.ENTITY_TICKING -> chunkHolder.m_140073_().thenApply(either -> either.mapLeft(Function.identity()));
            };
        }, (Executor)world.m_7654_());
        ((CompletableFuture)future).whenCompleteAsync((unused, throwable) -> {
            SEMAPHORE.release();
            if (throwable != null) {
                throwable.printStackTrace();
            }
            ticketManager.m_140823_(ASYNC_CHUNK_LOAD, pos, level, (Object)Unit.INSTANCE);
        }, (Executor)world.m_7654_());
        return future;
    }

    public static void setIsRespawnChunkLoadFinished(boolean value) {
        isRespawnChunkLoadFinished.set(value);
    }

    public static boolean isRespawnChunkLoadFinished() {
        return isRespawnChunkLoadFinished.get();
    }
}

