/*
 * Decompiled with CFR 0.152.
 */
package artemis.better_climbing.mixin;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private int climbDownTicks = 0;
    private int climbUpTicks = 0;
    private boolean climbingUpThisTick = false;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean m_6147_();

    @Redirect(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(DDD)D"))
    private double better_climbing_modifyHorizontalMovementWhenClimbing(double speed, double vanillaSpeedMin, double vanillaSpeedMax) {
        if (!this.m_9236_().m_5776_()) {
            return Mth.m_14008_((double)speed, (double)vanillaSpeedMin, (double)vanillaSpeedMax);
        }
        if (!this.m_20096_() && this.m_6047_()) {
            return Mth.m_14008_((double)speed, (double)vanillaSpeedMin, (double)vanillaSpeedMax);
        }
        return speed;
    }

    @Redirect(method={"handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(DD)D"))
    private double better_climbing_modifyVerticalMovementWhenClimbing(double currentYSpeed, double vanillaDownSpeed) {
        if (!this.m_9236_().m_5776_()) {
            return Math.max(currentYSpeed, vanillaDownSpeed);
        }
        double maxDownSpeed = Mth.m_144851_((double)this.m_146909_(), (double)20.0, (double)90.0, (double)vanillaDownSpeed, (double)-0.4);
        if (maxDownSpeed < -0.15) {
            maxDownSpeed = Mth.m_144851_((double)this.climbDownTicks, (double)0.0, (double)60.0, (double)maxDownSpeed, (double)(maxDownSpeed * 1.5));
        }
        return Math.max(currentYSpeed, maxDownSpeed);
    }

    @Inject(method={"handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void better_climbing_incrementClimbTimer(CallbackInfoReturnable<Vec3> cir) {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 movement = (Vec3)cir.getReturnValue();
        this.climbDownTicks = this.m_6147_() && movement.f_82480_ < 0.0 && this.m_146909_() > 20.0f ? ++this.climbDownTicks : 0;
        if (this.climbingUpThisTick) {
            ++this.climbUpTicks;
            this.climbingUpThisTick = false;
        } else {
            this.climbUpTicks = 0;
        }
        cir.setReturnValue((Object)movement);
    }

    @ModifyArg(method={"handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"), index=1)
    private double better_climbing_allowJumpingInLadderAndSpeedUpClimbing(double vanillaClimbSpeed) {
        if (!this.m_9236_().m_5776_()) {
            return vanillaClimbSpeed;
        }
        this.climbingUpThisTick = true;
        double increasedVanillaClimbSpeed = vanillaClimbSpeed * 1.25;
        double climbYSpeed = Mth.m_144851_((double)this.climbUpTicks, (double)0.0, (double)60.0, (double)increasedVanillaClimbSpeed, (double)(increasedVanillaClimbSpeed * 2.0));
        return Math.max(this.m_20184_().f_82480_, climbYSpeed);
    }

    @Redirect(method={"handleRelativeFrictionAndCalculateMovement(Lnet/minecraft/world/phys/Vec3;F)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;horizontalCollision:Z", opcode=180))
    private boolean better_climbing_cancelNonDeliberateCollission(LivingEntity livingEntity) {
        if (this.m_9236_().m_5776_() && livingEntity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)livingEntity;
            return livingEntity.f_19862_ && player.f_108618_.m_108575_().m_165907_() > 0.0f;
        }
        return livingEntity.f_19862_;
    }
}

