/*
 * Decompiled with CFR 0.152.
 */
package net.glad0s.bobberdetector.content.entity;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.outliner.AABBOutline;
import net.glad0s.bobberdetector.content.BobberDetectorBlock;
import net.glad0s.bobberdetector.mixin_interface.FishingHookAccessor;
import net.glad0s.bobberdetector.register.BDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BobberDetectorBlockEntity
extends SmartBlockEntity {
    private int RANGE_UP = 5;
    private int RANGE_SIDE = 5;
    private int RANGE_FRONT = 5;
    private int catchTimer = 0;
    final int CATCHCOOLDOWN = 20;
    private int redstoneTimer = 0;
    private final int REDSTONE_DURATION = 10;
    private int litRefreshTimer = 0;
    private final int LIT_RESET_TIME = 5;
    private final int FIRST_DETECTION_COOLDOWN = 20;
    boolean isBiting = false;
    private boolean powered;
    private boolean lit;
    private AABBOutline outline;

    public BobberDetectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void tick() {
        this.bobberScan();
    }

    private void updatePower(boolean powered) {
        BlockState blockstate = this.m_58900_();
        Block block = blockstate.m_60734_();
        if (block instanceof BobberDetectorBlock) {
            this.powered = powered;
            BobberDetectorBlock.setPowered(blockstate, this.f_58857_, this.f_58858_, powered);
        }
    }

    private void updateLit(boolean lit) {
        BlockState blockstate = this.m_58900_();
        Block block = blockstate.m_60734_();
        if (block instanceof BobberDetectorBlock) {
            this.lit = lit;
            BobberDetectorBlock.setLit(blockstate, this.f_58857_, this.f_58858_, lit);
        }
    }

    public AABB getAffectedArea() {
        BlockState blockstate = this.m_58900_();
        Direction facing = BobberDetectorBlock.getFacingDirection(blockstate);
        BlockPos topCorner = this.f_58858_.m_121945_(facing).m_5484_(facing.m_122427_(), this.RANGE_SIDE / 2).m_7918_(0, this.RANGE_UP / 2, 0);
        BlockPos bottomCorner = this.f_58858_.m_5484_(facing, this.RANGE_FRONT).m_5484_(facing.m_122427_().m_122427_().m_122427_(), this.RANGE_SIDE / 2).m_7918_(0, -this.RANGE_UP / 2, 0);
        AABB box = new AABB(bottomCorner).m_82367_(new AABB(topCorner));
        return box;
    }

    private void bobberScan() {
        if (!this.f_58857_.f_46443_ && this.catchTimer == 0) {
            BlockState blockstate = this.m_58900_();
            Direction facing = BobberDetectorBlock.getFacingDirection(blockstate);
            BlockPos topCorner = this.f_58858_.m_121945_(facing).m_5484_(facing.m_122427_(), this.RANGE_SIDE / 2).m_7918_(0, this.RANGE_UP / 2, 0);
            BlockPos bottomCorner = this.f_58858_.m_5484_(facing, this.RANGE_FRONT).m_5484_(facing.m_122427_().m_122427_().m_122427_(), this.RANGE_SIDE / 2).m_7918_(0, -this.RANGE_UP / 2, 0);
            AABB box = new AABB(bottomCorner).m_82367_(new AABB(topCorner));
            List entities = this.f_58857_.m_45933_(null, box);
            for (Entity target : entities) {
                boolean isInTag = target.m_6095_().m_204039_(BDTags.BOBBER_TAG);
                if (!isInTag) continue;
                if (target instanceof FishingHook) {
                    FishingHook fishingHook = (FishingHook)target;
                    this.isBiting = ((FishingHookAccessor)fishingHook).bobberdetector$isBiting();
                }
                double belowBobber = target.m_20186_() - 0.2;
                belowBobber = (double)Math.round(belowBobber * 100.0) / 100.0;
                BlockPos fluidCheck = new BlockPos((int)target.m_20185_(), (int)belowBobber, (int)target.m_20189_());
                boolean isInFluid = !this.f_58857_.m_6425_(fluidCheck).m_76178_();
                if (!isInFluid) continue;
                if (this.litRefreshTimer == 0) {
                    this.updateLit(true);
                }
                this.litRefreshTimer = 5;
                double x = (double)Math.round(target.m_20184_().f_82479_ * 100.0 * 10.0) / 10.0;
                double y = target.m_20184_().f_82480_;
                double z = (double)Math.round(target.m_20184_().f_82481_ * 100.0 * 10.0) / 10.0;
                if (!(!(target instanceof FishingHook) && y < -0.075 && x == 0.0 && z == 0.0) && (!(target instanceof FishingHook) || !this.isBiting)) continue;
                this.catchTimer = 20;
                this.redstoneTimer = 10;
                this.updatePower(true);
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
        if (this.redstoneTimer > 0) {
            --this.redstoneTimer;
            if (this.redstoneTimer == 0) {
                this.updatePower(false);
            }
        }
        if (this.catchTimer > 0) {
            --this.catchTimer;
        }
        if (this.litRefreshTimer > 0) {
            --this.litRefreshTimer;
            if (this.litRefreshTimer == 0) {
                this.updateLit(false);
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

