/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityTrim;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"storagedrawers");
    private static final Set<RegistryObject<? extends BlockEntityType<? extends BlockEntityDrawers>>> BLOCK_ENTITY_TYPES_WITH_RENDERERS = new HashSet<RegistryObject<? extends BlockEntityType<? extends BlockEntityDrawers>>>();
    public static final RegistryObject<BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_1 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_1", BlockEntityDrawersStandard.Slot1::new, BlockStandardDrawers.class, 1);
    public static final RegistryObject<BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_2", BlockEntityDrawersStandard.Slot2::new, BlockStandardDrawers.class, 2);
    public static final RegistryObject<BlockEntityType<BlockEntityDrawersStandard>> STANDARD_DRAWERS_4 = ModBlockEntities.registerDrawerBlockEntityType("standard_drawers_4", BlockEntityDrawersStandard.Slot4::new, BlockStandardDrawers.class, 4);
    public static final RegistryObject<BlockEntityType<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_2 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_2", BlockEntityDrawersComp.Slot2::new, BlockCompDrawers.class, 2);
    public static final RegistryObject<BlockEntityType<BlockEntityDrawersComp>> FRACTIONAL_DRAWERS_3 = ModBlockEntities.registerDrawerBlockEntityType("fractional_drawers_3", BlockEntityDrawersComp.Slot3::new, BlockCompDrawers.class, 3);
    public static final RegistryObject<BlockEntityType<BlockEntityController>> CONTROLLER = ModBlockEntities.registerBlockEntityType("controller", BlockEntityController::new, ModBlocks.getControllers());
    public static final RegistryObject<BlockEntityType<BlockEntitySlave>> CONTROLLER_SLAVE = ModBlockEntities.registerBlockEntityType("controller_slave", BlockEntitySlave::new, ModBlocks.getControllerSlaves());
    public static final RegistryObject<BlockEntityType<BlockEntityFramingTable>> FRAMING_TABLE = ModBlockEntities.registerBlockEntityType("framing_table", BlockEntityFramingTable::new, ModBlocks.FRAMING_TABLE);
    public static final RegistryObject<BlockEntityType<BlockEntityTrim>> TRIM = ModBlockEntities.registerTrimBlockEntityType("trim", BlockEntityTrim::new);

    private ModBlockEntities() {
    }

    private static <BE extends BlockEntityDrawers, B extends BlockDrawers> RegistryObject<BlockEntityType<BE>> registerDrawerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, Class<B> drawerBlockClass, int size) {
        RegistryObject<BlockEntityType<BE>> ro = ModBlockEntities.registerBlockEntityType(name, blockEntitySupplier, ModBlocks.getDrawersOfTypeAndSize(drawerBlockClass, size));
        BLOCK_ENTITY_TYPES_WITH_RENDERERS.add(ro);
        return ro;
    }

    private static <BE extends BlockEntityTrim> RegistryObject<BlockEntityType<BE>> registerTrimBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier) {
        return ModBlockEntities.registerBlockEntityType(name, blockEntitySupplier, ModBlocks.getFramedTrim());
    }

    private static <BE extends BaseBlockEntity, B extends Block> RegistryObject<BlockEntityType<BE>> registerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, Stream<B> blockStream) {
        return BLOCK_ENTITY_REGISTER.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)blockEntitySupplier, (Block[])((Block[])blockStream.toArray(Block[]::new))).m_58966_(null));
    }

    private static <BE extends BaseBlockEntity, B extends Block> RegistryObject<BlockEntityType<BE>> registerBlockEntityType(String name, BlockEntityType.BlockEntitySupplier<BE> blockEntitySupplier, RegistryObject<B> block) {
        return BLOCK_ENTITY_REGISTER.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)blockEntitySupplier, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }

    public static void register(IEventBus bus) {
        BLOCK_ENTITY_REGISTER.register(bus);
    }

    public static Set<RegistryObject<? extends BlockEntityType<? extends BlockEntityDrawers>>> getBlockEntityTypesWithRenderers() {
        return Collections.unmodifiableSet(BLOCK_ENTITY_TYPES_WITH_RENDERERS);
    }
}

