/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.DebugConfig;
import com.almostreliable.unified.config.DuplicationConfig;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ServerConfigs {
    private final UnifyConfig unifyConfig;
    private final DuplicationConfig dupConfig;
    private final DebugConfig debugConfig;

    public static ServerConfigs load() {
        ServerConfigs.createGitIgnoreIfNotExists();
        UnifyConfig unifyConfig = Config.load("unify", new UnifyConfig.Serializer());
        DuplicationConfig dupConfig = Config.load("duplicates", new DuplicationConfig.Serializer());
        DebugConfig debugConfig = Config.load("debug", new DebugConfig.Serializer());
        return new ServerConfigs(unifyConfig, dupConfig, debugConfig);
    }

    private ServerConfigs(UnifyConfig unifyConfig, DuplicationConfig dupConfig, DebugConfig debugConfig) {
        this.unifyConfig = unifyConfig;
        this.dupConfig = dupConfig;
        this.debugConfig = debugConfig;
    }

    private static void createGitIgnoreIfNotExists() {
        Path path = AlmostUnifiedPlatform.INSTANCE.getConfigPath();
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getConfigPath(), ".gitignore", sb -> sb.append("debug").append(".json").append("\n"));
        }
    }

    public UnifyConfig getUnifyConfig() {
        return this.unifyConfig;
    }

    public DuplicationConfig getDupConfig() {
        return this.dupConfig;
    }

    public DebugConfig getDebugConfig() {
        return this.debugConfig;
    }
}

