/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.procedures;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class NetheriteJetpackExoskeletonHandlerProcedure {
    public static final String NETHERITE_DIVING_BITS_KEY = "CreateStuffNetheriteDivingBits";
    public static final String FIRE_IMMUNE_KEY = "CreateStuffFireImmune";

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        EquipmentSlot slot = event.getSlot();
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack to = event.getTo();
        if (slot == EquipmentSlot.HEAD) {
            if (AllItems.NETHERITE_DIVING_HELMET.isIn(to)) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else {
                NetheriteJetpackExoskeletonHandlerProcedure.clearBit(entity, slot);
            }
        } else if (slot == EquipmentSlot.CHEST) {
            if (AllItems.NETHERITE_BACKTANK.isIn(to) && BacktankUtil.hasAirRemaining((ItemStack)to)) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == CreateSaModItems.NETHERITE_JETPACK_CHESTPLATE.get()) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else {
                NetheriteJetpackExoskeletonHandlerProcedure.clearBit(entity, slot);
            }
        } else if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
            if (NetheriteJetpackExoskeletonHandlerProcedure.isNetheriteArmor(to)) {
                NetheriteJetpackExoskeletonHandlerProcedure.setBit(entity, slot);
            } else {
                NetheriteJetpackExoskeletonHandlerProcedure.clearBit(entity, slot);
            }
        }
    }

    public static boolean isNetheriteArmor(ItemStack stack) {
        ArmorItem armorItem;
        Item item = stack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.NETHERITE;
    }

    public static void setBit(LivingEntity entity, EquipmentSlot slot) {
        CompoundTag nbt = entity.getPersistentData();
        byte bits = nbt.m_128445_(NETHERITE_DIVING_BITS_KEY);
        if ((bits & 0xF) == 15) {
            return;
        }
        bits = (byte)(bits | 1 << slot.m_20749_());
        nbt.m_128344_(NETHERITE_DIVING_BITS_KEY, bits);
        if ((bits & 0xF) == 15) {
            NetheriteJetpackExoskeletonHandlerProcedure.setFireImmune(entity, true);
        }
    }

    public static void clearBit(LivingEntity entity, EquipmentSlot slot) {
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(NETHERITE_DIVING_BITS_KEY)) {
            return;
        }
        byte bits = nbt.m_128445_(NETHERITE_DIVING_BITS_KEY);
        boolean prevFullSet = (bits & 0xF) == 15;
        bits = (byte)(bits & ~(1 << slot.m_20749_()));
        nbt.m_128344_(NETHERITE_DIVING_BITS_KEY, bits);
        if (prevFullSet) {
            NetheriteJetpackExoskeletonHandlerProcedure.setFireImmune(entity, false);
        }
    }

    public static void setFireImmune(LivingEntity entity, boolean fireImmune) {
        entity.getPersistentData().m_128379_(FIRE_IMMUNE_KEY, fireImmune);
    }
}

