/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.item;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

@AutoRegisterCapability
public class CustomFluidHandlerItemStack
extends FluidHandlerItemStack {
    private final int capacity;
    private final String tankType;

    public CustomFluidHandlerItemStack(ItemStack container, int capacity, String tankType) {
        super(container, capacity);
        this.capacity = capacity;
        this.tankType = tankType;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isValidFluid(resource)) {
            return 0;
        }
        int amount = resource.getAmount();
        int filled = Math.min(amount, this.capacity - this.getFluidInTank(0).getAmount());
        if (action.execute()) {
            FluidStack newFluid = new FluidStack(resource.getFluid(), this.getFluidInTank(0).getAmount() + filled);
            this.setFluid(newFluid);
        }
        return filled;
    }

    public int drainTank(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isValidFluid(resource)) {
            return 0;
        }
        int amount = -resource.getAmount();
        int filled = Math.min(amount, this.capacity - this.getFluidInTank(0).getAmount());
        if (action.execute()) {
            FluidStack newFluid = new FluidStack(resource.getFluid(), this.getFluidInTank(0).getAmount() + filled);
            this.setFluid(newFluid);
        }
        return filled;
    }

    private static void fillFluid(ItemStack stack, int input) {
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            capability.ifPresent(handler -> {
                if (handler instanceof CustomFluidHandlerItemStack) {
                    if (((CustomFluidHandlerItemStack)handler).tankType == "fuel") {
                        ((CustomFluidHandlerItemStack)((Object)handler)).fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76195_, input), input), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (((CustomFluidHandlerItemStack)handler).tankType == "water") {
                        ((CustomFluidHandlerItemStack)((Object)handler)).fill(new FluidStack(new FluidStack((Fluid)Fluids.f_76193_, input), input), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            });
        }
    }

    private static void drainFluid(ItemStack stack, int input) {
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            capability.ifPresent(handler -> {
                if (handler instanceof CustomFluidHandlerItemStack) {
                    if (((CustomFluidHandlerItemStack)handler).tankType == "fuel") {
                        ((CustomFluidHandlerItemStack)((Object)handler)).drainTank(new FluidStack(new FluidStack((Fluid)Fluids.f_76195_, input), input), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (((CustomFluidHandlerItemStack)handler).tankType == "water") {
                        ((CustomFluidHandlerItemStack)((Object)handler)).drainTank(new FluidStack(new FluidStack((Fluid)Fluids.f_76193_, input), input), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            });
        }
    }

    public static boolean isTankFillable(Player player, ItemStack stack) {
        IFluidHandler handler;
        Level world = player.m_9236_();
        if (!world.m_5776_() && (handler = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)) != null) {
            return handler.getFluidInTank(0).getAmount() < handler.getTankCapacity(0);
        }
        return false;
    }

    public static int isTankEmpty(Player player, ItemStack stack) {
        IFluidHandler handler;
        Level world = player.m_9236_();
        if (!world.m_5776_() && (handler = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null)) != null) {
            return handler.getFluidInTank(0).getAmount();
        }
        return 0;
    }

    public static void doFillTank(Player player, ItemStack stack, int input) {
        Level world = player.m_9236_();
        if (!world.m_5776_()) {
            if (input > 0) {
                CustomFluidHandlerItemStack.fillFluid(stack, input);
            } else {
                CustomFluidHandlerItemStack.drainFluid(stack, -input);
            }
        }
    }

    private boolean isValidFluid(FluidStack fluid) {
        if (this.tankType == "water") {
            return fluid.getFluid().m_205067_(TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation("create_sa", "water_fluid")));
        }
        if (this.tankType == "fuel") {
            return fluid.getFluid().m_205067_(TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation("create_sa", "fuel_fluid")));
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

