/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs.grizzly_bear;

import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.datagen.loottables.AMILootTables;
import com.crimsoncrips.alexsmobsinteraction.datagen.tags.AMIEntityTagGenerator;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.crimsoncrips.alexsmobsinteraction.misc.UrsaBossEvent;
import com.crimsoncrips.alexsmobsinteraction.misc.interfaces.GrizzlyExtras;
import com.crimsoncrips.alexsmobsinteraction.server.goal.AMIGrizzlyScavenge;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityGrizzlyBear;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityGrizzlyBear.class})
public abstract class AMIGrizzlyBear
extends Animal
implements GrizzlyExtras {
    private final UrsaBossEvent bossEvent = new UrsaBossEvent(Component.m_130674_((String)"Ulfsaar"), 0);
    private static final EntityDataAccessor<Integer> NO_HONEY = SynchedEntityData.m_135353_(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> URSA = SynchedEntityData.m_135353_(EntityGrizzlyBear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    public abstract boolean isHoneyed();

    protected AMIGrizzlyBear(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.isUrsa()) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (this.isUrsa()) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (this.isUrsa()) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$registerGoals(CallbackInfo ci) {
        final EntityGrizzlyBear grizzlyBear = (EntityGrizzlyBear)this;
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.GRIZZLY_PACIFIED_ENABLED.get()).booleanValue()) {
            grizzlyBear.f_21346_.m_25352_(2, (Goal)new EntityAINearestTarget3D<Player>((Mob)grizzlyBear, Player.class, 10, true, true, null){

                public boolean m_8036_() {
                    return super.m_8036_() && !grizzlyBear.m_21824_();
                }
            });
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.STORED_HUNGER_ENABLED.get()).booleanValue()) {
            grizzlyBear.f_21345_.m_25352_(6, (Goal)new AMIGrizzlyScavenge(grizzlyBear, 1.2, 12));
        }
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.HONEYLESS_HUNTING_ENABLED.get()).booleanValue()) {
            grizzlyBear.f_21346_.m_25352_(3, (Goal)new EntityAINearestTarget3D<LivingEntity>((Mob)grizzlyBear, LivingEntity.class, 500, true, true, AMEntityRegistry.buildPredicateFromTag(AMIEntityTagGenerator.GRIZZLY_BEAR_KILL)){

                public boolean m_8036_() {
                    return super.m_8036_() && !grizzlyBear.m_21824_() && !grizzlyBear.isEating() && !grizzlyBear.isHoneyed() && ((GrizzlyExtras)grizzlyBear).getNoHoney() >= 10000;
                }

                public boolean m_8045_() {
                    return super.m_8045_() && !grizzlyBear.m_21824_() && !grizzlyBear.isEating() && !grizzlyBear.isHoneyed();
                }
            });
        }
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=18)})
    private boolean alexsMobsInteraction$registerGoals2(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsMobsInteraction.COMMON_CONFIG.GRIZZLY_PACIFIED_ENABLED.get() == false;
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=19)})
    private boolean alexsMobsInteraction$registerGoals3(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsMobsInteraction.COMMON_CONFIG.GRIZZLY_PACIFIED_ENABLED.get() == false;
    }

    @Inject(method={"onGetItem"}, at={@At(value="TAIL")}, remap=false)
    private void alexsMobsInteraction$onGetItem(ItemEntity e, CallbackInfo ci) {
        if (e.m_32055_().m_41614_() && ((Boolean)AlexsMobsInteraction.COMMON_CONFIG.FOOD_TARGET_EFFECTS_ENABLED.get()).booleanValue()) {
            this.m_5634_(5.0f);
            List test = Objects.requireNonNull(e.m_32055_().getFoodProperties((LivingEntity)this)).m_38749_();
            if (!test.isEmpty()) {
                for (int i = 0; i < test.size(); ++i) {
                    this.m_7292_(new MobEffectInstance((MobEffectInstance)((Pair)test.get(i)).getFirst()));
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$tick(CallbackInfo ci) {
        if (this.isHoneyed()) {
            this.setNoHoney(0);
        } else {
            this.setNoHoney(this.getNoHoney() + 1);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = player.m_21120_(hand);
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.BRUSHED_ENABLED.get()).booleanValue() && itemStack.m_41720_() instanceof BrushItem && !this.m_9236_().f_46443_ && this.isHoneyed() && !this.isUrsa()) {
            if (!player.m_7500_()) {
                itemStack.m_41622_(15, (LivingEntity)player, p_233654_0_ -> {});
            }
            AMIUtils.spawnLoot(AMILootTables.GRIZZLY_BRUSH, (LivingEntity)this, (Entity)player, 0);
            this.m_5496_(SoundEvents.f_276624_, 1.0f, this.m_6100_());
            AMIUtils.awardAdvancement((Entity)player, "brushed", "brushed");
        }
    }

    @Override
    public int getNoHoney() {
        return (Integer)this.f_19804_.m_135370_(NO_HONEY);
    }

    @Override
    public void setNoHoney(int time) {
        this.f_19804_.m_135381_(NO_HONEY, (Object)time);
    }

    @Override
    public boolean isUrsa() {
        return (Boolean)this.f_19804_.m_135370_(URSA);
    }

    public void setUrsa(boolean ursa) {
        this.f_19804_.m_135381_(URSA, (Object)ursa);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void define(CallbackInfo ci) {
        this.f_19804_.m_135372_(NO_HONEY, (Object)0);
        this.f_19804_.m_135372_(URSA, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void add(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("NoHoney", this.getNoHoney());
        compound.m_128379_("Ursa", this.isUrsa());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsMobsInteraction$read(CompoundTag compound, CallbackInfo ci) {
        this.setNoHoney(compound.m_128451_("NoHoney"));
        this.setUrsa(compound.m_128471_("Ursa"));
    }
}

